/*
 * Copyright (c) 2003, Intel Corporation. All rights reserved.
 * Created by:  crystal.xiong REMOVE-THIS AT intel DOT com
 * This file is licensed under the GPL license.  For the full content
 * of this license, see the COPYING file at the top level of this
 * source tree.
 */

/*
 * mq_timedreceive() test plan:
 * mq_timedreceive() will fail with EINVAL if message queue is 
 * empty and nanoseconds field value of abs_timeout is less than 0.
 *
 */

#include <stdio.h>
#include <mqueue.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "posixtest.h"

#define TEST "17-1"
#define FUNCTION "mq_timedreceive"
#define ERROR_PREFIX "unexpected error: " FUNCTION " " TEST ": "

#define NAMESIZE 50
#define BUFFER 40

int main()
{
        char mqname[NAMESIZE], msgrv[BUFFER];
        mqd_t mqdes;
	struct timespec ts;
	struct mq_attr attr;
	int unresolved = 0, failure = 0;

	sprintf(mqname, "/" FUNCTION "_" TEST "_%d", getpid());

	attr.mq_msgsize = BUFFER;
	attr.mq_maxmsg = BUFFER;
	mqdes = mq_open(mqname, O_CREAT | O_RDWR, S_IRUSR | S_IWUSR, &attr);
        if (mqdes == (mqd_t)-1) {
                perror(ERROR_PREFIX "mq_open");
		unresolved = 1;
        }
	ts.tv_sec = time(NULL) + 1;
	ts.tv_nsec = -1;
       	if (mq_timedreceive(mqdes, msgrv, BUFFER, NULL, &ts) == -1) {
		if (EINVAL != errno) {
			printf("errno != EINVAL \n");
			failure = 1;
		}
	}
	else {
		printf("FAIL: mq_timedreceive() succeed unexpectly \n");
		failure = 1;
	}
       	if (mq_close(mqdes) != 0) {
		perror(ERROR_PREFIX "mq_close");
		unresolved = 1;
       	}
       	if (mq_unlink(mqname) != 0) {
		perror(ERROR_PREFIX "mq_unlink");
		unresolved = 1;
	}
	if (failure==1) {
          	printf("Test FAILED\n");
	        return PTS_FAIL;
       	}
        if (unresolved==1) {
               	printf("Test UNRESOLVED\n");
                return PTS_UNRESOLVED;
     	}
        printf("Test PASSED\n");
      	return PTS_PASS;
}

