/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.action;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.action.GradleDownloadSourceAction;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gradle/action/GradleAttachSourcesProvider;", "Lcom/intellij/codeInsight/AttachSourcesProvider;", "<init>", "()V", "getActions", "", "Lcom/intellij/codeInsight/AttachSourcesProvider$AttachSourcesAction;", "orderEntries", "", "Lcom/intellij/openapi/roots/LibraryOrderEntry;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getGradleModules", "", "Lcom/intellij/openapi/module/Module;", "libraryOrderEntries", "intellij.gradle.java"})
public final class GradleAttachSourcesProvider
implements AttachSourcesProvider {
    @NotNull
    public Collection<AttachSourcesProvider.AttachSourcesAction> getActions(@NotNull List<? extends LibraryOrderEntry> orderEntries, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter(orderEntries, (String)"orderEntries");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Map<LibraryOrderEntry, Module> gradleModules = this.getGradleModules(orderEntries);
        if (gradleModules.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        GradleDownloadSourceAction action = new GradleDownloadSourceAction(orderEntries, psiFile, () -> GradleAttachSourcesProvider.getActions$lambda$0(this, orderEntries));
        return CollectionsKt.listOf((Object)action);
    }

    private final Map<LibraryOrderEntry, Module> getGradleModules(List<? extends LibraryOrderEntry> libraryOrderEntries) {
        HashMap<LibraryOrderEntry, Module> result = new HashMap<LibraryOrderEntry, Module>();
        for (LibraryOrderEntry libraryOrderEntry : libraryOrderEntries) {
            Module module;
            if (libraryOrderEntry.isModuleLevel()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)libraryOrderEntry.getOwnerModule(), (String)"getOwnerModule(...)");
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) continue;
            result.put(libraryOrderEntry, module);
        }
        return result;
    }

    private static final Map getActions$lambda$0(GradleAttachSourcesProvider this$0, List $orderEntries) {
        return this$0.getGradleModules($orderEntries);
    }
}

