/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.dce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.dce.AnalysisResult;
import org.jetbrains.kotlin.js.dce.Context;
import org.jetbrains.kotlin.js.dce.UtilKt;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020%H\u0016J.\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u00142\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010)2\b\u0010+\u001a\u0004\u0018\u00010)H\u0002J\u001e\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020\u00122\f\u0010.\u001a\b\u0012\u0004\u0012\u00020)0/H\u0002J\u0010\u00100\u001a\u00020\u001f2\u0006\u0010 \u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u001f2\u0006\u0010 \u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u001f2\u0006\u0010 \u001a\u000205H\u0016J(\u00106\u001a\b\u0018\u00010\u000eR\u00020\u00032\b\u00107\u001a\u0004\u0018\u00010\r2\u0006\u00108\u001a\u00020)2\u0006\u00109\u001a\u00020)H\u0002J(\u0010:\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u000eR\u00020\u00030/\u0018\u00010;2\u0006\u0010<\u001a\u00020)H\u0002J\u001e\u0010=\u001a\u00020\u001f2\n\u0010(\u001a\u00060\u000eR\u00020\u00032\b\u0010>\u001a\u0004\u0018\u00010)H\u0002J\u0016\u0010?\u001a\b\u0018\u00010\u000eR\u00020\u00032\u0006\u0010<\u001a\u00020)H\u0002J\u001e\u0010@\u001a\u00020\u001f2\u0006\u0010A\u001a\u00020\b2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020)0/H\u0002J\"\u0010B\u001a\u00020\u001f2\u0006\u0010A\u001a\u00020\b2\u0010\u0010.\u001a\f\u0012\b\u0012\u00060\u000eR\u00020\u00030/H\u0002J\u0010\u0010C\u001a\u00020\u001f2\u0006\u0010A\u001a\u00020\bH\u0002J\u0018\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u00142\u0006\u0010G\u001a\u00020HH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u00060\u000eR\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0019\u001a\f\u0012\b\u0012\u00060\u000eR\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006I"}, d2={"Lorg/jetbrains/kotlin/js/dce/Analyzer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitor;", "context", "Lorg/jetbrains/kotlin/js/dce/Context;", "<init>", "(Lorg/jetbrains/kotlin/js/dce/Context;)V", "processedFunctions", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "postponedFunctions", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "nodeMap", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "Lorg/jetbrains/kotlin/js/dce/Context$Node;", "astNodesToEliminate", "astNodesToSkip", "invocationsToSkip", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "moduleMapping", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "", "getModuleMapping", "()Ljava/util/Map;", "functionsToEnter", "functionsToSkip", "analysisResult", "Lorg/jetbrains/kotlin/js/dce/AnalysisResult;", "getAnalysisResult", "()Lorg/jetbrains/kotlin/js/dce/AnalysisResult;", "visitVars", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "visit", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "visitExpressionStatement", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpressionStatement;", "handleObjectDefineProperty", "statement", "target", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "propertyName", "propertyDescriptor", "handleAmdDefine", "invocation", "arguments", "", "visitBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "visitIf", "Lorg/jetbrains/kotlin/js/backend/ast/JsIf;", "visitReturn", "Lorg/jetbrains/kotlin/js/backend/ast/JsReturn;", "processAssignment", "node", "lhs", "rhs", "tryExtractFunction", "Lkotlin/Pair;", "expression", "handleObjectCreate", "arg", "extractVariableInitializedByEmptyObject", "enterFunction", "function", "enterFunctionWithGivenNodes", "processFunction", "isProperFunctionalParameter", "", "body", "parameter", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "js.dce"})
@SourceDebugExtension(value={"SMAP\nAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Analyzer.kt\norg/jetbrains/kotlin/js/dce/Analyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,428:1\n1863#2,2:429\n1557#2:432\n1628#2,3:433\n1557#2:436\n1628#2,3:437\n1863#2,2:440\n1863#2,2:442\n1863#2,2:444\n774#2:446\n865#2,2:447\n808#2,11:449\n1#3:431\n*S KotlinDebug\n*F\n+ 1 Analyzer.kt\norg/jetbrains/kotlin/js/dce/Analyzer\n*L\n51#1:429,2\n164#1:432\n164#1:433,3\n165#1:436\n165#1:437,3\n176#1:440,2\n245#1:442,2\n254#1:444,2\n307#1:446\n307#1:447,2\n316#1:449,11\n*E\n"})
public final class Analyzer
extends JsVisitor {
    @NotNull
    private final Context context;
    @NotNull
    private final Set<JsFunction> processedFunctions;
    @NotNull
    private final Map<JsName, JsFunction> postponedFunctions;
    @NotNull
    private final Map<JsNode, Context.Node> nodeMap;
    @NotNull
    private final Set<JsNode> astNodesToEliminate;
    @NotNull
    private final Set<JsNode> astNodesToSkip;
    @NotNull
    private final Set<JsInvocation> invocationsToSkip;
    @NotNull
    private final Map<JsStatement, String> moduleMapping;
    @NotNull
    private final Set<JsFunction> functionsToEnter;
    @NotNull
    private final Set<Context.Node> functionsToSkip;
    @NotNull
    private final AnalysisResult analysisResult;

    public Analyzer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
        this.processedFunctions = new LinkedHashSet();
        this.postponedFunctions = new LinkedHashMap();
        this.nodeMap = new LinkedHashMap();
        this.astNodesToEliminate = new LinkedHashSet();
        this.astNodesToSkip = new LinkedHashSet();
        this.invocationsToSkip = new LinkedHashSet();
        this.moduleMapping = new LinkedHashMap();
        this.functionsToEnter = new LinkedHashSet();
        this.functionsToSkip = new LinkedHashSet();
        this.analysisResult = new AnalysisResult(this){
            final /* synthetic */ Analyzer this$0;
            {
                this.this$0 = $receiver;
            }

            public Map<JsNode, Context.Node> getNodeMap() {
                return Analyzer.access$getNodeMap$p(this.this$0);
            }

            public Set<JsNode> getAstNodesToEliminate() {
                return Analyzer.access$getAstNodesToEliminate$p(this.this$0);
            }

            public Set<JsNode> getAstNodesToSkip() {
                return Analyzer.access$getAstNodesToSkip$p(this.this$0);
            }

            public Set<JsFunction> getFunctionsToEnter() {
                return Analyzer.access$getFunctionsToEnter$p(this.this$0);
            }

            public Set<JsInvocation> getInvocationsToSkip() {
                return Analyzer.access$getInvocationsToSkip$p(this.this$0);
            }

            public Set<Context.Node> getFunctionsToSkip() {
                return Analyzer.access$getFunctionsToSkip$p(this.this$0);
            }
        };
    }

    @NotNull
    public final Map<JsStatement, String> getModuleMapping() {
        return this.moduleMapping;
    }

    @NotNull
    public final AnalysisResult getAnalysisResult() {
        return this.analysisResult;
    }

    @Override
    public void visitVars(@NotNull JsVars x) {
        Intrinsics.checkNotNullParameter(x, "x");
        List<JsVars.JsVar> list = x.getVars();
        Intrinsics.checkNotNullExpressionValue(list, "getVars(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsVars.JsVar it = (JsVars.JsVar)element$iv;
            boolean bl = false;
            this.accept((JsNode)it);
        }
    }

    @Override
    public void visit(@NotNull JsVars.JsVar x) {
        block1: {
            Intrinsics.checkNotNullParameter(x, "x");
            JsExpression rhs = x.getInitExpression();
            if (rhs == null) break block1;
            JsNode jsNode = x;
            JsNameRef jsNameRef = x.getName().makeRef();
            Intrinsics.checkNotNullExpressionValue(jsNameRef, "makeRef(...)");
            Context.Node node = this.processAssignment(jsNode, jsNameRef, rhs);
            if (node != null) {
                Context.Node it = node;
                boolean bl = false;
                this.nodeMap.put(x, it);
            }
        }
    }

    @Override
    public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
        JsExpression expression2;
        Intrinsics.checkNotNullParameter(x, "x");
        JsExpression jsExpression = x.getExpression();
        Intrinsics.checkNotNullExpressionValue(jsExpression, "getExpression(...)");
        JsExpression jsExpression2 = expression2 = jsExpression;
        if (jsExpression2 instanceof JsBinaryOperation) {
            if (((JsBinaryOperation)expression2).getOperator() == JsBinaryOperator.ASG) {
                JsNode jsNode = x;
                JsExpression jsExpression3 = ((JsBinaryOperation)expression2).getArg1();
                Intrinsics.checkNotNullExpressionValue(jsExpression3, "getArg1(...)");
                JsExpression jsExpression4 = ((JsBinaryOperation)expression2).getArg2();
                Intrinsics.checkNotNullExpressionValue(jsExpression4, "getArg2(...)");
                Context.Node node = this.processAssignment(jsNode, jsExpression3, jsExpression4);
                if (node != null) {
                    Context.Node it = node;
                    boolean bl = false;
                    this.nodeMap.put(x, it);
                }
            }
        } else if (jsExpression2 instanceof JsFunction) {
            Object object = ((JsFunction)expression2).getName();
            if (object != null) {
                Object it = object;
                boolean bl = false;
                Context.Node node = this.context.getNodes().get(it);
                Context.Node node2 = node != null ? node.getOriginal() : null;
                object = node2;
                if (node2 != null) {
                    it = object;
                    boolean bl2 = false;
                    this.nodeMap.put(x, (Context.Node)it);
                    ((Context.Node)it).addFunction((JsFunction)expression2);
                }
            }
        } else if (jsExpression2 instanceof JsInvocation) {
            JsExpression jsExpression5 = ((JsInvocation)expression2).getQualifier();
            Intrinsics.checkNotNullExpressionValue(jsExpression5, "getQualifier(...)");
            JsExpression function2 = jsExpression5;
            if (function2 instanceof JsFunction) {
                JsFunction jsFunction = (JsFunction)function2;
                List<JsExpression> list = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
                this.enterFunction(jsFunction, list);
                return;
            }
            if (function2 instanceof JsNameRef && ((JsNameRef)function2).getQualifier() == null) {
                JsFunction postponedFunction;
                JsFunction jsFunction;
                JsName jsName = ((JsNameRef)function2).getName();
                if (jsName != null) {
                    JsName it = jsName;
                    boolean bl = false;
                    jsFunction = this.postponedFunctions.get(it);
                } else {
                    jsFunction = postponedFunction = null;
                }
                if (postponedFunction != null) {
                    List<JsExpression> list = ((JsInvocation)expression2).getArguments();
                    Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
                    this.enterFunction(postponedFunction, list);
                    ((Collection)this.invocationsToSkip).add(expression2);
                    return;
                }
            }
            if (UtilKt.isObjectDefineProperty(this.context, function2)) {
                JsStatement jsStatement = x;
                List<JsExpression> list = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
                List<JsExpression> list2 = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkNotNullExpressionValue(list2, "getArguments(...)");
                List<JsExpression> list3 = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkNotNullExpressionValue(list3, "getArguments(...)");
                this.handleObjectDefineProperty(jsStatement, CollectionsKt.getOrNull(list, 0), CollectionsKt.getOrNull(list2, 1), CollectionsKt.getOrNull(list3, 2));
            } else if (UtilKt.isDefineModule(this.context, function2)) {
                ((Collection)this.astNodesToEliminate).add(x);
            } else if (UtilKt.isAmdDefine(this.context, function2)) {
                JsInvocation jsInvocation = (JsInvocation)expression2;
                List<JsExpression> list = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
                this.handleAmdDefine(jsInvocation, list);
            }
        }
    }

    private final void handleObjectDefineProperty(JsStatement statement, JsExpression target, JsExpression propertyName, JsExpression propertyDescriptor) {
        if (target == null || !(propertyName instanceof JsStringLiteral) || propertyDescriptor == null) {
            return;
        }
        Context.Node node = this.context.extractNode(target);
        if (node == null) {
            return;
        }
        Context.Node targetNode = node;
        String string2 = ((JsStringLiteral)propertyName).getValue();
        Intrinsics.checkNotNullExpressionValue(string2, "getValue(...)");
        Context.Node memberNode = targetNode.member(string2);
        this.nodeMap.put(statement, memberNode);
        memberNode.setHasSideEffects(true);
        if (propertyDescriptor instanceof JsObjectLiteral) {
            for (JsPropertyInitializer initializer : ((JsObjectLiteral)propertyDescriptor).getPropertyInitializers()) {
                JsNode jsNode = statement;
                JsExpression jsExpression = new JsNameRef(((JsStringLiteral)propertyName).getValue(), target);
                JsExpression jsExpression2 = initializer.getValueExpr();
                Intrinsics.checkNotNullExpressionValue(jsExpression2, "getValueExpr(...)");
                this.processAssignment(jsNode, jsExpression, jsExpression2);
            }
        } else if (propertyDescriptor instanceof JsInvocation) {
            JsExpression jsExpression = ((JsInvocation)propertyDescriptor).getQualifier();
            Intrinsics.checkNotNullExpressionValue(jsExpression, "getQualifier(...)");
            JsExpression function2 = jsExpression;
            if (UtilKt.isObjectGetOwnPropertyDescriptor(this.context, function2)) {
                List<JsExpression> list = ((JsInvocation)propertyDescriptor).getArguments();
                Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
                JsExpression source = CollectionsKt.getOrNull(list, 0);
                List<JsExpression> list2 = ((JsInvocation)propertyDescriptor).getArguments();
                Intrinsics.checkNotNullExpressionValue(list2, "getArguments(...)");
                JsExpression sourcePropertyName = CollectionsKt.getOrNull(list2, 1);
                if (source != null && sourcePropertyName instanceof JsStringLiteral) {
                    this.processAssignment(statement, new JsNameRef(((JsStringLiteral)propertyName).getValue(), target), new JsNameRef(((JsStringLiteral)sourcePropertyName).getValue(), source));
                }
            }
        }
    }

    private final void handleAmdDefine(JsInvocation invocation, List<? extends JsExpression> arguments) {
        JsStringLiteral it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        JsFunction jsFunction;
        List<JsExpression> list;
        switch (arguments.size()) {
            case 2: {
                list = arguments;
                break;
            }
            case 3: {
                list = CollectionsKt.drop((Iterable)arguments, 1);
                break;
            }
            default: {
                return;
            }
        }
        List<? extends JsExpression> argumentsWithoutName = list;
        JsExpression jsExpression = argumentsWithoutName.get(0);
        JsArrayLiteral jsArrayLiteral = jsExpression instanceof JsArrayLiteral ? (JsArrayLiteral)jsExpression : null;
        if (jsArrayLiteral == null) {
            return;
        }
        JsArrayLiteral dependencies = jsArrayLiteral;
        JsExpression functionRef = argumentsWithoutName.get(1);
        JsExpression jsExpression2 = functionRef;
        if (jsExpression2 instanceof JsFunction) {
            jsFunction = (JsFunction)functionRef;
        } else if (jsExpression2 instanceof JsNameRef) {
            if (((JsNameRef)functionRef).getQualifier() != null) {
                return;
            }
            jsFunction = this.postponedFunctions.get(((JsNameRef)functionRef).getName());
            if (jsFunction == null) {
                return;
            }
        } else {
            return;
        }
        JsFunction function2 = jsFunction;
        List<JsExpression> list2 = dependencies.getExpressions();
        Intrinsics.checkNotNullExpressionValue(list2, "getExpressions(...)");
        Iterable iterable = list2;
        boolean $i$f$map = false;
        void var10_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JsExpression jsExpression3 = (JsExpression)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JsStringLiteral jsStringLiteral = it instanceof JsStringLiteral ? (JsStringLiteral)it : null;
            if (jsStringLiteral == null) {
                return;
            }
            collection.add(jsStringLiteral);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Context.Node node;
            it = (JsStringLiteral)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it.getValue(), "exports")) {
                node = this.context.getCurrentModule();
            } else {
                Context.Node node2 = this.context.getGlobalScope();
                String string2 = it.getValue();
                Intrinsics.checkNotNullExpressionValue(string2, "getValue(...)");
                node = node2.member(string2);
            }
            collection.add(node);
        }
        List dependencyNodes = (List)destination$iv$iv;
        this.enterFunctionWithGivenNodes(function2, dependencyNodes);
        ((Collection)this.astNodesToSkip).add(invocation.getQualifier());
    }

    @Override
    public void visitBlock(@NotNull JsBlock x) {
        Intrinsics.checkNotNullParameter(x, "x");
        String newModule = this.moduleMapping.get(x);
        if (newModule != null) {
            this.context.setCurrentModule(this.context.getGlobalScope().member(newModule));
        }
        List<JsStatement> list = x.getStatements();
        Intrinsics.checkNotNullExpressionValue(list, "getStatements(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsStatement it = (JsStatement)element$iv;
            boolean bl = false;
            this.accept((JsNode)it);
        }
    }

    @Override
    public void visitIf(@NotNull JsIf x) {
        block0: {
            Intrinsics.checkNotNullParameter(x, "x");
            this.accept((JsNode)x.getThenStatement());
            JsStatement jsStatement = x.getElseStatement();
            if (jsStatement == null) break block0;
            jsStatement.accept(this);
        }
    }

    @Override
    public void visitReturn(@NotNull JsReturn x) {
        block1: {
            Intrinsics.checkNotNullParameter(x, "x");
            JsExpression expr = x.getExpression();
            if (expr == null) break block1;
            Context.Node node = this.context.extractNode(expr);
            if (node != null) {
                Context.Node it = node;
                boolean bl = false;
                this.nodeMap.put(x, it);
            }
        }
    }

    private final Context.Node processAssignment(JsNode node, JsExpression lhs, JsExpression rhs) {
        Context.Node leftNode = this.context.extractNode(lhs);
        Context.Node rightNode = this.context.extractNode(rhs);
        if (leftNode != null && rightNode != null) {
            leftNode.alias(rightNode);
            return leftNode;
        }
        if (leftNode != null) {
            Context.Node nodeInitializedByEmptyObject;
            if (rhs instanceof JsInvocation) {
                Pair<JsFunction, List<Context.Node>> pair;
                JsExpression jsExpression = ((JsInvocation)rhs).getQualifier();
                Intrinsics.checkNotNullExpressionValue(jsExpression, "getQualifier(...)");
                JsExpression function2 = jsExpression;
                if (function2 instanceof JsFunction) {
                    JsFunction jsFunction = (JsFunction)function2;
                    List<JsExpression> list = ((JsInvocation)rhs).getArguments();
                    Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
                    this.enterFunction(jsFunction, list);
                    ((Collection)this.astNodesToSkip).add(lhs);
                    return null;
                }
                if (function2 instanceof JsNameRef && ((JsNameRef)function2).getQualifier() == null && (pair = ((JsNameRef)function2).getName()) != null) {
                    HasMetadata it = pair;
                    boolean bl = false;
                    JsFunction jsFunction = this.postponedFunctions.get(it);
                    if (jsFunction != null) {
                        it = jsFunction;
                        boolean bl2 = false;
                        List<JsExpression> list = ((JsInvocation)rhs).getArguments();
                        Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
                        this.enterFunction((JsFunction)it, list);
                        ((Collection)this.astNodesToSkip).add(lhs);
                        return null;
                    }
                }
                if (UtilKt.isObjectFunction(this.context, function2, "create")) {
                    List<JsExpression> list = ((JsInvocation)rhs).getArguments();
                    Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
                    this.handleObjectCreate(leftNode, CollectionsKt.getOrNull(list, 0));
                    return leftNode;
                }
                if (UtilKt.isDefineInlineFunction(this.context, function2) && ((JsInvocation)rhs).getArguments().size() == 2) {
                    JsExpression jsExpression2 = ((JsInvocation)rhs).getArguments().get(1);
                    Intrinsics.checkNotNullExpressionValue(jsExpression2, "get(...)");
                    pair = this.tryExtractFunction(jsExpression2);
                    if (pair != null) {
                        Pair<JsFunction, List<Context.Node>> pair2 = pair;
                        boolean bl = false;
                        JsFunction inlineableFunction = pair2.component1();
                        List<Context.Node> additionalDeps = pair2.component2();
                        leftNode.addFunction(inlineableFunction);
                        Context.Node defineInlineFunctionNode = this.context.extractNode(function2);
                        if (defineInlineFunctionNode != null) {
                            leftNode.addDependency(defineInlineFunctionNode);
                        }
                        Iterable $this$forEach$iv = additionalDeps;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Context.Node it = (Context.Node)element$iv;
                            boolean bl3 = false;
                            leftNode.addDependency(it);
                        }
                        return leftNode;
                    }
                }
                if ((pair = this.tryExtractFunction(rhs)) != null) {
                    Pair<JsFunction, List<Context.Node>> pair3 = pair;
                    boolean bl = false;
                    JsFunction functionBody = (JsFunction)pair3.component1();
                    List additionalDeps = (List)pair3.component2();
                    leftNode.addFunction(functionBody);
                    Iterable $this$forEach$iv = additionalDeps;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Context.Node it = (Context.Node)element$iv;
                        boolean bl4 = false;
                        leftNode.addDependency(it);
                    }
                    return leftNode;
                }
            } else if (rhs instanceof JsBinaryOperation) {
                if (((JsBinaryOperation)rhs).getOperator() == JsBinaryOperator.OR) {
                    JsExpression jsExpression = ((JsBinaryOperation)rhs).getArg1();
                    Intrinsics.checkNotNullExpressionValue(jsExpression, "getArg1(...)");
                    Context.Node secondNode = this.context.extractNode(jsExpression);
                    JsExpression reassignment = ((JsBinaryOperation)rhs).getArg2();
                    if (reassignment instanceof JsBinaryOperation && ((JsBinaryOperation)reassignment).getOperator() == JsBinaryOperator.ASG) {
                        JsExpression jsExpression3 = ((JsBinaryOperation)reassignment).getArg1();
                        Intrinsics.checkNotNullExpressionValue(jsExpression3, "getArg1(...)");
                        Context.Node reassignNode = this.context.extractNode(jsExpression3);
                        JsExpression reassignValue = ((JsBinaryOperation)reassignment).getArg2();
                        if (Intrinsics.areEqual(reassignNode, secondNode) && reassignNode != null && reassignValue instanceof JsObjectLiteral && ((JsObjectLiteral)reassignValue).getPropertyInitializers().isEmpty()) {
                            JsExpression jsExpression4 = ((JsBinaryOperation)rhs).getArg1();
                            Intrinsics.checkNotNullExpressionValue(jsExpression4, "getArg1(...)");
                            return this.processAssignment(node, lhs, jsExpression4);
                        }
                    }
                }
            } else {
                if (rhs instanceof JsFunction) {
                    leftNode.addFunction((JsFunction)rhs);
                    return leftNode;
                }
                if (Intrinsics.areEqual(leftNode.getMemberName(), "$metadata$")) {
                    leftNode.addExpression(rhs);
                    return leftNode;
                }
                if (rhs instanceof JsObjectLiteral && ((JsObjectLiteral)rhs).getPropertyInitializers().isEmpty()) {
                    return leftNode;
                }
            }
            if ((nodeInitializedByEmptyObject = this.extractVariableInitializedByEmptyObject(rhs)) != null) {
                ((Collection)this.astNodesToSkip).add(rhs);
                leftNode.alias(nodeInitializedByEmptyObject);
                return leftNode;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<JsFunction, List<Context.Node>> tryExtractFunction(JsExpression expression2) {
        JsExpression jsExpression = expression2;
        if (jsExpression instanceof JsFunction) {
            return new Pair(expression2, CollectionsKt.emptyList());
        }
        if (jsExpression instanceof JsInvocation) {
            JsExpression jsExpression2 = ((JsInvocation)expression2).getQualifier();
            Intrinsics.checkNotNullExpressionValue(jsExpression2, "getQualifier(...)");
            if (UtilKt.isWrapFunction(this.context, jsExpression2)) {
                JsFunction jsFunction;
                List<JsExpression> list = ((JsInvocation)expression2).getArguments();
                Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
                JsExpression jsExpression3 = CollectionsKt.getOrNull(list, 0);
                JsFunction jsFunction2 = jsFunction = jsExpression3 instanceof JsFunction ? (JsFunction)jsExpression3 : null;
                if (jsFunction != null) {
                    void $this$filterIsInstanceTo$iv$iv;
                    Context.Node node;
                    void $this$filterTo$iv$iv;
                    JsFunction wrapper = jsFunction;
                    boolean bl = false;
                    List<JsStatement> list2 = wrapper.getBody().getStatements();
                    Intrinsics.checkNotNullExpressionValue(list2, "getStatements(...)");
                    Iterable $this$filter$iv = list2;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        JsStatement it = (JsStatement)element$iv$iv;
                        boolean bl2 = false;
                        if (!(!(it instanceof JsReturn))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List statementsWithoutBody = (List)destination$iv$iv;
                    JsBlock it = new JsBlock(statementsWithoutBody);
                    boolean bl3 = false;
                    this.context.addNodesForLocalVars((Collection<? extends JsName>)CollectUtilsKt.collectDefinedNames(it));
                    this.accept((JsNode)it);
                    JsExpression jsExpression4 = ((JsInvocation)expression2).getQualifier();
                    Intrinsics.checkNotNullExpressionValue(jsExpression4, "getQualifier(...)");
                    Context.Node node2 = this.context.extractNode(jsExpression4);
                    if (node2 != null) {
                        Context.Node node3;
                        Context.Node it2 = node3 = node2;
                        boolean bl4 = false;
                        ((Collection)this.functionsToSkip).add(it2);
                        node = node3;
                    } else {
                        node = null;
                    }
                    Context.Node wrapperNode = node;
                    List<JsStatement> list3 = wrapper.getBody().getStatements();
                    Intrinsics.checkNotNullExpressionValue(list3, "getStatements(...)");
                    Iterable $this$filterIsInstance$iv = list3;
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable2 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof JsReturn)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    JsExpression jsExpression5 = ((JsReturn)CollectionsKt.first((List)destination$iv$iv2)).getExpression();
                    Intrinsics.checkNotNull(jsExpression5, "null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsFunction");
                    JsFunction body2 = (JsFunction)jsExpression5;
                    return new Pair<JsFunction, List<Context.Node>>(body2, CollectionsKt.listOfNotNull(wrapperNode));
                }
            }
        }
        return null;
    }

    private final void handleObjectCreate(Context.Node target, JsExpression arg) {
        if (arg == null) {
            return;
        }
        Context.Node node = this.context.extractNode(arg);
        if (node == null) {
            return;
        }
        Context.Node prototypeNode = node;
        target.addDependency(prototypeNode.getOriginal());
        target.addExpression(arg);
    }

    private final Context.Node extractVariableInitializedByEmptyObject(JsExpression expression2) {
        if (!(expression2 instanceof JsConditional)) {
            return null;
        }
        JsExpression jsExpression = ((JsConditional)expression2).getTestExpression();
        JsBinaryOperation jsBinaryOperation = jsExpression instanceof JsBinaryOperation ? (JsBinaryOperation)jsExpression : null;
        if (jsBinaryOperation == null) {
            return null;
        }
        JsBinaryOperation testExpr = jsBinaryOperation;
        if (testExpr.getOperator() != JsBinaryOperator.REF_EQ) {
            return null;
        }
        JsExpression jsExpression2 = testExpr.getArg1();
        JsPrefixOperation jsPrefixOperation = jsExpression2 instanceof JsPrefixOperation ? (JsPrefixOperation)jsExpression2 : null;
        if (jsPrefixOperation == null) {
            return null;
        }
        JsPrefixOperation testExprLhs = jsPrefixOperation;
        if (testExprLhs.getOperator() != JsUnaryOperator.TYPEOF) {
            return null;
        }
        JsExpression jsExpression3 = testExprLhs.getArg();
        Intrinsics.checkNotNullExpressionValue(jsExpression3, "getArg(...)");
        Context.Node node = this.context.extractNode(jsExpression3);
        if (node == null) {
            return null;
        }
        Context.Node testExprNode = node;
        JsExpression jsExpression4 = testExpr.getArg2();
        JsStringLiteral jsStringLiteral = jsExpression4 instanceof JsStringLiteral ? (JsStringLiteral)jsExpression4 : null;
        if (jsStringLiteral == null) {
            return null;
        }
        JsStringLiteral testExprRhs = jsStringLiteral;
        if (!Intrinsics.areEqual(testExprRhs.getValue(), "undefined")) {
            return null;
        }
        JsExpression jsExpression5 = ((JsConditional)expression2).getThenExpression();
        JsObjectLiteral jsObjectLiteral = jsExpression5 instanceof JsObjectLiteral ? (JsObjectLiteral)jsExpression5 : null;
        if (jsObjectLiteral == null) {
            return null;
        }
        JsObjectLiteral thenExpr = jsObjectLiteral;
        List<JsPropertyInitializer> list = thenExpr.getPropertyInitializers();
        Intrinsics.checkNotNullExpressionValue(list, "getPropertyInitializers(...)");
        if (!((Collection)list).isEmpty()) {
            return null;
        }
        JsExpression jsExpression6 = ((JsConditional)expression2).getElseExpression();
        Intrinsics.checkNotNullExpressionValue(jsExpression6, "getElseExpression(...)");
        Context.Node node2 = this.context.extractNode(jsExpression6);
        if (node2 == null) {
            return null;
        }
        Context.Node elseNode = node2;
        if (!Intrinsics.areEqual(testExprNode.getOriginal(), elseNode.getOriginal())) {
            return null;
        }
        return testExprNode.getOriginal();
    }

    private final void enterFunction(JsFunction function2, List<? extends JsExpression> arguments) {
        ((Collection)this.functionsToEnter).add(function2);
        this.context.addNodesForLocalVars(CollectUtilsKt.collectLocalVariables$default(function2, false, 1, null));
        JsBlock jsBlock = function2.getBody();
        Intrinsics.checkNotNullExpressionValue(jsBlock, "getBody(...)");
        this.context.markSpecialFunctions(jsBlock);
        List<JsParameter> list = function2.getParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
        for (Pair pair : CollectionsKt.zip((Iterable)list, (Iterable)arguments)) {
            JsParameter param = (JsParameter)pair.component1();
            JsExpression arg = (JsExpression)pair.component2();
            if (arg instanceof JsFunction && ((JsFunction)arg).getName() == null) {
                JsBlock jsBlock2 = ((JsFunction)arg).getBody();
                Intrinsics.checkNotNullExpressionValue(jsBlock2, "getBody(...)");
                JsStatement jsStatement = jsBlock2;
                Intrinsics.checkNotNull(param);
                if (this.isProperFunctionalParameter(jsStatement, param)) {
                    this.postponedFunctions.put(param.getName(), (JsFunction)arg);
                    continue;
                }
            }
            JsNode jsNode = function2;
            JsNameRef jsNameRef = param.getName().makeRef();
            Intrinsics.checkNotNullExpressionValue(jsNameRef, "makeRef(...)");
            if (this.processAssignment(jsNode, jsNameRef, arg) == null) continue;
            ((Collection)this.astNodesToSkip).add(arg);
        }
        this.processFunction(function2);
    }

    private final void enterFunctionWithGivenNodes(JsFunction function2, List<Context.Node> arguments) {
        ((Collection)this.functionsToEnter).add(function2);
        this.context.addNodesForLocalVars(CollectUtilsKt.collectLocalVariables$default(function2, false, 1, null));
        JsBlock jsBlock = function2.getBody();
        Intrinsics.checkNotNullExpressionValue(jsBlock, "getBody(...)");
        this.context.markSpecialFunctions(jsBlock);
        List<JsParameter> list = function2.getParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
        for (Pair pair : CollectionsKt.zip((Iterable)list, (Iterable)arguments)) {
            Context.Node paramNode;
            JsParameter param = (JsParameter)pair.component1();
            Context.Node arg = (Context.Node)pair.component2();
            Intrinsics.checkNotNull(this.context.getNodes().get(param.getName()));
            paramNode.alias(arg);
        }
        this.processFunction(function2);
    }

    private final void processFunction(JsFunction function2) {
        if (this.processedFunctions.add(function2)) {
            this.accept((JsNode)function2.getBody());
        }
    }

    private final boolean isProperFunctionalParameter(JsStatement body2, JsParameter parameter) {
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        result2.element = true;
        body2.accept(new RecursiveJsVisitor(parameter, this, result2){
            final /* synthetic */ JsParameter $parameter;
            final /* synthetic */ Analyzer this$0;
            final /* synthetic */ Ref.BooleanRef $result;
            {
                this.$parameter = $parameter;
                this.this$0 = $receiver;
                this.$result = $result;
            }

            /*
             * WARNING - void declaration
             */
            public void visitInvocation(JsInvocation invocation) {
                Intrinsics.checkNotNullParameter(invocation, "invocation");
                JsExpression jsExpression = invocation.getQualifier();
                Intrinsics.checkNotNullExpressionValue(jsExpression, "getQualifier(...)");
                JsExpression qualifier = jsExpression;
                if (qualifier instanceof JsNameRef && ((JsNameRef)qualifier).getQualifier() == null && Intrinsics.areEqual(((JsNameRef)qualifier).getName(), this.$parameter.getName())) {
                    boolean bl;
                    block6: {
                        void $this$all$iv;
                        List<JsExpression> list = invocation.getArguments();
                        Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
                        Iterable iterable = list;
                        Analyzer analyzer2 = this.this$0;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                JsExpression it = (JsExpression)element$iv;
                                boolean bl2 = false;
                                Context context = Analyzer.access$getContext$p(analyzer2);
                                Intrinsics.checkNotNull(it);
                                if (context.extractNode(it) != null) continue;
                                bl = false;
                                break block6;
                            }
                            bl = true;
                        }
                    }
                    if (bl) {
                        return;
                    }
                }
                if (UtilKt.isAmdDefine(Analyzer.access$getContext$p(this.this$0), qualifier)) {
                    return;
                }
                super.visitInvocation(invocation);
            }

            public void visitNameRef(JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter(nameRef, "nameRef");
                if (Intrinsics.areEqual(nameRef.getName(), this.$parameter.getName())) {
                    this.$result.element = false;
                }
                super.visitNameRef(nameRef);
            }
        });
        return result2.element;
    }

    public static final /* synthetic */ Context access$getContext$p(Analyzer $this) {
        return $this.context;
    }

    public static final /* synthetic */ Map access$getNodeMap$p(Analyzer $this) {
        return $this.nodeMap;
    }

    public static final /* synthetic */ Set access$getAstNodesToEliminate$p(Analyzer $this) {
        return $this.astNodesToEliminate;
    }

    public static final /* synthetic */ Set access$getAstNodesToSkip$p(Analyzer $this) {
        return $this.astNodesToSkip;
    }

    public static final /* synthetic */ Set access$getFunctionsToEnter$p(Analyzer $this) {
        return $this.functionsToEnter;
    }

    public static final /* synthetic */ Set access$getInvocationsToSkip$p(Analyzer $this) {
        return $this.invocationsToSkip;
    }

    public static final /* synthetic */ Set access$getFunctionsToSkip$p(Analyzer $this) {
        return $this.functionsToSkip;
    }
}

