/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.deserialization;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.deserialization.LibraryPathFilter;
import org.jetbrains.kotlin.fir.deserialization.ModuleDataProvider;
import org.jetbrains.kotlin.platform.TargetPlatform;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/MultipleModuleDataProvider;", "Lorg/jetbrains/kotlin/fir/deserialization/ModuleDataProvider;", "moduleDataWithFilters", "", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "Lorg/jetbrains/kotlin/fir/deserialization/LibraryPathFilter;", "<init>", "(Ljava/util/Map;)V", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "allModuleData", "", "getAllModuleData", "()Ljava/util/Collection;", "getModuleData", "path", "Ljava/nio/file/Path;", "fir-deserialization"})
@SourceDebugExtension(value={"SMAP\nModuleDataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleDataProvider.kt\norg/jetbrains/kotlin/fir/deserialization/MultipleModuleDataProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,54:1\n1#2:55\n214#3,10:56\n*S KotlinDebug\n*F\n+ 1 ModuleDataProvider.kt\norg/jetbrains/kotlin/fir/deserialization/MultipleModuleDataProvider\n*L\n34#1:56,10\n*E\n"})
public final class MultipleModuleDataProvider
extends ModuleDataProvider {
    @NotNull
    private final Map<FirModuleData, LibraryPathFilter> moduleDataWithFilters;
    @NotNull
    private final TargetPlatform platform;

    public MultipleModuleDataProvider(@NotNull Map<FirModuleData, ? extends LibraryPathFilter> moduleDataWithFilters) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(moduleDataWithFilters, "moduleDataWithFilters");
            this.moduleDataWithFilters = moduleDataWithFilters;
            if (!(!this.moduleDataWithFilters.isEmpty())) {
                boolean $i$a$-require-MultipleModuleDataProvider$22 = false;
                String $i$a$-require-MultipleModuleDataProvider$22 = "ModuleDataProvider must contain at least one module data";
                throw new IllegalArgumentException($i$a$-require-MultipleModuleDataProvider$22.toString());
            }
            Iterable $this$same$iv = this.moduleDataWithFilters.keySet();
            boolean $i$f$same = false;
            Iterator iterator$iv = $this$same$iv.iterator();
            FirModuleData it = (FirModuleData)iterator$iv.next();
            boolean bl2 = false;
            TargetPlatform firstValue$iv = it.getPlatform();
            while (iterator$iv.hasNext()) {
                Object item$iv = iterator$iv.next();
                FirModuleData it2 = (FirModuleData)item$iv;
                $i$a$-same-MultipleModuleDataProvider$2 = false;
                TargetPlatform value$iv = it2.getPlatform();
                if (Intrinsics.areEqual(value$iv, firstValue$iv)) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        if (!bl) {
            boolean bl3 = false;
            String string2 = "All module data should have same target platform, but was: " + CollectionsKt.joinToString$default(this.moduleDataWithFilters.keySet(), null, null, null, 0, null, MultipleModuleDataProvider::lambda$3$lambda$2, 31, null);
            throw new IllegalArgumentException(string2.toString());
        }
        this.platform = ((FirModuleData)CollectionsKt.first((Iterable)this.getAllModuleData())).getPlatform();
    }

    @Override
    @NotNull
    public TargetPlatform getPlatform() {
        return this.platform;
    }

    @Override
    @NotNull
    public Collection<FirModuleData> getAllModuleData() {
        return this.moduleDataWithFilters.keySet();
    }

    @Override
    @Nullable
    public FirModuleData getModuleData(@Nullable Path path) {
        for (Map.Entry<FirModuleData, LibraryPathFilter> entry : this.moduleDataWithFilters.entrySet()) {
            FirModuleData session2 = entry.getKey();
            LibraryPathFilter filter = entry.getValue();
            if (!filter.accepts(path)) continue;
            return session2;
        }
        return null;
    }

    private static final CharSequence lambda$3$lambda$2(FirModuleData it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getName().asString() + ": " + it.getPlatform();
    }
}

