/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors.inference;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSession;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSessionBuilderKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u000eJ\u0014\u0010\u001a\u001a\u00020\u00002\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\"H\u0004J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$H\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\n\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000f0\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GroovyInferenceSessionBuilder;", "", "context", "Lcom/intellij/psi/PsiElement;", "candidate", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyMethodCandidate;", "contextSubstitutor", "Lcom/intellij/psi/PsiSubstitutor;", "<init>", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyMethodCandidate;Lcom/intellij/psi/PsiSubstitutor;)V", "expressionFilters", "", "Lkotlin/Function1;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/ExpressionPredicate;", "getExpressionFilters", "()Ljava/util/Set;", "setExpressionFilters", "(Ljava/util/Set;)V", "skipClosureBlock", "getSkipClosureBlock", "()Z", "setSkipClosureBlock", "(Z)V", "resolveMode", "ignoreArguments", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "skipClosureIn", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrCall;", "collectExpressionFilters", "", "build", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GroovyInferenceSession;", "doBuild", "basicSession", "intellij.groovy.psi"})
public class GroovyInferenceSessionBuilder {
    @NotNull
    private final PsiElement context;
    @NotNull
    private final GroovyMethodCandidate candidate;
    @NotNull
    private final PsiSubstitutor contextSubstitutor;
    @NotNull
    private Set<Function1<GrExpression, Boolean>> expressionFilters;
    private boolean skipClosureBlock;

    public GroovyInferenceSessionBuilder(@NotNull PsiElement context, @NotNull GroovyMethodCandidate candidate, @NotNull PsiSubstitutor contextSubstitutor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)contextSubstitutor, (String)"contextSubstitutor");
        this.context = context;
        this.candidate = candidate;
        this.contextSubstitutor = contextSubstitutor;
        this.expressionFilters = new LinkedHashSet();
        this.skipClosureBlock = true;
    }

    @NotNull
    protected final Set<Function1<GrExpression, Boolean>> getExpressionFilters() {
        return this.expressionFilters;
    }

    protected final void setExpressionFilters(@NotNull Set<Function1<GrExpression, Boolean>> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.expressionFilters = set;
    }

    protected final boolean getSkipClosureBlock() {
        return this.skipClosureBlock;
    }

    protected final void setSkipClosureBlock(boolean bl) {
        this.skipClosureBlock = bl;
    }

    @NotNull
    public final GroovyInferenceSessionBuilder resolveMode(boolean skipClosureBlock) {
        this.skipClosureBlock = skipClosureBlock;
        return this;
    }

    @NotNull
    public final GroovyInferenceSessionBuilder ignoreArguments(@NotNull Collection<? extends Argument> arguments2) {
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        this.expressionFilters.add((Function1<GrExpression, Boolean>)((Function1)arg_0 -> GroovyInferenceSessionBuilder.ignoreArguments$lambda$0(arguments2, arg_0)));
        return this;
    }

    @NotNull
    public final GroovyInferenceSessionBuilder skipClosureIn(@NotNull GrCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        this.expressionFilters.add((Function1<GrExpression, Boolean>)((Function1)arg_0 -> GroovyInferenceSessionBuilder.skipClosureIn$lambda$1(call, arg_0)));
        return this;
    }

    protected final void collectExpressionFilters() {
        if (this.skipClosureBlock) {
            this.expressionFilters.add((Function1<GrExpression, Boolean>)GroovyInferenceSessionBuilderKt.access$getIgnoreFunctionalExpressions$p());
        }
    }

    @NotNull
    public GroovyInferenceSession build() {
        this.collectExpressionFilters();
        PsiTypeParameter[] psiTypeParameterArray = this.candidate.getMethod().getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray, (String)"getTypeParameters(...)");
        GroovyInferenceSession session = new GroovyInferenceSession(psiTypeParameterArray, this.contextSubstitutor, this.context, this.skipClosureBlock, this.expressionFilters);
        return this.doBuild(session);
    }

    @NotNull
    protected final GroovyInferenceSession doBuild(@NotNull GroovyInferenceSession basicSession) {
        Intrinsics.checkNotNullParameter((Object)((Object)basicSession), (String)"basicSession");
        GroovyInferenceSession.initArgumentConstraints$default(basicSession, this.candidate.getArgumentMapping(), null, 2, null);
        return basicSession;
    }

    private static final boolean ignoreArguments$lambda$0(Collection $arguments, GrExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$arguments.contains(new ExpressionArgument(it));
    }

    private static final boolean skipClosureIn$lambda$1(GrCall $call, GrExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it instanceof GrFunctionalExpression) || !Intrinsics.areEqual((Object)$call, (Object)GrDelegatesToUtilKt.getContainingCall((GrFunctionalExpression)it));
    }
}

