/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.wrapper.impl;

import com.intellij.debugger.streams.wrapper.CallArgument;
import com.intellij.debugger.streams.wrapper.IntermediateStreamCall;
import com.intellij.debugger.streams.wrapper.MethodCall;
import com.intellij.debugger.streams.wrapper.QualifierExpression;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.debugger.streams.wrapper.TerminatorStreamCall;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class StreamChainImpl
implements StreamChain {
    private final QualifierExpression myQualifierExpression;
    private final List<? extends IntermediateStreamCall> myIntermediateCalls;
    private final TerminatorStreamCall myTerminator;
    private final PsiElement myContext;

    public StreamChainImpl(@NotNull QualifierExpression qualifierExpression, @NotNull List<? extends IntermediateStreamCall> intermediateCalls, @NotNull TerminatorStreamCall terminator, @NotNull PsiElement context) {
        if (qualifierExpression == null) {
            StreamChainImpl.$$$reportNull$$$0(0);
        }
        if (intermediateCalls == null) {
            StreamChainImpl.$$$reportNull$$$0(1);
        }
        if (terminator == null) {
            StreamChainImpl.$$$reportNull$$$0(2);
        }
        if (context == null) {
            StreamChainImpl.$$$reportNull$$$0(3);
        }
        this.myQualifierExpression = qualifierExpression;
        this.myIntermediateCalls = intermediateCalls;
        this.myTerminator = terminator;
        this.myContext = context;
    }

    @Override
    @NotNull
    public QualifierExpression getQualifierExpression() {
        QualifierExpression qualifierExpression = this.myQualifierExpression;
        if (qualifierExpression == null) {
            StreamChainImpl.$$$reportNull$$$0(4);
        }
        return qualifierExpression;
    }

    @Override
    @NotNull
    public List<IntermediateStreamCall> getIntermediateCalls() {
        List<IntermediateStreamCall> list = Collections.unmodifiableList(this.myIntermediateCalls);
        if (list == null) {
            StreamChainImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public StreamCall getCall(int index) {
        if (0 <= index && index < this.length()) {
            StreamCall streamCall = this.doGetCall(index);
            if (streamCall == null) {
                StreamChainImpl.$$$reportNull$$$0(6);
            }
            return streamCall;
        }
        throw new IndexOutOfBoundsException("Call index out of bound: " + index);
    }

    @Override
    @NotNull
    public TerminatorStreamCall getTerminationCall() {
        TerminatorStreamCall terminatorStreamCall = this.myTerminator;
        if (terminatorStreamCall == null) {
            StreamChainImpl.$$$reportNull$$$0(7);
        }
        return terminatorStreamCall;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getText() {
        Iterator iterator = StreamEx.of(this.myIntermediateCalls).map(x -> x).append((Object)this.myTerminator).iterator();
        StringBuilder builder = new StringBuilder();
        builder.append(this.myQualifierExpression.getText()).append("\n").append(".");
        while (iterator.hasNext()) {
            MethodCall call = (MethodCall)iterator.next();
            String args = StreamChainImpl.args2Text(call.getArguments());
            builder.append(call.getName()).append(args);
            if (!iterator.hasNext()) continue;
            builder.append("\n").append(".");
        }
        String string = builder.toString();
        if (string == null) {
            StreamChainImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getCompactText() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.myQualifierExpression.getText().replaceAll("\\s+", ""));
        for (StreamCall call : StreamEx.of(this.myIntermediateCalls).map(x -> x).append((Object)this.myTerminator)) {
            builder.append(" -> ").append(call.getName());
        }
        String string = builder.toString();
        if (string == null) {
            StreamChainImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public int length() {
        return 1 + this.myIntermediateCalls.size();
    }

    @Override
    @NotNull
    public PsiElement getContext() {
        PsiElement psiElement = this.myContext;
        if (psiElement == null) {
            StreamChainImpl.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    private StreamCall doGetCall(int index) {
        if (index < this.myIntermediateCalls.size()) {
            return this.myIntermediateCalls.get(index);
        }
        return this.myTerminator;
    }

    @NotNull
    private static String args2Text(@NotNull List<CallArgument> args) {
        if (args == null) {
            StreamChainImpl.$$$reportNull$$$0(11);
        }
        String string = StreamEx.of(args).map(CallArgument::getText).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
        if (string == null) {
            StreamChainImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intermediateCalls";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/wrapper/impl/StreamChainImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/wrapper/impl/StreamChainImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntermediateCalls";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCall";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminationCall";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompactText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "args2Text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "args2Text";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 10, 12 -> new IllegalStateException(string);
        };
    }
}

