/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.cloud.authorization;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirer;
import com.intellij.collaboration.auth.services.OAuthRequest;
import com.intellij.collaboration.auth.services.PkceUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.DigestUtil;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.cloud.authorization.QodanaCloudOAuthCredentialsAcquirer;
import org.jetbrains.qodana.cloud.authorization.QodanaCloudOAuthService;
import org.jetbrains.qodana.cloud.authorization.credentials.QodanaCloudCredentials;
import org.jetbrains.qodana.cloudclient.QDCloudClient;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/qodana/cloud/authorization/QodanaCloudOAuthRequest;", "Lcom/intellij/collaboration/auth/services/OAuthRequest;", "Lorg/jetbrains/qodana/cloud/authorization/credentials/QodanaCloudCredentials;", "port", "", "frontendUrl", "", "cloudClient", "Lorg/jetbrains/qodana/cloudclient/QDCloudClient;", "authUrl", "Lcom/intellij/util/Url;", "<init>", "(ILjava/lang/String;Lorg/jetbrains/qodana/cloudclient/QDCloudClient;Lcom/intellij/util/Url;)V", "getPort", "()I", "getFrontendUrl", "()Ljava/lang/String;", "codeVerifier", "codeChallenge", "stateWithEmbeddedPortAndChallenge", "authUrlWithParameters", "getAuthUrlWithParameters", "()Lcom/intellij/util/Url;", "authorizationCodeUrl", "getAuthorizationCodeUrl", "credentialsAcquirer", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer;", "getCredentialsAcquirer", "()Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaCloudOAuthRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaCloudOAuthRequest.kt\norg/jetbrains/qodana/cloud/authorization/QodanaCloudOAuthRequest\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,40:1\n40#2,3:41\n*S KotlinDebug\n*F\n+ 1 QodanaCloudOAuthRequest.kt\norg/jetbrains/qodana/cloud/authorization/QodanaCloudOAuthRequest\n*L\n36#1:41,3\n*E\n"})
public final class QodanaCloudOAuthRequest
implements OAuthRequest<QodanaCloudCredentials> {
    private final int port;
    @NotNull
    private final String frontendUrl;
    @NotNull
    private final QDCloudClient cloudClient;
    @NotNull
    private final String codeVerifier;
    @NotNull
    private final String codeChallenge;
    @NotNull
    private final String stateWithEmbeddedPortAndChallenge;
    @NotNull
    private final Url authUrlWithParameters;

    public QodanaCloudOAuthRequest(int port, @NotNull String frontendUrl, @NotNull QDCloudClient cloudClient2, @NotNull Url authUrl) {
        Intrinsics.checkNotNullParameter((Object)frontendUrl, (String)"frontendUrl");
        Intrinsics.checkNotNullParameter((Object)cloudClient2, (String)"cloudClient");
        Intrinsics.checkNotNullParameter((Object)authUrl, (String)"authUrl");
        this.port = port;
        this.frontendUrl = frontendUrl;
        this.cloudClient = cloudClient2;
        this.codeVerifier = PkceUtils.INSTANCE.generateCodeVerifier();
        Base64.Encoder encoder = Base64.getEncoder();
        Intrinsics.checkNotNullExpressionValue((Object)encoder, (String)"getEncoder(...)");
        this.codeChallenge = PkceUtils.INSTANCE.generateShaCodeChallenge(this.codeVerifier, encoder);
        this.stateWithEmbeddedPortAndChallenge = "idea-" + this.port + "-" + DigestUtil.randomToken();
        Url url = authUrl.addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"state", (Object)this.stateWithEmbeddedPortAndChallenge)));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"addParameters(...)");
        this.authUrlWithParameters = url;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final String getFrontendUrl() {
        return this.frontendUrl;
    }

    @NotNull
    public Url getAuthUrlWithParameters() {
        return this.authUrlWithParameters;
    }

    @NotNull
    public Url getAuthorizationCodeUrl() {
        boolean $i$f$service = false;
        Class<QodanaCloudOAuthService> serviceClass$iv = QodanaCloudOAuthService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return Urls.newFromEncoded((String)("http://localhost:" + this.port + "/api/" + ((QodanaCloudOAuthService)object).getName() + "/authorization_code/"));
    }

    @NotNull
    public OAuthCredentialsAcquirer<QodanaCloudCredentials> getCredentialsAcquirer() {
        return new QodanaCloudOAuthCredentialsAcquirer(this.cloudClient, this.codeVerifier);
    }
}

