/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.debugger.BreakpointComment;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaSourcePositionHighlighter;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendContextRunnable;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTestCase;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.SmartList;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.UIUtil;
import com.sun.jdi.Method;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public abstract class ExecutionWithDebuggerToolsTestCase
extends ExecutionTestCase {
    @Nullable
    private BreakpointProvider myBreakpointProvider;
    protected static final int RATHER_LATER_INVOKES_N = 10;
    public DebugProcessImpl myDebugProcess;
    private final List<Throwable> myException = new SmartList();
    protected boolean myWasUsedOnlyDefaultSuspendPolicy = true;
    public final List<InvokeRatherLaterRequest> myRatherLaterRequests = new ArrayList<InvokeRatherLaterRequest>();

    protected DebugProcessImpl getDebugProcess() {
        return this.myDebugProcess;
    }

    protected void resume(SuspendContextImpl context2) {
        DebugProcessImpl debugProcess = context2.getDebugProcess();
        debugProcess.getManagerThread().schedule((DebuggerCommandImpl)debugProcess.createResumeCommand(context2, PrioritizedTask.Priority.LOWEST));
    }

    protected void stepInto(SuspendContextImpl context2) {
        this.stepInto(context2, false);
    }

    protected void stepInto(SuspendContextImpl context2, boolean ignoreFilters) {
        DebugProcessImpl debugProcess = context2.getDebugProcess();
        debugProcess.getManagerThread().schedule((DebuggerCommandImpl)debugProcess.createStepIntoCommand(context2, ignoreFilters, null));
    }

    protected void stepOver(SuspendContextImpl context2) {
        DebugProcessImpl debugProcess = context2.getDebugProcess();
        debugProcess.getManagerThread().schedule((DebuggerCommandImpl)debugProcess.createStepOverCommand(context2, false));
    }

    protected void stepOut(SuspendContextImpl context2) {
        DebugProcessImpl debugProcess = context2.getDebugProcess();
        debugProcess.getManagerThread().schedule((DebuggerCommandImpl)debugProcess.createStepOutCommand(context2));
    }

    @Override
    protected void tearDown() throws Exception {
        ThreadTracker.awaitJDIThreadsTermination(100, TimeUnit.SECONDS);
        try {
            this.myDebugProcess = null;
            this.myBreakpointProvider = null;
            this.myRatherLaterRequests.clear();
            this.myWasUsedOnlyDefaultSuspendPolicy = true;
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
            this.throwExceptionsIfAny();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void throwExceptionsIfAny() {
        List<Throwable> list = this.myException;
        synchronized (list) {
            CompoundRuntimeException.throwIfNotEmpty(this.myException);
            this.myException.clear();
        }
    }

    @NotNull
    private BreakpointProvider getBreakpointProvider() {
        if (this.myBreakpointProvider == null) {
            DebugProcessImpl debugProcess = this.getDebugProcess();
            ExecutionWithDebuggerToolsTestCase.assertNotNull((String)"Debug process was not started", (Object)debugProcess);
            this.myBreakpointProvider = new BreakpointProvider(this.myDebugProcess);
            DelayedEventsProcessListener processListener = new DelayedEventsProcessListener(this.myBreakpointProvider);
            debugProcess.addDebugProcessListener((DebugProcessListener)processListener, this.getTestRootDisposable());
        }
        BreakpointProvider breakpointProvider = this.myBreakpointProvider;
        if (breakpointProvider == null) {
            ExecutionWithDebuggerToolsTestCase.$$$reportNull$$$0(0);
        }
        return breakpointProvider;
    }

    protected void onBreakpoint(SuspendContextRunnable runnable) {
        this.getBreakpointProvider().onBreakpoint(runnable);
    }

    protected void onEveryBreakpoint(SuspendContextRunnable runnable) {
        this.getBreakpointProvider().onEveryBreakpoint(runnable);
    }

    protected void onStop(final SuspendContextRunnable runnable, final SuspendContextRunnable then) {
        this.onBreakpoint(new SuspendContextRunnable(){

            public void run(SuspendContextImpl suspendContext) throws Exception {
                try {
                    runnable.run(suspendContext);
                }
                finally {
                    then.run(suspendContext);
                }
            }
        });
    }

    protected void doWhenPausedThenResume(SuspendContextRunnable runnable) {
        this.onStop(runnable, this::resume);
    }

    protected void printFrameProxy(StackFrameProxyImpl frameProxy) throws EvaluateException {
        int frameIndex = frameProxy.getFrameIndex();
        Method method = frameProxy.location().method();
        this.systemPrintln("frameProxy(" + frameIndex + ") = " + method);
    }

    protected static String toDisplayableString(SourcePosition sourcePosition) {
        int line = sourcePosition.getLine();
        if (line >= 0) {
            ++line;
        }
        return sourcePosition.getFile().getVirtualFile().getName() + ":" + line;
    }

    protected void printContext(StackFrameContext context2) {
        ApplicationManager.getApplication().runReadAction(() -> {
            if (context2.getFrameProxy() != null) {
                this.systemPrintln(ExecutionWithDebuggerToolsTestCase.toDisplayableString(Objects.requireNonNull(PositionUtil.getSourcePosition((StackFrameContext)context2))));
            } else {
                this.systemPrintln("Context thread is null");
            }
        });
    }

    protected void printContextWithText(StackFrameContext context2) {
        ApplicationManager.getApplication().runReadAction(() -> {
            if (context2.getFrameProxy() != null) {
                SourcePosition sourcePosition = PositionUtil.getSourcePosition((StackFrameContext)context2);
                int offset = sourcePosition.getOffset();
                Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(sourcePosition.getFile());
                CharSequence text = Objects.requireNonNull(document).getImmutableCharSequence();
                String positionText = "";
                if (offset > -1) {
                    CharSequence before2 = text.subSequence(Math.max(0, offset - 20), offset);
                    CharSequence after2 = text.subSequence(offset, Math.min(offset + 20, text.length()));
                    positionText = StringUtil.escapeLineBreak((String)(" [" + before2 + "<*>" + after2 + "]"));
                }
                this.systemPrintln(ExecutionWithDebuggerToolsTestCase.toDisplayableString(sourcePosition) + positionText);
                this.printHighlightingRange((SuspendContextImpl)context2);
            } else {
                this.systemPrintln("Context thread is null");
            }
        });
    }

    protected void printHighlightingRange(SuspendContextImpl context2) {
        String actualText;
        JavaSourcePositionHighlighter highlighter = new JavaSourcePositionHighlighter();
        SourcePosition position = context2.getDebugProcess().getPositionManager().getSourcePosition(context2.getLocation());
        TextRange range = (TextRange)ReadAction.compute(() -> highlighter.getHighlightRange(position));
        String string = actualText = range == null ? null : range.substring(position.getFile().getText());
        if (actualText != null) {
            this.systemPrintln("Highlight code range: '" + StringUtil.escapeLineBreak((String)actualText) + "'");
        } else {
            this.systemPrintln("Highlight whole line");
        }
    }

    protected void invokeRatherLater(@NotNull SuspendContextImpl context2, final @NotNull Runnable runnable) {
        if (context2 == null) {
            ExecutionWithDebuggerToolsTestCase.$$$reportNull$$$0(1);
        }
        if (runnable == null) {
            ExecutionWithDebuggerToolsTestCase.$$$reportNull$$$0(2);
        }
        this.invokeRatherLater(context2.getDebugProcess(), (DebuggerCommandImpl)new SuspendContextCommandImpl(context2){

            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                DebuggerInvocationUtil.invokeLater((Project)ExecutionWithDebuggerToolsTestCase.this.myProject, (Runnable)runnable);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ExecutionWithDebuggerToolsTestCase$2", "contextAction"));
            }
        });
    }

    protected void pumpSwingThread() {
        LOG.assertTrue(SwingUtilities.isEventDispatchThread());
        final InvokeRatherLaterRequest request = this.myRatherLaterRequests.get(0);
        ++request.invokesN;
        if (request.invokesN == 10) {
            this.myRatherLaterRequests.remove(0);
            if (!this.myRatherLaterRequests.isEmpty()) {
                this.pumpSwingThread();
            }
        }
        if (request.myDebuggerCommand instanceof SuspendContextCommandImpl) {
            request.myDebugProcess.getManagerThread().schedule((DebuggerCommandImpl)new SuspendContextCommandImpl(((SuspendContextCommandImpl)request.myDebuggerCommand).getSuspendContext()){

                public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                    if (suspendContext == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    ExecutionWithDebuggerToolsTestCase.this.pumpDebuggerThread(request);
                }

                protected void commandCancelled() {
                    ExecutionWithDebuggerToolsTestCase.this.pumpDebuggerThread(request);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ExecutionWithDebuggerToolsTestCase$3", "contextAction"));
                }
            });
        } else {
            request.myDebugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                protected void action() {
                    ExecutionWithDebuggerToolsTestCase.this.pumpDebuggerThread(request);
                }

                protected void commandCancelled() {
                    ExecutionWithDebuggerToolsTestCase.this.pumpDebuggerThread(request);
                }
            });
        }
    }

    private void pumpDebuggerThread(InvokeRatherLaterRequest request) {
        if (request.invokesN == 10) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                Set commands = request.myDebugProcess.getManagerThread().getUnfinishedCommands();
                while (!commands.isEmpty()) {
                    TimeoutUtil.sleep((long)1L);
                }
                request.myDebugProcess.getManagerThread().schedule(request.myDebuggerCommand);
            });
        } else if (!SwingUtilities.isEventDispatchThread()) {
            try {
                EdtInvocationManager.getInstance().invokeAndWait(() -> this.pumpSwingThread());
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            SwingUtilities.invokeLater(() -> this.pumpSwingThread());
        }
    }

    protected void invokeRatherLater(DebuggerCommandImpl command) {
        this.invokeRatherLater(this.getDebugProcess(), command);
    }

    protected void invokeRatherLater(@NotNull DebugProcessImpl debugProcess, DebuggerCommandImpl command) {
        if (debugProcess == null) {
            ExecutionWithDebuggerToolsTestCase.$$$reportNull$$$0(3);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            InvokeRatherLaterRequest request = new InvokeRatherLaterRequest(command, debugProcess);
            this.myRatherLaterRequests.add(request);
            if (this.myRatherLaterRequests.size() == 1) {
                this.pumpSwingThread();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addException(@NotNull Throwable e) {
        if (e == null) {
            ExecutionWithDebuggerToolsTestCase.$$$reportNull$$$0(4);
        }
        List<Throwable> list = this.myException;
        synchronized (list) {
            this.myException.add(e);
        }
    }

    protected void error(@NotNull Throwable th) {
        if (th == null) {
            ExecutionWithDebuggerToolsTestCase.$$$reportNull$$$0(5);
        }
        ExecutionWithDebuggerToolsTestCase.fail((String)StringUtil.getThrowableText((Throwable)th));
    }

    public void createBreakpoints(PsiFile file2) {
        Runnable runnable = () -> {
            BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx((Project)this.myProject).getBreakpointManager();
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file2);
            assert (document != null);
            String text = document.getText();
            int offset = -1;
            while ((offset = text.indexOf("Breakpoint!", offset + 1)) != -1) {
                String classFiltersStr;
                Integer passCount;
                String logExpression;
                String condition;
                String suspendPolicy;
                MethodBreakpoint breakpoint;
                String kind;
                int commentLine = document.getLineNumber(offset);
                String fileName = file2.getVirtualFile().getName();
                String breakpointLocation = fileName + ":" + (commentLine + 1 + 1);
                String commentText = text.substring(document.getLineStartOffset(commentLine), document.getLineEndOffset(commentLine));
                BreakpointComment comment = BreakpointComment.parse(commentText, file2.getVirtualFile().getPresentableUrl(), commentLine);
                switch (kind = comment.readKind()) {
                    case "Method": {
                        Boolean exit;
                        Boolean entry;
                        breakpoint = breakpointManager.addMethodBreakpoint(document, commentLine + 1);
                        if (breakpoint == null) break;
                        this.systemPrintln("MethodBreakpoint created at " + breakpointLocation);
                        Boolean emulated = comment.readBooleanValue("Emulated");
                        if (emulated != null) {
                            ((JavaMethodBreakpointProperties)breakpoint.getXBreakpoint().getProperties()).EMULATED = emulated;
                            this.systemPrintln("Emulated = " + emulated);
                        }
                        if ((entry = comment.readBooleanValue("OnEntry")) != null) {
                            ((JavaMethodBreakpointProperties)breakpoint.getXBreakpoint().getProperties()).WATCH_ENTRY = entry;
                            this.systemPrintln("On Entry = " + entry);
                        }
                        if ((exit = comment.readBooleanValue("OnExit")) == null) break;
                        ((JavaMethodBreakpointProperties)breakpoint.getXBreakpoint().getProperties()).WATCH_EXIT = exit;
                        this.systemPrintln("On Exit = " + exit);
                        break;
                    }
                    case "Field": {
                        breakpoint = breakpointManager.addFieldBreakpoint(document, commentLine + 1, comment.readKindValue());
                        if (breakpoint == null) break;
                        this.systemPrintln("FieldBreakpoint created at " + breakpointLocation);
                        break;
                    }
                    case "Exception": {
                        String exceptionClassName = Objects.requireNonNull(comment.readKindValue());
                        breakpoint = breakpointManager.addExceptionBreakpoint(exceptionClassName);
                        if (breakpoint == null) break;
                        this.systemPrintln("ExceptionBreakpoint created at " + breakpointLocation);
                        String catchClassFiltersStr = comment.readValue("Catch class filters");
                        if (catchClassFiltersStr == null) break;
                        Pair<ClassFilter[], ClassFilter[]> filters = BreakpointComment.parseClassFilters(catchClassFiltersStr);
                        ExceptionBreakpoint exceptionBreakpoint = (ExceptionBreakpoint)breakpoint;
                        exceptionBreakpoint.setCatchFiltersEnabled(true);
                        exceptionBreakpoint.setCatchClassFilters((ClassFilter[])filters.first);
                        exceptionBreakpoint.setCatchClassExclusionFilters((ClassFilter[])filters.second);
                        this.systemPrintln("Catch class filters = " + catchClassFiltersStr);
                        break;
                    }
                    case "ConditionalReturn": {
                        breakpoint = breakpointManager.addLineBreakpoint(document, commentLine + 1, p -> p.setEncodedInlinePosition(Integer.valueOf(JavaLineBreakpointProperties.encodeInlinePosition((int)-1, (boolean)true))));
                        if (breakpoint == null) break;
                        this.systemPrintln("ConditionalReturnBreakpoint created at " + breakpointLocation);
                        break;
                    }
                    case "Line": {
                        breakpoint = breakpointManager.addLineBreakpoint(document, commentLine + 1);
                        if (breakpoint == null) break;
                        this.systemPrintln("LineBreakpoint created at " + breakpointLocation);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid kind '" + kind + "' at " + fileName + ":" + (commentLine + 1));
                    }
                }
                if (breakpoint == null) {
                    LOG.error("Unable to set a breakpoint at line " + (commentLine + 1));
                    continue;
                }
                String enabled = comment.readValue("Enabled");
                if (enabled != null) {
                    breakpoint.getXBreakpoint().setEnabled(Boolean.parseBoolean(enabled));
                    this.systemPrintln("Enabled = " + enabled);
                }
                if ((suspendPolicy = comment.readValue("suspendPolicy")) != null) {
                    breakpoint.setSuspendPolicy(suspendPolicy);
                    this.systemPrintln("SUSPEND_POLICY = " + suspendPolicy);
                    this.myWasUsedOnlyDefaultSuspendPolicy = false;
                }
                if ((condition = comment.readValue("Condition")) != null) {
                    breakpoint.setCondition((TextWithImports)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, condition));
                    this.systemPrintln("Condition = " + condition);
                }
                if ((logExpression = comment.readValue("LogExpression")) != null) {
                    breakpoint.getXBreakpoint().setLogExpression(logExpression);
                    this.systemPrintln("LogExpression = " + logExpression);
                }
                if ((passCount = comment.readIntValue("Pass count")) != null) {
                    breakpoint.setCountFilterEnabled(true);
                    breakpoint.setCountFilter(passCount.intValue());
                    this.systemPrintln("Pass count = " + passCount);
                }
                if ((classFiltersStr = comment.readValue("Class filters")) != null) {
                    breakpoint.setClassFiltersEnabled(true);
                    Pair<ClassFilter[], ClassFilter[]> filters = BreakpointComment.parseClassFilters(classFiltersStr);
                    breakpoint.setClassFilters((ClassFilter[])filters.first);
                    breakpoint.setClassExclusionFilters((ClassFilter[])filters.second);
                    this.systemPrintln("Class filters = " + classFiltersStr);
                }
                comment.done();
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            DebuggerInvocationUtil.invokeAndWait((Project)this.myProject, (Runnable)runnable, (ModalityState)ModalityState.defaultModalityState());
        } else {
            runnable.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ExecutionWithDebuggerToolsTestCase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "th";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ExecutionWithDebuggerToolsTestCase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invokeRatherLater";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addException";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    protected class BreakpointProvider
    extends DebugProcessAdapterImpl {
        private final DebugProcessImpl myDebugProcess;
        private final List<SuspendContextRunnable> myRepeatingRunnables = new ArrayList<SuspendContextRunnable>();
        private final Queue<SuspendContextRunnable> myScriptRunnables = new ArrayDeque<SuspendContextRunnable>();

        public BreakpointProvider(DebugProcessImpl debugProcess) {
            this.myDebugProcess = debugProcess;
        }

        public void onBreakpoint(SuspendContextRunnable runnable) {
            this.myScriptRunnables.add(runnable);
        }

        public void onEveryBreakpoint(SuspendContextRunnable runnable) {
            this.myRepeatingRunnables.add(runnable);
        }

        public void paused(SuspendContextImpl suspendContext) {
            DebuggerManagerThreadImpl debuggerManagerThread = Objects.requireNonNull(suspendContext.getDebugProcess()).getManagerThread();
            debuggerManagerThread.invoke((DebuggerCommandImpl)new SuspendContextCommandImpl(suspendContext){

                public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                    if (suspendContext == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    BreakpointProvider.this.pausedImpl(suspendContext);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ExecutionWithDebuggerToolsTestCase$BreakpointProvider$1", "contextAction"));
                }
            });
        }

        private void pausedImpl(SuspendContextImpl suspendContext) {
            try {
                if (this.myScriptRunnables.isEmpty() && this.myRepeatingRunnables.isEmpty()) {
                    ExecutionWithDebuggerToolsTestCase.this.print("resuming ", ProcessOutputTypes.SYSTEM);
                    ExecutionWithDebuggerToolsTestCase.this.printContext((StackFrameContext)suspendContext);
                    ExecutionWithDebuggerToolsTestCase.this.resume(suspendContext);
                    return;
                }
                SuspendContextRunnable suspendContextRunnable = this.myScriptRunnables.poll();
                if (suspendContextRunnable != null) {
                    suspendContextRunnable.run(suspendContext);
                }
                for (SuspendContextRunnable it : this.myRepeatingRunnables) {
                    it.run(suspendContext);
                }
            }
            catch (Exception e) {
                ExecutionWithDebuggerToolsTestCase.this.addException(e);
                ExecutionWithDebuggerToolsTestCase.this.error(e);
            }
            catch (AssertionError e) {
                ExecutionWithDebuggerToolsTestCase.this.addException((Throwable)((Object)e));
                ExecutionWithDebuggerToolsTestCase.this.resume(suspendContext);
            }
        }

        public void resumed(SuspendContextImpl suspendContext) {
            final SuspendContextImpl pausedContext = this.myDebugProcess.getSuspendManager().getPausedContext();
            if (pausedContext != null) {
                this.myDebugProcess.getManagerThread().schedule((DebuggerCommandImpl)new SuspendContextCommandImpl(pausedContext){

                    public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                        if (suspendContext == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        BreakpointProvider.this.paused(pausedContext);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ExecutionWithDebuggerToolsTestCase$BreakpointProvider$2", "contextAction"));
                    }
                });
            }
        }
    }

    protected static class DelayedEventsProcessListener
    implements DebugProcessListener {
        private final DebugProcessAdapterImpl myTarget;

        public DelayedEventsProcessListener(DebugProcessAdapterImpl target) {
            this.myTarget = target;
        }

        public void paused(@NotNull SuspendContext suspendContext) {
            if (suspendContext == null) {
                DelayedEventsProcessListener.$$$reportNull$$$0(0);
            }
            DelayedEventsProcessListener.pauseExecution();
            this.myTarget.paused(suspendContext);
        }

        public void resumed(SuspendContext suspendContext) {
            DelayedEventsProcessListener.pauseExecution();
            this.myTarget.resumed(suspendContext);
        }

        public void processDetached(@NotNull DebugProcess process, boolean closedByUser) {
            if (process == null) {
                DelayedEventsProcessListener.$$$reportNull$$$0(1);
            }
            this.myTarget.processDetached(process, closedByUser);
        }

        public void processAttached(@NotNull DebugProcess process) {
            if (process == null) {
                DelayedEventsProcessListener.$$$reportNull$$$0(2);
            }
            this.myTarget.processAttached(process);
        }

        public void connectorIsReady() {
            this.myTarget.connectorIsReady();
        }

        public void attachException(RunProfileState state, ExecutionException exception, RemoteConnection remoteConnection) {
            this.myTarget.attachException(state, exception, remoteConnection);
        }

        private static void pauseExecution() {
            TimeoutUtil.sleep((long)10L);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suspendContext";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/ExecutionWithDebuggerToolsTestCase$DelayedEventsProcessListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paused";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processDetached";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processAttached";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class InvokeRatherLaterRequest {
        private final DebuggerCommandImpl myDebuggerCommand;
        private final DebugProcessImpl myDebugProcess;
        int invokesN;

        InvokeRatherLaterRequest(DebuggerCommandImpl debuggerCommand, DebugProcessImpl debugProcess) {
            this.myDebuggerCommand = debuggerCommand;
            this.myDebugProcess = debugProcess;
        }
    }
}

