/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cmdline;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcherManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tracing.Tracer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.StorageLockContext;
import io.netty.channel.Channel;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.BuildType;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.ModuleInducedTargetType;
import org.jetbrains.jps.builders.PreloadedDataExtension;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.cache.loader.JpsOutputLoaderManager;
import org.jetbrains.jps.cmdline.BuildRunner;
import org.jetbrains.jps.cmdline.JpsModelLoaderImpl;
import org.jetbrains.jps.cmdline.PreloadedData;
import org.jetbrains.jps.cmdline.ProfilingHelper;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.MessageHandler;
import org.jetbrains.jps.incremental.RebuildRequestedException;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.BuildFSState;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.BuilderStatisticsMessage;
import org.jetbrains.jps.incremental.messages.BuildingTargetProgressMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.CustomBuilderMessage;
import org.jetbrains.jps.incremental.messages.DoneSomethingNotification;
import org.jetbrains.jps.incremental.messages.FileGeneratedEvent;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.incremental.storage.ProjectStamps;
import org.jetbrains.jps.incremental.storage.StampsStorage;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.CannotLoadJpsModelException;
import org.jetbrains.jps.model.serialization.impl.TimingLog;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.jps.service.SharedThreadPool;

final class BuildSession
implements Runnable,
CanceledStatus {
    private static final Logger LOG = Logger.getInstance(BuildSession.class);
    private static final Boolean REPORT_BUILD_STATISTICS = Boolean.valueOf(System.getProperty("jps.report.build.statistics", "false"));
    static final String FS_STATE_FILE = "fs_state.dat";
    private final UUID mySessionId;
    private final Channel myChannel;
    @Nullable
    private PreloadedData myPreloadedData;
    private volatile boolean myCanceled;
    private final String myProjectPath;
    @Nullable
    private CmdlineRemoteProto.Message.ControllerMessage.FSEvent myInitialFSDelta;
    private final EventsProcessor myEventsProcessor = new EventsProcessor();
    private final AtomicLong myLastEventOrdinal = new AtomicLong();
    private volatile ProjectDescriptor myProjectDescriptor;
    @NotNull
    private final BuildRunner myBuildRunner;
    private final BuildType myBuildType;
    private final List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> myScopes;
    private final boolean myLoadUnloadedModules;
    @Nullable
    private JpsOutputLoaderManager myCacheLoadManager;
    @Nullable
    private final CmdlineRemoteProto.Message.ControllerMessage.CacheDownloadSettings myCacheDownloadSettings;

    BuildSession(UUID sessionId, Channel channel, CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage params, @Nullable CmdlineRemoteProto.Message.ControllerMessage.FSEvent delta, @Nullable PreloadedData preloaded) {
        this.mySessionId = sessionId;
        this.myChannel = channel;
        CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings globals = params.getGlobalSettings();
        String projectId = params.getProjectId();
        LOG.assertTrue(projectId != null, (Object)"projectId is not specified");
        this.myProjectPath = FileUtil.toCanonicalPath((String)projectId);
        String globalOptionsPath = FileUtil.toCanonicalPath((String)globals.getGlobalOptionsPath());
        this.myBuildType = BuildSession.convertCompileType(params.getBuildType());
        this.myScopes = params.getScopeList();
        this.myCacheDownloadSettings = params.hasCacheDownloadSettings() ? params.getCacheDownloadSettings() : null;
        List<String> filePaths = params.getFilePathList();
        HashMap<String, String> builderParams = new HashMap<String, String>();
        for (CmdlineRemoteProto.Message.KeyValuePair pair : params.getBuilderParameterList()) {
            builderParams.put(pair.getKey(), pair.getValue());
        }
        this.myInitialFSDelta = delta;
        this.myLoadUnloadedModules = Boolean.parseBoolean((String)builderParams.get("load_unloaded_modules"));
        if (this.myLoadUnloadedModules && preloaded != null) {
            this.myPreloadedData = null;
            ProjectDescriptor projectDescriptor = preloaded.getProjectDescriptor();
            if (projectDescriptor != null) {
                projectDescriptor.release();
                preloaded.setProjectDescriptor(null);
            }
            JpsServiceManager.getInstance().getExtensions(PreloadedDataExtension.class).forEach(ext -> ext.discardPreloadedData(preloaded));
        } else {
            this.myPreloadedData = preloaded;
        }
        this.myBuildRunner = this.myPreloadedData == null || this.myPreloadedData.getRunner() == null ? new BuildRunner(new JpsModelLoaderImpl(this.myProjectPath, globalOptionsPath, this.myLoadUnloadedModules, null)) : this.myPreloadedData.getRunner();
        this.myBuildRunner.setFilePaths(filePaths);
        this.myBuildRunner.setBuilderParams(builderParams);
        if (this.myPreloadedData != null) {
            JpsServiceManager.getInstance().getExtensions(PreloadedDataExtension.class).forEach(ext -> ext.buildSessionInitialized(this.myPreloadedData));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting build:");
            LOG.debug(" initial delta = " + (delta == null ? null : "FSEvent(ordinal = " + delta.getOrdinal() + ", changed = " + BuildSession.showFirstItemIfAny(delta.getChangedPathsList()) + ", deleted = " + delta.getDeletedPathsList() + ")"));
            LOG.debug(" loadUnloadedModules = " + this.myLoadUnloadedModules);
            LOG.debug(" preloadedData = " + this.myPreloadedData);
            LOG.debug(" buildType = " + this.myBuildType);
        }
        try {
            String tracingFile = System.getProperty("tracingFile");
            if (tracingFile != null) {
                LOG.debug("Tracing enabled, file: " + tracingFile);
                Path tracingFilePath = Paths.get(tracingFile, new String[0]);
                Tracer.runTracer((int)1, (Path)tracingFilePath, (long)1L, arg_0 -> ((Logger)LOG).warn(arg_0));
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @NonNls
    private static String showFirstItemIfAny(List<String> list) {
        switch (list.size()) {
            case 0: {
                return "[]";
            }
            case 1: {
                return "[" + list.get(0) + "]";
            }
        }
        return "[" + list.get(0) + " and " + (list.size() - 1) + " more]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LowMemoryWatcherManager memWatcher = new LowMemoryWatcherManager((ExecutorService)SharedThreadPool.getInstance());
        Throwable error = null;
        final Ref hasErrors = new Ref((Object)false);
        final Ref doneSomething = new Ref((Object)false);
        try {
            ProfilingHelper profilingHelper;
            try {
                Utils.ProfilingMode profilingMode = Utils.getProfilingMode();
                switch (profilingMode) {
                    case NONE: {
                        profilingHelper = null;
                        break;
                    }
                    case YOURKIT_SAMPLING: {
                        profilingHelper = new ProfilingHelper();
                        profilingHelper.startSamplingProfiling();
                        break;
                    }
                    case YOURKIT_TRACING: {
                        profilingHelper = new ProfilingHelper();
                        profilingHelper.startTracingProfiling();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported profiling mode: " + profilingMode);
                    }
                }
            }
            catch (Throwable t) {
                LOG.warn("Unable to start build process profiling: " + t.getMessage(), t);
                t.printStackTrace();
                profilingHelper = null;
            }
            this.myCacheLoadManager = null;
            if (ProjectStamps.PORTABLE_CACHES && this.myCacheDownloadSettings != null) {
                LOG.info("Cache download settings: disableDownload=" + this.myCacheDownloadSettings.getDisableDownload() + "; forceUpdate=" + this.myCacheDownloadSettings.getForceDownload() + "; cleanupAsynchronously=" + this.myCacheDownloadSettings.getCleanupAsynchronously());
                if (this.myCacheDownloadSettings.getDisableDownload()) {
                    LOG.info("Cache download is disabled");
                } else {
                    LOG.info("Trying to download JPS caches before build");
                    this.myCacheLoadManager = new JpsOutputLoaderManager(this.myBuildRunner.loadModelAndGetJpsProject(), this, this.myProjectPath, this.myChannel, this.mySessionId, this.myCacheDownloadSettings);
                    this.myCacheLoadManager.load(this.myBuildRunner, true, this.myScopes, () -> {
                        if (this.myPreloadedData != null) {
                            LOG.info("Releasing old project description...");
                            ProjectDescriptor projectDescriptor = this.myPreloadedData.getProjectDescriptor();
                            if (projectDescriptor != null) {
                                projectDescriptor.release();
                                this.myPreloadedData.setProjectDescriptor(null);
                            }
                            JpsServiceManager.getInstance().getExtensions(PreloadedDataExtension.class).forEach(ext -> ext.discardPreloadedData(this.myPreloadedData));
                            this.myPreloadedData = null;
                        }
                    });
                }
            }
            this.runBuild(new MessageHandler(){

                @Override
                public void processMessage(BuildMessage buildMessage) {
                    CmdlineRemoteProto.Message.BuilderMessage response;
                    if (buildMessage instanceof FileGeneratedEvent) {
                        Collection<Pair<String, String>> paths = ((FileGeneratedEvent)buildMessage).getPaths();
                        response = !paths.isEmpty() ? CmdlineProtoUtil.createFileGeneratedEvent(paths) : null;
                    } else if (buildMessage instanceof DoneSomethingNotification) {
                        doneSomething.set((Object)true);
                        response = null;
                    } else if (buildMessage instanceof CompilerMessage) {
                        doneSomething.set((Object)true);
                        CompilerMessage compilerMessage = (CompilerMessage)buildMessage;
                        String compilerName = compilerMessage.getCompilerName();
                        String text = !StringUtil.isEmptyOrSpaces((String)compilerName) ? compilerName + ": " + compilerMessage.getMessageText() : compilerMessage.getMessageText();
                        BuildMessage.Kind kind = compilerMessage.getKind();
                        if (kind == BuildMessage.Kind.ERROR) {
                            hasErrors.set((Object)true);
                        }
                        response = CmdlineProtoUtil.createCompileMessage(kind, text, compilerMessage.getSourcePath(), compilerMessage.getProblemBeginOffset(), compilerMessage.getProblemEndOffset(), compilerMessage.getProblemLocationOffset(), compilerMessage.getLine(), compilerMessage.getColumn(), -1.0f, compilerMessage.getModuleNames());
                    } else if (buildMessage instanceof CustomBuilderMessage) {
                        CustomBuilderMessage builderMessage = (CustomBuilderMessage)buildMessage;
                        response = CmdlineProtoUtil.createCustomBuilderMessage(builderMessage.getBuilderId(), builderMessage.getMessageType(), builderMessage.getMessageText());
                    } else if (buildMessage instanceof BuilderStatisticsMessage) {
                        boolean worthReporting;
                        BuilderStatisticsMessage message = (BuilderStatisticsMessage)buildMessage;
                        boolean bl = worthReporting = message.getNumberOfProcessedSources() != 0 || message.getElapsedTimeMs() > 50L;
                        if (worthReporting) {
                            LOG.info(message.getMessageText());
                        }
                        response = worthReporting && REPORT_BUILD_STATISTICS != false ? CmdlineProtoUtil.createCompileMessage(BuildMessage.Kind.JPS_INFO, message.getMessageText(), null, -1L, -1L, -1L, -1L, -1L, -1.0f, Collections.emptyList()) : null;
                    } else if (!(buildMessage instanceof BuildingTargetProgressMessage)) {
                        float done = -1.0f;
                        if (buildMessage instanceof ProgressMessage) {
                            done = ((ProgressMessage)buildMessage).getDone();
                        }
                        response = CmdlineProtoUtil.createCompileProgressMessageResponse(buildMessage.getMessageText(), done);
                    } else {
                        response = null;
                    }
                    if (response != null) {
                        BuildSession.this.myChannel.writeAndFlush((Object)CmdlineProtoUtil.toMessage(BuildSession.this.mySessionId, response));
                    }
                }
            }, this);
            if (profilingHelper != null) {
                profilingHelper.stopProfiling();
            }
        }
        catch (Throwable e) {
            LOG.info(e);
            error = e;
        }
        finally {
            BuildSession.logStorageDiagnostic();
            this.finishBuild(error, (Boolean)hasErrors.get(), (Boolean)doneSomething.get());
            memWatcher.shutdown();
        }
    }

    private static void logStorageDiagnostic() {
        LOG.info("FilePageCache stats: " + StorageLockContext.getStatistics().dumpInfoImportantForBuildProcess());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBuild(@NotNull MessageHandler msgHandler, @NotNull CanceledStatus cs) throws Throwable {
        Path dataStorageRoot;
        boolean storageFilesAbsent;
        if (msgHandler == null) {
            BuildSession.$$$reportNull$$$0(0);
        }
        if (cs == null) {
            BuildSession.$$$reportNull$$$0(1);
        }
        boolean bl = storageFilesAbsent = !Files.exists(dataStorageRoot = Utils.getDataStorageRoot(this.myProjectPath).toPath(), new LinkOption[0]) || !Files.exists(dataStorageRoot.resolve(FS_STATE_FILE), new LinkOption[0]);
        if (storageFilesAbsent) {
            this.myBuildRunner.setForceCleanCaches(true);
            LOG.debug("Storage files are absent");
        }
        ProjectDescriptor preloadedProject = this.myPreloadedData != null ? this.myPreloadedData.getProjectDescriptor() : null;
        DataInputStream fsStateStream = storageFilesAbsent || preloadedProject != null || this.myLoadUnloadedModules || this.myInitialFSDelta == null ? null : BuildSession.createFSDataStream(dataStorageRoot, this.myInitialFSDelta.getOrdinal());
        if (fsStateStream != null || this.myPreloadedData != null) {
            boolean hasWorkToDoWithModules;
            boolean hasWorkFlag = fsStateStream != null ? fsStateStream.readBoolean() : this.myPreloadedData.hasWorkToDo();
            LOG.debug("hasWorkFlag = " + hasWorkFlag);
            boolean bl2 = hasWorkToDoWithModules = hasWorkFlag || this.myInitialFSDelta == null;
            if (!(this.myBuildType != BuildType.BUILD && this.myBuildType != BuildType.UP_TO_DATE_CHECK || hasWorkToDoWithModules || !BuildSession.scopeContainsModulesOnlyForIncrementalMake(this.myScopes) || BuildSession.containsChanges(this.myInitialFSDelta))) {
                DataInputStream storedFsData;
                if (this.myPreloadedData != null) {
                    storedFsData = BuildSession.createFSDataStream(dataStorageRoot, this.myInitialFSDelta.getOrdinal());
                    if (storedFsData != null) {
                        storedFsData.readBoolean();
                    }
                } else {
                    storedFsData = fsStateStream;
                }
                if (storedFsData != null) {
                    BuildSession.updateFsStateOnDisk(dataStorageRoot, storedFsData, this.myInitialFSDelta.getOrdinal());
                    LOG.info("No changes found since last build. Exiting.");
                    if (preloadedProject != null) {
                        preloadedProject.release();
                    }
                    return;
                }
            }
        }
        LOG.debug("Fast up-to-date check didn't work, continue to regular build");
        BuildFSState fsState = preloadedProject != null ? preloadedProject.fsState : new BuildFSState(false);
        try {
            ProjectDescriptor pd;
            if (preloadedProject != null) {
                pd = preloadedProject;
                List<BuildMessage> preloadMessages = this.myPreloadedData.getLoadMessages();
                if (!preloadMessages.isEmpty()) {
                    for (BuildMessage message : preloadMessages) {
                        msgHandler.processMessage(message);
                    }
                }
                if (this.myInitialFSDelta == null || this.myPreloadedData.getFsEventOrdinal() + 1L != this.myInitialFSDelta.getOrdinal()) {
                    fsState.clearAll();
                } else {
                    try {
                        BuildSession.applyFSEvent(pd, this.myInitialFSDelta, false);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                        fsState.clearAll();
                    }
                }
            } else {
                pd = this.myBuildRunner.load(msgHandler, dataStorageRoot, fsState);
                TimingLog.LOG.debug("Project descriptor loaded");
                if (fsStateStream != null) {
                    try {
                        fsState.load(fsStateStream, pd.getModel(), pd.getBuildRootIndex());
                        BuildSession.applyFSEvent(pd, this.myInitialFSDelta, false);
                        TimingLog.LOG.debug("FS Delta loaded");
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                        fsState.clearAll();
                    }
                }
            }
            this.myProjectDescriptor = pd;
            if (this.myCacheLoadManager != null) {
                this.myCacheLoadManager.updateBuildStatistic(this.myProjectDescriptor);
            }
            this.myLastEventOrdinal.set(this.myInitialFSDelta != null ? this.myInitialFSDelta.getOrdinal() : 0L);
            this.myInitialFSDelta = null;
            this.myEventsProcessor.startProcessing();
            this.myBuildRunner.runBuild(pd, cs, msgHandler, this.myBuildType, this.myScopes, false);
            TimingLog.LOG.debug("Build finished");
        }
        finally {
            this.saveData(fsState, dataStorageRoot);
        }
    }

    private static boolean scopeContainsModulesOnlyForIncrementalMake(List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes) {
        TargetTypeRegistry typeRegistry = null;
        for (CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope scope : scopes) {
            BuildTargetType<?> targetType;
            if (scope.getForceBuild()) {
                LOG.debug("Build scope forces compilation for targets of type " + scope.getTypeId());
                return false;
            }
            String typeId = scope.getTypeId();
            if (BuildSession.isJavaModuleBuildType(typeId)) continue;
            if (typeRegistry == null) {
                typeRegistry = TargetTypeRegistry.getInstance();
            }
            if ((targetType = typeRegistry.getTargetType(typeId)) == null || targetType instanceof ModuleInducedTargetType) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Build scope contains target of type " + targetType + " which isn't eligible for fast up-to-date check");
            }
            return false;
        }
        return true;
    }

    private static boolean isJavaModuleBuildType(String typeId) {
        for (JavaModuleBuildTargetType moduleBuildTargetType : JavaModuleBuildTargetType.ALL_TYPES) {
            if (!moduleBuildTargetType.getTypeId().equals(typeId)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveData(BuildFSState fsState, Path dataStorageRoot) {
        boolean wasInterrupted = Thread.interrupted();
        try {
            this.saveFsState(dataStorageRoot, fsState);
            ProjectDescriptor pd = this.myProjectDescriptor;
            if (pd != null) {
                pd.release();
            }
        }
        finally {
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void processFSEvent(CmdlineRemoteProto.Message.ControllerMessage.FSEvent event) {
        this.myEventsProcessor.execute(() -> {
            try {
                BuildSession.applyFSEvent(this.myProjectDescriptor, event, true);
                this.myLastEventOrdinal.addAndGet(1L);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    private static void applyFSEvent(@NotNull ProjectDescriptor projectDescriptor, @Nullable CmdlineRemoteProto.Message.ControllerMessage.FSEvent event, boolean saveEventStamp) throws IOException {
        Comparable<File> file;
        if (projectDescriptor == null) {
            BuildSession.$$$reportNull$$$0(2);
        }
        if (event == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("applyFSEvent ordinal=" + event.getOrdinal());
        }
        BuildRootIndex buildRootIndex = projectDescriptor.getBuildRootIndex();
        BuildDataManager dataManager = projectDescriptor.dataManager;
        for (String deleted : event.getDeletedPathsList()) {
            file = new File(deleted);
            Collection descriptor = buildRootIndex.findAllParentDescriptors((File)file, null, null);
            if (!descriptor.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Applying deleted path from fs event: " + ((File)file).getPath());
                }
                for (BuildRootDescriptor rootDescriptor : descriptor) {
                    StampsStorage<?> stampStorage = dataManager.getFileStampStorage(rootDescriptor.getTarget());
                    projectDescriptor.fsState.registerDeleted(null, rootDescriptor.getTarget(), (File)file, stampStorage);
                }
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Skipping deleted path: " + ((File)file).getPath());
        }
        for (String changed : event.getChangedPathsList()) {
            List<BuildRootDescriptor> descriptors;
            file = Path.of(changed, new String[0]);
            Collection collection = buildRootIndex.findAllParentDescriptors(file.toFile(), null, null);
            if (collection.isEmpty()) {
                descriptors = List.of();
            } else {
                descriptors = new ArrayList();
                for (BuildRootDescriptor t : collection) {
                    if (t.isGenerated()) continue;
                    descriptors.add(t);
                }
            }
            if (!descriptors.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Applying dirty path from fs event: " + file);
                }
                for (BuildRootDescriptor descriptor : descriptors) {
                    Object currentUpToDateStamp;
                    StampsStorage<?> stampStorage = dataManager.getFileStampStorage(descriptor.getTarget());
                    Object v0 = currentUpToDateStamp = stampStorage == null ? null : stampStorage.getCurrentStampIfUpToDate((Path)file, descriptor.getTarget(), null);
                    if (currentUpToDateStamp == null) {
                        projectDescriptor.fsState.markDirty(null, file.toFile(), descriptor, stampStorage, saveEventStamp);
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug(descriptor.getTarget() + ": Path considered up-to-date: " + file + "; stamp= " + currentUpToDateStamp);
                }
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Skipping dirty path: " + file);
        }
    }

    private static void updateFsStateOnDisk(Path dataStorageRoot, DataInputStream original, long ordinal) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("updateFsStateOnDisk, ordinal=" + ordinal);
        }
        Path file = dataStorageRoot.resolve(FS_STATE_FILE);
        try {
            BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
            try (DataOutputStream out = new DataOutputStream((OutputStream)bytes);){
                int b;
                out.writeInt(3);
                out.writeLong(ordinal);
                out.writeBoolean(false);
                while ((b = original.read()) != -1) {
                    out.write(b);
                }
            }
            BuildSession.saveOnDisk(bytes, file);
        }
        catch (Throwable e) {
            LOG.error(e);
            try {
                Files.deleteIfExists(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void saveFsState(Path dataStorageRoot, BuildFSState state) {
        ProjectDescriptor pd = this.myProjectDescriptor;
        Path file = dataStorageRoot.resolve(FS_STATE_FILE);
        try {
            BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
            try (DataOutputStream out = new DataOutputStream((OutputStream)bytes);){
                out.writeInt(3);
                out.writeLong(this.myLastEventOrdinal.get());
                out.writeBoolean(BuildSession.hasWorkToDo(state, pd));
                state.save((DataOutput)out);
            }
            BuildSession.saveOnDisk(bytes, file);
        }
        catch (Throwable e) {
            LOG.error(e);
            try {
                Files.deleteIfExists(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static boolean hasWorkToDo(BuildFSState state, @Nullable ProjectDescriptor pd) {
        if (pd == null) {
            return true;
        }
        BuildTargetIndex targetIndex = pd.getBuildTargetIndex();
        for (JpsModule module : pd.getProject().getModules()) {
            for (ModuleBasedTarget<?> target : targetIndex.getModuleBasedTargets(module, BuildTargetRegistry.ModuleTargetSelector.ALL)) {
                if (pd.getBuildTargetIndex().isDummy(target) || !state.hasWorkToDo(target)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Has work to do in " + target);
                }
                return true;
            }
        }
        return false;
    }

    private static void saveOnDisk(BufferExposingByteArrayOutputStream bytes, Path file) throws IOException {
        try (FileOutputStream fos = BuildSession.writeOrCreate(file.toFile());){
            fos.write(bytes.getInternalBuffer(), 0, bytes.size());
        }
    }

    @NotNull
    private static FileOutputStream writeOrCreate(@NotNull File file) throws FileNotFoundException {
        if (file == null) {
            BuildSession.$$$reportNull$$$0(3);
        }
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException ignored) {
            FileUtil.createIfDoesntExist((File)file);
            return new FileOutputStream(file);
        }
    }

    @Nullable
    private static DataInputStream createFSDataStream(@NotNull Path dataStorageRoot, long currentEventOrdinal) {
        if (dataStorageRoot == null) {
            BuildSession.$$$reportNull$$$0(4);
        }
        Path file = dataStorageRoot.resolve(FS_STATE_FILE);
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(Files.readAllBytes(file)));
            int version = in.readInt();
            if (version != 3) {
                return null;
            }
            long savedOrdinal = in.readLong();
            if (savedOrdinal + 1L != currentEventOrdinal) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Discarding FS data: savedOrdinal=" + savedOrdinal + "; currentEventOrdinal=" + currentEventOrdinal);
                }
                return null;
            }
            return in;
        }
        catch (FileNotFoundException in) {
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        return null;
    }

    private static boolean containsChanges(CmdlineRemoteProto.Message.ControllerMessage.FSEvent event) {
        return event.getChangedPathsCount() != 0 || event.getDeletedPathsCount() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void finishBuild(Throwable error, boolean hadBuildErrors, boolean doneSomething) {
        block22: {
            CmdlineRemoteProto.Message lastMessage;
            block21: {
                lastMessage = null;
                if (error instanceof CannotLoadJpsModelException) {
                    String text = JpsBuildBundle.message("build.message.failed.to.load.project.configuration.0", StringUtil.decapitalize((String)error.getMessage()));
                    String path = ((CannotLoadJpsModelException)error).getFile().getAbsolutePath();
                    lastMessage = CmdlineProtoUtil.toMessage(this.mySessionId, CmdlineProtoUtil.createCompileMessage(BuildMessage.Kind.ERROR, text, path, -1L, -1L, -1L, -1L, -1L, -1.0f, Collections.emptyList()));
                    break block21;
                }
                if (error != null) {
                    Throwable cause = error.getCause();
                    if (cause == null) {
                        cause = error;
                    }
                    @Nls StringBuilder messageText = new StringBuilder();
                    messageText.append(JpsBuildBundle.message("build.message.internal.error.0.1", cause.getClass().getName(), cause.getMessage()));
                    String trace = ExceptionUtil.getThrowableText((Throwable)cause);
                    if (!trace.isEmpty()) {
                        messageText.append("\n").append(trace);
                    }
                    if (error instanceof RebuildRequestedException || cause instanceof IOException) {
                        messageText.append("\n").append(JpsBuildBundle.message("build.message.perform.full.project.rebuild", new Object[0]));
                    }
                    lastMessage = CmdlineProtoUtil.toMessage(this.mySessionId, CmdlineProtoUtil.createFailure(messageText.toString(), cause));
                    break block21;
                }
                CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status status = CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.SUCCESS;
                if (this.myCanceled) {
                    status = CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.CANCELED;
                } else if (hadBuildErrors) {
                    status = CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.ERRORS;
                } else if (!doneSomething) {
                    status = CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.UP_TO_DATE;
                }
                if (ProjectStamps.PORTABLE_CACHES) {
                    JpsOutputLoaderManager.saveLatestBuiltCommitId(status, this.myChannel, this.mySessionId);
                }
                lastMessage = CmdlineProtoUtil.toMessage(this.mySessionId, CmdlineProtoUtil.createBuildCompletedEvent("build completed", status));
            }
            try {
                this.myChannel.writeAndFlush((Object)lastMessage).await();
            }
            catch (InterruptedException e) {
                LOG.info((Throwable)e);
            }
            break block22;
            catch (Throwable e) {
                try {
                    lastMessage = CmdlineProtoUtil.toMessage(this.mySessionId, CmdlineProtoUtil.createFailure(e.getMessage(), e));
                }
                catch (Throwable throwable) {
                    try {
                        this.myChannel.writeAndFlush(lastMessage).await();
                    }
                    catch (InterruptedException e2) {
                        LOG.info((Throwable)e2);
                    }
                    throw throwable;
                }
                try {
                    this.myChannel.writeAndFlush((Object)lastMessage).await();
                }
                catch (InterruptedException e3) {
                    LOG.info((Throwable)e3);
                }
            }
        }
    }

    public void cancel() {
        this.myCanceled = true;
    }

    public boolean isCanceled() {
        return this.myCanceled;
    }

    private static BuildType convertCompileType(CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.Type compileType) {
        switch (compileType) {
            case CLEAN: {
                return BuildType.CLEAN;
            }
            case BUILD: {
                return BuildType.BUILD;
            }
            case UP_TO_DATE_CHECK: {
                return BuildType.UP_TO_DATE_CHECK;
            }
        }
        return BuildType.BUILD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msgHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStorageRoot";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/cmdline/BuildSession";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runBuild";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFSEvent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeOrCreate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createFSDataStream";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class EventsProcessor {
        private final Semaphore myProcessingEnabled = new Semaphore();
        private final Executor myExecutorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"BuildSession.EventsProcessor.EventsProcessor Pool", (Executor)SharedThreadPool.getInstance());

        private EventsProcessor() {
            this.myProcessingEnabled.down();
            this.execute(() -> ((Semaphore)this.myProcessingEnabled).waitFor());
        }

        private void startProcessing() {
            this.myProcessingEnabled.up();
        }

        public void execute(@NotNull Runnable task) {
            if (task == null) {
                EventsProcessor.$$$reportNull$$$0(0);
            }
            this.myExecutorService.execute(task);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/jps/cmdline/BuildSession$EventsProcessor", "execute"));
        }
    }
}

