/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.inspections;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.webSymbols.inspections.WebSymbolsInspectionsPass;
import com.intellij.webSymbols.inspections.impl.WebSymbolsHighlightInLanguageEP;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/webSymbols/inspections/WebSymbolsPassFactory;", "Lcom/intellij/codeHighlighting/DirtyScopeTrackingHighlightingPassFactory;", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "<init>", "(Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;)V", "passId", "", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getPassId", "Registrar", "intellij.platform.webSymbols"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nWebSymbolsPassFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolsPassFactory.kt\ncom/intellij/webSymbols/inspections/WebSymbolsPassFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,29:1\n1755#2,3:30\n*S KotlinDebug\n*F\n+ 1 WebSymbolsPassFactory.kt\ncom/intellij/webSymbols/inspections/WebSymbolsPassFactory\n*L\n23#1:30,3\n*E\n"})
public final class WebSymbolsPassFactory
implements DirtyScopeTrackingHighlightingPassFactory {
    private final int passId;

    public WebSymbolsPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        int[] nArray = new int[]{7};
        this.passId = registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, nArray, true, -1);
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        TextEditorHighlightingPass textEditorHighlightingPass;
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            List list2 = file.getViewProvider().getAllFiles();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllFiles(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiFile it = (PsiFile)element$iv;
                    boolean bl2 = false;
                    Language language = it.getLanguage();
                    Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
                    if (!WebSymbolsHighlightInLanguageEP.Companion.shouldHighlight(language)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            textEditorHighlightingPass = new WebSymbolsInspectionsPass(file, document);
        } else {
            textEditorHighlightingPass = null;
        }
        return textEditorHighlightingPass;
    }

    public int getPassId() {
        return this.passId;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/webSymbols/inspections/WebSymbolsPassFactory$Registrar;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "<init>", "()V", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.webSymbols"})
    @ApiStatus.Internal
    public static final class Registrar
    implements TextEditorHighlightingPassFactoryRegistrar {
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            new WebSymbolsPassFactory(registrar);
        }
    }
}

