/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

public class PsiIdentifierOwnerTokenizer
extends Tokenizer<PsiNameIdentifierOwner> {
    public static final PsiIdentifierOwnerTokenizer INSTANCE = new PsiIdentifierOwnerTokenizer();

    @Override
    public void tokenize(@NotNull PsiNameIdentifierOwner element, @NotNull TokenConsumer consumer) {
        PsiElement identifier;
        if (element == null) {
            PsiIdentifierOwnerTokenizer.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            PsiIdentifierOwnerTokenizer.$$$reportNull$$$0(1);
        }
        if ((identifier = element.getNameIdentifier()) == null) {
            return;
        }
        PsiNameIdentifierOwner parent = element;
        TextRange range = identifier.getTextRange();
        if (range.isEmpty()) {
            return;
        }
        int offset = range.getStartOffset() - parent.getTextRange().getStartOffset();
        if (offset < 0) {
            parent = PsiTreeUtil.findCommonParent((PsiElement)identifier, (PsiElement)element);
            offset = range.getStartOffset() - parent.getTextRange().getStartOffset();
        }
        String text2 = identifier.getText();
        consumer.consumeToken((PsiElement)parent, text2, true, offset, TextRange.allOf((String)text2), IdentifierSplitter.getInstance());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/spellchecker/tokenizer/PsiIdentifierOwnerTokenizer";
        objectArray[2] = "tokenize";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

