/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.google.common.collect.Iterables;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationGroup;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class CommittedListsSequencesZipper {
    @NotNull
    private final VcsCommittedListsZipper myVcsPartner;
    @NotNull
    private final List<RepositoryLocation> myInLocations;
    @NotNull
    private final Map<String, List<? extends CommittedChangeList>> myInLists;
    @NotNull
    private final Comparator<CommittedChangeList> myComparator;

    public CommittedListsSequencesZipper(@NotNull VcsCommittedListsZipper vcsPartner) {
        if (vcsPartner == null) {
            CommittedListsSequencesZipper.$$$reportNull$$$0(0);
        }
        this.myVcsPartner = vcsPartner;
        this.myInLocations = new ArrayList<RepositoryLocation>();
        this.myInLists = new HashMap<String, List<? extends CommittedChangeList>>();
        this.myComparator = (o1, o2) -> Long.compare(this.myVcsPartner.getNumber(o1), this.myVcsPartner.getNumber(o2));
    }

    public void add(@NotNull RepositoryLocation location, @NotNull List<? extends CommittedChangeList> lists) {
        if (location == null) {
            CommittedListsSequencesZipper.$$$reportNull$$$0(1);
        }
        if (lists == null) {
            CommittedListsSequencesZipper.$$$reportNull$$$0(2);
        }
        this.myInLocations.add(location);
        lists.sort(this.myComparator);
        this.myInLists.put(location.toPresentableString(), lists);
    }

    @NotNull
    public List<CommittedChangeList> execute() {
        Pair groupingResult = this.myVcsPartner.groupLocations(this.myInLocations);
        ArrayList<CommittedChangeList> result2 = new ArrayList<CommittedChangeList>();
        result2.addAll(ContainerUtil.flatten(this.collectChangeLists((List)groupingResult.getSecond())));
        for (RepositoryLocationGroup group : (List)groupingResult.getFirst()) {
            result2.addAll(this.mergeLocationGroupChangeLists(group));
        }
        ArrayList<CommittedChangeList> arrayList = result2;
        if (arrayList == null) {
            CommittedListsSequencesZipper.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private List<List<? extends CommittedChangeList>> collectChangeLists(@NotNull List<? extends RepositoryLocation> locations) {
        if (locations == null) {
            CommittedListsSequencesZipper.$$$reportNull$$$0(4);
        }
        ArrayList<List<? extends CommittedChangeList>> result2 = new ArrayList<List<? extends CommittedChangeList>>(locations.size());
        for (RepositoryLocation repositoryLocation : locations) {
            result2.add(this.myInLists.get(repositoryLocation.toPresentableString()));
        }
        ArrayList<List<? extends CommittedChangeList>> arrayList = result2;
        if (arrayList == null) {
            CommittedListsSequencesZipper.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private List<CommittedChangeList> mergeLocationGroupChangeLists(@NotNull RepositoryLocationGroup group) {
        if (group == null) {
            CommittedListsSequencesZipper.$$$reportNull$$$0(6);
        }
        ArrayList<CommittedChangeList> result2 = new ArrayList<CommittedChangeList>();
        ArrayList<CommittedChangeList> equalLists = new ArrayList<CommittedChangeList>();
        CommittedChangeList previousList = null;
        for (CommittedChangeList list : Iterables.mergeSorted(this.collectChangeLists(group.getLocations()), this.myComparator)) {
            if (previousList != null && this.myComparator.compare(previousList, list) != 0) {
                result2.add(this.zip(group, equalLists));
                equalLists.clear();
            }
            equalLists.add(list);
            previousList = list;
        }
        if (!equalLists.isEmpty()) {
            result2.add(this.zip(group, equalLists));
        }
        ArrayList<CommittedChangeList> arrayList = result2;
        if (arrayList == null) {
            CommittedListsSequencesZipper.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    private CommittedChangeList zip(@NotNull RepositoryLocationGroup group, @NotNull List<? extends CommittedChangeList> equalLists) {
        if (group == null) {
            CommittedListsSequencesZipper.$$$reportNull$$$0(8);
        }
        if (equalLists == null) {
            CommittedListsSequencesZipper.$$$reportNull$$$0(9);
        }
        if (equalLists.isEmpty()) {
            throw new IllegalArgumentException("equalLists can not be empty");
        }
        CommittedChangeList committedChangeList = equalLists.size() > 1 ? this.myVcsPartner.zip(group, equalLists) : equalLists.get(0);
        if (committedChangeList == null) {
            CommittedListsSequencesZipper.$$$reportNull$$$0(10);
        }
        return committedChangeList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsPartner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/committed/CommittedListsSequencesZipper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locations";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalLists";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/CommittedListsSequencesZipper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectChangeLists";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeLocationGroupChangeLists";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectChangeLists";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mergeLocationGroupChangeLists";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7, 10 -> new IllegalStateException(string);
        };
    }
}

