/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.fixture;

import java.awt.Color;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.util.Colors;

public class ColorFixture {
    private final Color target;
    private final Description description;

    public ColorFixture(@Nonnull Color target) {
        this(target, (Description)null);
    }

    public ColorFixture(@Nonnull Color target, @Nonnull String description) {
        this(target, new TextDescription(description, new Object[0]));
    }

    public ColorFixture(@Nonnull Color target, @Nullable Description description) {
        this.target = Preconditions.checkNotNull(target);
        this.description = description;
    }

    @Nonnull
    public ColorFixture requireEqualTo(@Nonnull String hexValue) {
        return this.requireEqualTo(Colors.colorFromHexString(hexValue));
    }

    @Nonnull
    public ColorFixture requireEqualTo(@Nullable Color color) {
        Color assertThat = Assertions.assertThat(this.target);
        this.describe((AbstractObjectAssert<?, Color>)((Object)assertThat));
        ((AbstractAssert)((Object)assertThat)).isEqualTo(color);
        return this;
    }

    private void describe(AbstractObjectAssert<?, Color> assertThat) {
        if (this.description != null) {
            assertThat.as(this.description);
        }
    }

    @Nonnull
    public ColorFixture requireNotEqualTo(@Nonnull String hexValue) {
        return this.requireNotEqualTo(Colors.colorFromHexString(hexValue));
    }

    @Nonnull
    public ColorFixture requireNotEqualTo(@Nullable Color color) {
        Color assertThat = Assertions.assertThat(this.target);
        this.describe((AbstractObjectAssert<?, Color>)((Object)assertThat));
        ((AbstractAssert)((Object)assertThat)).isNotEqualTo(color);
        return this;
    }

    @Nonnull
    public Color target() {
        return this.target;
    }

    @Nullable
    public final String description() {
        return this.description != null ? this.description.value() : null;
    }
}

