/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.lang.properties.IProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.references.MavenPropertyPsiReference;
import org.jetbrains.idea.maven.project.MavenProject;

public class MavenFilteredPropertyPsiReference
extends MavenPropertyPsiReference {
    public MavenFilteredPropertyPsiReference(MavenProject mavenProject, PsiElement element, String text, TextRange range) {
        super(mavenProject, element, text, range, true);
    }

    @Override
    protected PsiElement doResolve() {
        PsiElement result2 = super.doResolve();
        if (result2 != null) {
            return result2;
        }
        for (String each : this.myMavenProject.getFilterPropertiesFiles()) {
            IProperty property;
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(each);
            if (file == null || (property = MavenDomUtil.findProperty(this.myProject, file, this.myText)) == null) continue;
            return property.getPsiElement();
        }
        return null;
    }

    @Override
    protected void collectVariants(List<Object> result2, Set<String> variants) {
        super.collectVariants(result2, variants);
        for (String each : this.myMavenProject.getFilterPropertiesFiles()) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(each);
            if (file == null) continue;
            MavenFilteredPropertyPsiReference.collectPropertiesFileVariants(MavenDomUtil.getPropertiesFile(this.myProject, file), null, result2, variants);
        }
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            MavenFilteredPropertyPsiReference.$$$reportNull$$$0(0);
        }
        String newText = this.myRange.replace(this.myElement.getText(), newElementName);
        PsiFile psiFile = this.myElement.getContainingFile();
        String newFileText = this.myElement.getTextRange().replace(psiFile.getText(), newText);
        PsiFile f = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("__" + psiFile.getName(), psiFile.getLanguage(), (CharSequence)newFileText);
        PsiElement el = f.findElementAt(this.myElement.getTextOffset());
        return this.myElement.replace(el);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElementName", "org/jetbrains/idea/maven/dom/references/MavenFilteredPropertyPsiReference", "handleElementRename"));
    }
}

