/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.ui;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ClassKind;
import com.intellij.ide.IdeDeprecatedMessagesBundle;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveClassesOrPackages.MultipleRootsMoveDestination;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.ui.KotlinDestinationFolderComboBox;
import org.jetbrains.kotlin.idea.roots.ProjectRootUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 32\u00020\u0001:\u000223BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010 \u001a\u00020\u000bH\u0014J\b\u0010!\u001a\u00020\u000bH\u0014J\u0013\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0014\u00a2\u0006\u0002\u0010%J\n\u0010&\u001a\u0004\u0018\u00010'H\u0016J\n\u0010(\u001a\u0004\u0018\u00010'H\u0014J\n\u0010)\u001a\u0004\u0018\u00010'H\u0014J\b\u0010-\u001a\u00020.H\u0014J\u0014\u0010/\u001a\u0004\u0018\u00010\u001a2\b\u0010*\u001a\u0004\u0018\u00010\u0005H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0011\u00100\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b1\u0010,\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/ui/CreateKotlinClassDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "myProject", "Lcom/intellij/openapi/project/Project;", "title", "", "myClassName", "targetPackageName", "kind", "Lcom/intellij/codeInsight/daemon/impl/quickfix/ClassKind;", "myClassNameEditable", "", "myModule", "Lcom/intellij/openapi/module/Module;", "isSealed", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/codeInsight/daemon/impl/quickfix/ClassKind;ZLcom/intellij/openapi/module/Module;Z)V", "()Z", "myInformationLabel", "Ljavax/swing/JLabel;", "myPackageLabel", "myPackageComponent", "Lcom/intellij/ui/ReferenceEditorComboWithBrowseButton;", "myTfClassName", "Ljavax/swing/JTextField;", "value", "Lcom/intellij/psi/PsiDirectory;", "targetDirectory", "getTargetDirectory", "()Lcom/intellij/psi/PsiDirectory;", "myDestinationCB", "Lorg/jetbrains/kotlin/idea/refactoring/ui/KotlinDestinationFolderComboBox;", "reportBaseInTestSelectionInSource", "reportBaseInSourceSelectionInTest", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "createCenterPanel", "createNorthPanel", "packageName", "getPackageName", "()Ljava/lang/String;", "doOKAction", "", "getBaseDir", "className", "getClassName", "MyTextField", "Companion", "kotlin.code-insight.impl-base"})
public class CreateKotlinClassDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myClassName;
    private final boolean myClassNameEditable;
    @Nullable
    private final Module myModule;
    private final boolean isSealed;
    @NotNull
    private final JLabel myInformationLabel;
    @NotNull
    private final JLabel myPackageLabel;
    @NotNull
    private ReferenceEditorComboWithBrowseButton myPackageComponent;
    @NotNull
    private final JTextField myTfClassName;
    @Nullable
    private PsiDirectory targetDirectory;
    @NotNull
    private final KotlinDestinationFolderComboBox myDestinationCB;
    @NonNls
    @NotNull
    private static final String RECENTS_KEY = "CreateKotlinClassDialog.RecentsKey";

    /*
     * WARNING - void declaration
     */
    public CreateKotlinClassDialog(@NotNull Project myProject, @Nls @NotNull String title, @NotNull String myClassName, @NotNull String targetPackageName, @NotNull ClassKind kind2, boolean myClassNameEditable, @Nullable Module myModule, boolean isSealed) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)myClassName, (String)"myClassName");
        Intrinsics.checkNotNullParameter((Object)targetPackageName, (String)"targetPackageName");
        Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
        super(myProject, true);
        this.myProject = myProject;
        this.myClassName = myClassName;
        this.myClassNameEditable = myClassNameEditable;
        this.myModule = myModule;
        this.isSealed = isSealed;
        this.myInformationLabel = new JLabel("#");
        this.myPackageLabel = new JLabel(IdeDeprecatedMessagesBundle.message((String)"dialog.create.class.destination.package.label", (Object[])new Object[0]));
        Object[] objectArray2 = objectArray = new PackageNameReferenceEditorCombo(targetPackageName, this.myProject, RECENTS_KEY, IdeDeprecatedMessagesBundle.message((String)"dialog.create.class.package.chooser.title", (Object[])new Object[0]));
        CreateKotlinClassDialog createKotlinClassDialog = this;
        boolean bl = false;
        if (this.isSealed) {
            void it;
            it.setEnabled(false);
        }
        createKotlinClassDialog.myPackageComponent = (ReferenceEditorComboWithBrowseButton)objectArray;
        this.myTfClassName = new MyTextField();
        this.myDestinationCB = new KotlinDestinationFolderComboBox(this){
            final /* synthetic */ CreateKotlinClassDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public String getTargetPackage() {
                String string = CreateKotlinClassDialog.access$getMyPackageComponent$p(this.this$0).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                return ((Object)StringsKt.trim((CharSequence)string)).toString();
            }

            protected boolean reportBaseInTestSelectionInSource() {
                return this.this$0.reportBaseInTestSelectionInSource();
            }

            protected boolean reportBaseInSourceSelectionInTest() {
                return this.this$0.reportBaseInSourceSelectionInTest();
            }

            protected boolean sourceRootsInTargetDirOnly() {
                return this.this$0.isSealed();
            }
        };
        this.myPackageComponent.setTextFieldPreferredWidth(40);
        this.init();
        if (!this.myClassNameEditable) {
            objectArray = new Object[]{StringUtil.capitalize((String)kind2.getDescription()), this.myClassName};
            this.setTitle(IdeDeprecatedMessagesBundle.message((String)"dialog.create.class.name", (Object[])objectArray));
        } else {
            objectArray = new Object[]{kind2.getDescription()};
            this.myInformationLabel.setText(IdeDeprecatedMessagesBundle.message((String)"dialog.create.class.label", (Object[])objectArray));
            this.setTitle(title);
        }
        this.myTfClassName.setText(this.myClassName);
        this.myDestinationCB.setData(this.myProject, this.getBaseDir(targetPackageName), (Consumer)new Pass<String>(){

            public void pass(String s) {
                String text = s;
                this.setErrorText(text, (JComponent)((Object)myDestinationCB));
            }
        }, (EditorComboBox)this.myPackageComponent.getChildComponent());
    }

    public /* synthetic */ CreateKotlinClassDialog(Project project, String string, String string2, String string3, ClassKind classKind, boolean bl, Module module, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            bl2 = false;
        }
        this(project, string, string2, string3, classKind, bl, module, bl2);
    }

    public final boolean isSealed() {
        return this.isSealed;
    }

    @Nullable
    public final PsiDirectory getTargetDirectory() {
        return this.targetDirectory;
    }

    protected boolean reportBaseInTestSelectionInSource() {
        return false;
    }

    protected boolean reportBaseInSourceSelectionInTest() {
        return false;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        return actionArray;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myClassNameEditable ? (JComponent)this.myTfClassName : this.myPackageComponent.getChildComponent();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return new JPanel(new BorderLayout());
    }

    @Nullable
    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = (Insets)JBUI.insets((int)4, (int)8);
        gbConstraints.fill = 2;
        gbConstraints.anchor = 17;
        if (this.myClassNameEditable) {
            gbConstraints.weightx = 0.0;
            gbConstraints.gridwidth = 1;
            panel.add((Component)this.myInformationLabel, gbConstraints);
            gbConstraints.insets = (Insets)JBUI.insets((int)4, (int)8);
            gbConstraints.gridx = 1;
            gbConstraints.weightx = 1.0;
            gbConstraints.gridwidth = 1;
            gbConstraints.fill = 2;
            gbConstraints.anchor = 17;
            panel.add((Component)this.myTfClassName, gbConstraints);
            this.myTfClassName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(this){
                final /* synthetic */ CreateKotlinClassDialog this$0;
                {
                    this.this$0 = $receiver;
                }

                protected void textChanged(DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    CreateKotlinClassDialog.access$getOKAction(this.this$0).setEnabled(PsiNameHelper.getInstance((Project)CreateKotlinClassDialog.access$getMyProject$p(this.this$0)).isIdentifier(CreateKotlinClassDialog.access$getMyTfClassName$p(this.this$0).getText()));
                }
            });
            this.getOKAction().setEnabled(StringUtil.isNotEmpty((String)this.myClassName));
        }
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 2;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 1;
        panel.add((Component)this.myPackageLabel, gbConstraints);
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 1.0;
        new AnAction(this){
            final /* synthetic */ CreateKotlinClassDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                CreateKotlinClassDialog.access$getMyPackageComponent$p(this.this$0).getButton().doClick();
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(10, 64)), this.myPackageComponent.getChildComponent());
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myPackageComponent, "Center");
        panel.add((Component)_panel, gbConstraints);
        gbConstraints.gridy = 3;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 2;
        gbConstraints.insets.top = 12;
        gbConstraints.anchor = 17;
        gbConstraints.fill = 0;
        JBLabel label2 = new JBLabel(RefactoringBundle.message((String)"target.destination.folder"));
        panel.add((Component)label2, gbConstraints);
        gbConstraints.gridy = 4;
        gbConstraints.gridx = 0;
        gbConstraints.fill = 2;
        gbConstraints.insets.top = 4;
        panel.add((Component)((Object)this.myDestinationCB), gbConstraints);
        boolean isMultipleSourceRoots = ProjectRootUtilsKt.getSuitableDestinationSourceRoots(this.myProject).size() > 1;
        this.myDestinationCB.setVisible(isMultipleSourceRoots);
        label2.setVisible(isMultipleSourceRoots);
        label2.setLabelFor((Component)((Object)this.myDestinationCB));
        return panel;
    }

    private final String getPackageName() {
        String name2 = this.myPackageComponent.getText();
        String string = name2;
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
            string = "";
        }
        return string;
    }

    protected void doOKAction() {
        RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(RECENTS_KEY, this.myPackageComponent.getText());
        String packageName = this.getPackageName();
        Ref.ObjectRef errorString = new Ref.ObjectRef();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> CreateKotlinClassDialog.doOKAction$lambda$2(this, packageName, errorString), CodeInsightBundle.message((String)"create.directory.command", (Object[])new Object[0]), null);
        String string = (String)errorString.element;
        if (string != null) {
            String it = string;
            boolean bl = false;
            if (((CharSequence)it).length() > 0) {
                Messages.showMessageDialog((Project)this.myProject, (String)((String)errorString.element), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            }
        } else {
            super.doOKAction();
        }
    }

    @Nullable
    protected PsiDirectory getBaseDir(@Nullable String packageName) {
        return this.myModule == null || packageName == null ? null : PackageUtil.findPossiblePackageDirectoryInModule((Module)this.myModule, (String)packageName);
    }

    @NotNull
    public final String getClassName() {
        String string;
        if (this.myClassNameEditable) {
            String string2 = this.myTfClassName.getText();
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = this.myClassName;
        }
        return string;
    }

    private static final PsiDirectory doOKAction$lambda$2$lambda$1(CreateKotlinClassDialog this$0, String $packageName, MoveDestination $destination, Ref.ObjectRef $errorString) {
        PsiDirectory baseDir = this$0.getBaseDir($packageName);
        if (baseDir == null && $destination instanceof MultipleRootsMoveDestination) {
            Object[] objectArray = new Object[]{$packageName};
            $errorString.element = KotlinBundle.message((String)"destination.not.found.for.package.0", (Object[])objectArray);
            return null;
        }
        return $destination.getTargetDirectory(baseDir);
    }

    private static final void doOKAction$lambda$2(CreateKotlinClassDialog this$0, String $packageName, Ref.ObjectRef $errorString) {
        try {
            PackageWrapper targetPackage = new PackageWrapper(PsiManager.getInstance((Project)this$0.myProject), $packageName);
            MoveDestination moveDestination = this$0.myDestinationCB.selectDirectory(targetPackage, false);
            if (moveDestination == null) {
                return;
            }
            MoveDestination destination = moveDestination;
            this$0.targetDirectory = (PsiDirectory)WriteAction.compute(() -> CreateKotlinClassDialog.doOKAction$lambda$2$lambda$1(this$0, $packageName, destination, $errorString));
            if (this$0.targetDirectory == null) {
                return;
            }
            $errorString.element = RefactoringMessageUtil.checkCanCreateClass((PsiDirectory)this$0.targetDirectory, (String)this$0.getClassName());
        }
        catch (IncorrectOperationException e) {
            $errorString.element = e.getMessage();
        }
    }

    public static final /* synthetic */ Action access$getOKAction(CreateKotlinClassDialog $this) {
        return $this.getOKAction();
    }

    public static final /* synthetic */ Project access$getMyProject$p(CreateKotlinClassDialog $this) {
        return $this.myProject;
    }

    public static final /* synthetic */ JTextField access$getMyTfClassName$p(CreateKotlinClassDialog $this) {
        return $this.myTfClassName;
    }

    public static final /* synthetic */ ReferenceEditorComboWithBrowseButton access$getMyPackageComponent$p(CreateKotlinClassDialog $this) {
        return $this.myPackageComponent;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/ui/CreateKotlinClassDialog$Companion;", "", "<init>", "()V", "RECENTS_KEY", "", "kotlin.code-insight.impl-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/ui/CreateKotlinClassDialog$MyTextField;", "Ljavax/swing/JTextField;", "<init>", "()V", "getPreferredSize", "Ljava/awt/Dimension;", "kotlin.code-insight.impl-base"})
    private static final class MyTextField
    extends JTextField {
        @Override
        @NotNull
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            size.width = fontMetrics.charWidth('a') * 40;
            Intrinsics.checkNotNull((Object)size);
            return size;
        }
    }
}

