/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinResolveSnapshotProvider;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/KotlinResolveSnapshotProvider;", "Lcom/intellij/refactoring/rename/ResolveSnapshotProvider;", "<init>", "()V", "createSnapshot", "Lcom/intellij/refactoring/rename/ResolveSnapshotProvider$ResolveSnapshot;", "scope", "Lcom/intellij/psi/PsiElement;", "kotlin.idea"})
public final class KotlinResolveSnapshotProvider
extends ResolveSnapshotProvider {
    @NotNull
    public ResolveSnapshotProvider.ResolveSnapshot createSnapshot(@NotNull PsiElement scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return new ResolveSnapshotProvider.ResolveSnapshot(scope){
            private final Project project;
            private final Document document;
            private final HashMap<SmartPsiElementPointer<?>, PropertyDescriptor> refExpressionToDescriptor;
            {
                Project project = $scope.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                this.project = project;
                Document document = PsiDocumentManager.getInstance((Project)this.project).getDocument($scope.getContainingFile());
                Intrinsics.checkNotNull((Object)document);
                this.document = document;
                this.refExpressionToDescriptor = new HashMap();
                $scope.accept((PsiElementVisitor)new KtTreeVisitorVoid(this){
                    final /* synthetic */ createSnapshot.1 this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void visitSimpleNameExpression(KtSimpleNameExpression expression) {
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        if (KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)expression)) != null) {
                            super.visitSimpleNameExpression(expression);
                            return;
                        }
                        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)ReferenceUtilKt.resolveMainReferenceToDescriptors((KtElement)expression));
                        if (declarationDescriptor == null) {
                            return;
                        }
                        DeclarationDescriptor targetDescriptor = declarationDescriptor;
                        if (!(targetDescriptor instanceof PropertyDescriptor)) {
                            return;
                        }
                        ((Map)createSnapshot.1.access$getRefExpressionToDescriptor$p(this.this$0)).put(SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)expression)), targetDescriptor);
                    }
                });
            }

            public void apply(String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                PsiDocumentManager.getInstance((Project)this.project).commitDocument(this.document);
                ArrayList<E> elementsToShorten = new ArrayList<E>();
                for (Map.Entry<K, V> entry : ((Map)this.refExpressionToDescriptor).entrySet()) {
                    PsiElement psiElement;
                    Object object;
                    DeclarationDescriptor containingDescriptor;
                    PsiElement refExpr;
                    SmartPsiElementPointer refExprPointer = (SmartPsiElementPointer)entry.getKey();
                    PropertyDescriptor targetDescriptor = (PropertyDescriptor)entry.getValue();
                    if (refExprPointer.getElement() == null || !Intrinsics.areEqual((Object)refExpr.getText(), (Object)name2)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)targetDescriptor.getContainingDeclaration(), (String)"getContainingDeclaration(...)");
                    if (containingDescriptor instanceof ClassDescriptor) {
                        object = KotlinRefactoringUtilKt.explicateAsTextForReceiver(containingDescriptor) + "." + targetDescriptor.getName().asString();
                    } else {
                        Intrinsics.checkNotNull((Object)targetDescriptor);
                        object = ImportsUtils.getImportableFqName((DeclarationDescriptor)targetDescriptor);
                        if (object == null || (object = object.asString()) == null) continue;
                    }
                    String qualifiedRefText = object;
                    KtExpression qualifiedRefExpr = new KtPsiFactory(this.project, false, 2, null).createExpression(qualifiedRefText);
                    Collection collection = elementsToShorten;
                    PsiElement $this$replaced$iv = refExpr;
                    boolean $i$f$replaced = false;
                    if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)qualifiedRefExpr))) {
                        psiElement = (PsiElement)qualifiedRefExpr;
                    } else {
                        PsiElement result$iv = $this$replaced$iv.replace((PsiElement)qualifiedRefExpr);
                        if (result$iv instanceof KtExpression) {
                            psiElement = result$iv;
                        } else {
                            Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                            KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                            if (ktExpression == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                            }
                            psiElement = (PsiElement)ktExpression;
                        }
                    }
                    PsiElement psiElement2 = psiElement;
                    collection.add(psiElement2);
                }
                ShortenReferences.process$default(new ShortenReferences((Function1<? super KtElement, ShortenReferences.Options>)((Function1)createSnapshot.1::apply$lambda$0)), elementsToShorten, null, false, 6, null);
            }

            private static final ShortenReferences.Options apply$lambda$0(KtElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ShortenReferences.Options.Companion.getALL_ENABLED();
            }

            public static final /* synthetic */ HashMap access$getRefExpressionToDescriptor$p(createSnapshot.1 $this) {
                return $this.refExpressionToDescriptor;
            }
        };
    }
}

