/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.hints;

import com.intellij.codeInsight.hints.declarative.HintFormat;
import com.intellij.codeInsight.hints.declarative.InlayActionData;
import com.intellij.codeInsight.hints.declarative.InlayActionPayload;
import com.intellij.codeInsight.hints.declarative.InlayPosition;
import com.intellij.codeInsight.hints.declarative.InlayTreeSink;
import com.intellij.codeInsight.hints.declarative.InlineInlayPosition;
import com.intellij.codeInsight.hints.declarative.PresentationTreeBuilder;
import com.intellij.codeInsight.hints.declarative.PsiPointerInlayActionPayload;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaAnonymousFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaReceiverParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.codeInsight.hints.InlayHintUtilsKt;
import org.jetbrains.kotlin.idea.codeInsight.hints.InlayInfoOptionKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.hints.AbstractKtInlayHintsProvider;
import org.jetbrains.kotlin.idea.k2.codeinsight.hints.KtReferencesTypeHintsProviderKt;
import org.jetbrains.kotlin.idea.k2.codeinsight.hints.PrintTypeKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/hints/KtLambdasHintsProvider;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/hints/AbstractKtInlayHintsProvider;", "<init>", "()V", "collectFromElement", "", "element", "Lcom/intellij/psi/PsiElement;", "sink", "Lcom/intellij/codeInsight/hints/declarative/InlayTreeSink;", "isLambdaReturnExpression", "", "e", "collectFromLambdaReturnExpression", "getNameOfFunctionThatTakesLambda", "", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "isLambdaImplicitParameterReceiver", "collectFromLambdaImplicitParameterReceiver", "kotlin.code-insight.k2"})
@SourceDebugExtension(value={"SMAP\nKtLambdasHintsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtLambdasHintsProvider.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/hints/KtLambdasHintsProvider\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 5 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n150#2:113\n150#2:114\n150#2:115\n1755#3,3:116\n28#4,2:119\n28#4,2:134\n36#5,13:121\n36#5,9:136\n47#5,2:146\n1#6:145\n*S KotlinDebug\n*F\n+ 1 KtLambdasHintsProvider.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/hints/KtLambdasHintsProvider\n*L\n39#1:113\n40#1:114\n64#1:115\n65#1:116,3\n44#1:119,2\n91#1:134,2\n44#1:121,13\n91#1:136,9\n91#1:146,2\n*E\n"})
public final class KtLambdasHintsProvider
extends AbstractKtInlayHintsProvider {
    @Override
    protected void collectFromElement(@NotNull PsiElement element, @NotNull InlayTreeSink sink) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.collectFromLambdaReturnExpression(element, sink);
        this.collectFromLambdaImplicitParameterReceiver(element, sink);
    }

    private final boolean isLambdaReturnExpression(PsiElement e) {
        return e instanceof KtExpression && !(e instanceof KtFunctionLiteral) && !KtReferencesTypeHintsProviderKt.isNameReferenceInCall(e) && KtReferencesTypeHintsProviderKt.isLambdaReturnValueHintsApplicable$default((KtExpression)e, false, 1, null);
    }

    public final void collectFromLambdaReturnExpression(@NotNull PsiElement element, @NotNull InlayTreeSink sink) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (!this.isLambdaReturnExpression(element)) {
            return;
        }
        KtExpression ktExpression = element instanceof KtExpression ? (KtExpression)element : null;
        if (ktExpression == null) {
            return;
        }
        KtExpression expression = ktExpression;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)expression;
        boolean $i$f$getStrictParentOfType = false;
        KtFunctionLiteral ktFunctionLiteral = (KtFunctionLiteral)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtFunctionLiteral.class, (boolean)true);
        if (ktFunctionLiteral == null) {
            return;
        }
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        PsiElement $this$getStrictParentOfType$iv2 = (PsiElement)functionLiteral;
        boolean $i$f$getStrictParentOfType2 = false;
        KtLambdaExpression ktLambdaExpression = (KtLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv2, KtLambdaExpression.class, (boolean)true);
        if (ktLambdaExpression == null) {
            return;
        }
        KtLambdaExpression lambdaExpression = ktLambdaExpression;
        String string = this.getNameOfFunctionThatTakesLambda(lambdaExpression);
        if (string == null) {
            string = "lambda";
        }
        String lambdaName = string;
        sink.whenOptionEnabled(InlayInfoOptionKt.getSHOW_RETURN_EXPRESSIONS().getName(), () -> KtLambdasHintsProvider.collectFromLambdaReturnExpression$lambda$3(lambdaExpression, sink, expression, lambdaName));
    }

    private final String getNameOfFunctionThatTakesLambda(KtLambdaExpression $this$getNameOfFunctionThatTakesLambda) {
        String string;
        boolean bl;
        KtCallExpression callExpression;
        KtLambdaExpression lambda2;
        block8: {
            lambda2 = $this$getNameOfFunctionThatTakesLambda;
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$getNameOfFunctionThatTakesLambda;
            boolean $i$f$getStrictParentOfType = false;
            KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallExpression.class, (boolean)true);
            if (ktCallExpression == null) {
                return null;
            }
            callExpression = ktCallExpression;
            List list2 = callExpression.getLambdaArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getLambdaArguments(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtLambdaArgument it = (KtLambdaArgument)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getLambdaExpression(), (Object)lambda2)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            PsiElement parent = lambda2.getParent();
            if (parent instanceof KtLabeledExpression) {
                string = ((KtLabeledExpression)parent).getLabelName();
            } else {
                KtExpression ktExpression = callExpression.getCalleeExpression();
                KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
                string = ktNameReferenceExpression != null ? ktNameReferenceExpression.getReferencedName() : null;
            }
        } else {
            string = null;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLambdaImplicitParameterReceiver(PsiElement e) {
        if (!(e instanceof KtFunctionLiteral)) return false;
        if (!(((KtFunctionLiteral)e).getParent() instanceof KtLambdaExpression)) return false;
        PsiElement psiElement = ((KtFunctionLiteral)e).getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtLambdaExpression");
        ASTNode aSTNode = ((KtLambdaExpression)psiElement).getLeftCurlyBrace();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getLeftCurlyBrace(...)");
        if (!InlayHintUtilsKt.isFollowedByNewLine(aSTNode)) return false;
        return true;
    }

    public final void collectFromLambdaImplicitParameterReceiver(@NotNull PsiElement element, @NotNull InlayTreeSink sink) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (!this.isLambdaImplicitParameterReceiver(element)) {
            return;
        }
        KtFunctionLiteral ktFunctionLiteral = element instanceof KtFunctionLiteral ? (KtFunctionLiteral)element : null;
        if (ktFunctionLiteral == null) {
            return;
        }
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        PsiElement psiElement = functionLiteral.getParent();
        KtLambdaExpression ktLambdaExpression = psiElement instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement : null;
        if (ktLambdaExpression == null) {
            return;
        }
        KtLambdaExpression lambdaExpression = ktLambdaExpression;
        ASTNode aSTNode = lambdaExpression.getLeftCurlyBrace();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getLeftCurlyBrace(...)");
        ASTNode lbrace = aSTNode;
        if (!InlayHintUtilsKt.isFollowedByNewLine(lbrace)) {
            return;
        }
        sink.whenOptionEnabled(InlayInfoOptionKt.getSHOW_IMPLICIT_RECEIVERS_AND_PARAMS().getName(), () -> KtLambdasHintsProvider.collectFromLambdaImplicitParameterReceiver$lambda$12(functionLiteral, sink, lbrace));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit collectFromLambdaReturnExpression$lambda$3$lambda$2(String $lambdaName, KtLambdaExpression $lambdaExpression, PresentationTreeBuilder $this$addPresentation) {
        void it;
        Intrinsics.checkNotNullParameter((Object)$this$addPresentation, (String)"$this$addPresentation");
        PresentationTreeBuilder.text$default((PresentationTreeBuilder)$this$addPresentation, (String)"^", null, (int)2, null);
        SmartPsiElementPointer smartPsiElementPointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)$lambdaExpression));
        String string = $lambdaName;
        PresentationTreeBuilder presentationTreeBuilder = $this$addPresentation;
        boolean bl = false;
        InlayActionData inlayActionData = new InlayActionData((InlayActionPayload)new PsiPointerInlayActionPayload((SmartPsiElementPointer)it), "psi.pointer.navigation.handler");
        presentationTreeBuilder.text(string, inlayActionData);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit collectFromLambdaReturnExpression$lambda$3(KtLambdaExpression $lambdaExpression, InlayTreeSink $sink, KtExpression $expression, String $lambdaName) {
        boolean bl;
        void this_$iv$iv;
        boolean $i$f$analyze = false;
        Project project = ((KtElement)$lambdaExpression).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)$lambdaExpression);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)$lambdaExpression);
        try {
            boolean bl2;
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                boolean bl3 = false;
                KaSession $this$collectFromLambdaReturnExpression_u24lambda_u243_u24lambda_u240 = analysisSession$iv$iv;
                boolean bl4 = false;
                bl2 = $this$collectFromLambdaReturnExpression_u24lambda_u243_u24lambda_u240.isUsedAsExpression($expression);
            }
            bl = bl2;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)$lambdaExpression);
        }
        boolean isUsedAsExpression = bl;
        if (!isUsedAsExpression) {
            return Unit.INSTANCE;
        }
        InlayTreeSink.addPresentation$default((InlayTreeSink)$sink, (InlayPosition)((InlayPosition)new InlineInlayPosition(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)$expression)), true, 0, 4, null)), null, null, (HintFormat)HintFormat.Companion.getDefault(), arg_0 -> KtLambdasHintsProvider.collectFromLambdaReturnExpression$lambda$3$lambda$2($lambdaName, $lambdaExpression, arg_0), (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit collectFromLambdaImplicitParameterReceiver$lambda$12$lambda$11$lambda$6$lambda$5(KaSession $this_analyze, KaReceiverParameterSymbol $receiverSymbol, PresentationTreeBuilder $this$addPresentation) {
        Intrinsics.checkNotNullParameter((Object)$this$addPresentation, (String)"$this$addPresentation");
        PresentationTreeBuilder.text$default((PresentationTreeBuilder)$this$addPresentation, (String)"this: ", null, (int)2, null);
        PrintTypeKt.printKtType($this_analyze, $this$addPresentation, $receiverSymbol.getType());
        return Unit.INSTANCE;
    }

    private static final Unit collectFromLambdaImplicitParameterReceiver$lambda$12$lambda$11$lambda$10$lambda$9(KaSession $this_analyze, KaType $type, PresentationTreeBuilder $this$addPresentation) {
        Intrinsics.checkNotNullParameter((Object)$this$addPresentation, (String)"$this$addPresentation");
        PresentationTreeBuilder.text$default((PresentationTreeBuilder)$this$addPresentation, (String)"it: ", null, (int)2, null);
        PrintTypeKt.printKtType($this_analyze, $this$addPresentation, $type);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit collectFromLambdaImplicitParameterReceiver$lambda$12(KtFunctionLiteral $functionLiteral, InlayTreeSink $sink, ASTNode $lbrace) {
        void this_$iv$iv;
        boolean $i$f$analyze = false;
        Project project = ((KtElement)$functionLiteral).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)$functionLiteral);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)$functionLiteral);
        try {
            Unit unit;
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                boolean bl = false;
                KaSession $this$collectFromLambdaImplicitParameterReceiver_u24lambda_u2412_u24lambda_u2411 = analysisSession$iv$iv;
                boolean bl2 = false;
                KaAnonymousFunctionSymbol anonymousFunctionSymbol = $this$collectFromLambdaImplicitParameterReceiver_u24lambda_u2412_u24lambda_u2411.getSymbol($functionLiteral);
                KaReceiverParameterSymbol kaReceiverParameterSymbol = anonymousFunctionSymbol.getReceiverParameter();
                if (kaReceiverParameterSymbol != null) {
                    KaReceiverParameterSymbol receiverSymbol = kaReceiverParameterSymbol;
                    boolean bl3 = false;
                    InlayTreeSink.addPresentation$default((InlayTreeSink)$sink, (InlayPosition)((InlayPosition)new InlineInlayPosition($lbrace.getTextRange().getEndOffset(), true, 0, 4, null)), null, null, (HintFormat)HintFormat.Companion.getDefault(), arg_0 -> KtLambdasHintsProvider.collectFromLambdaImplicitParameterReceiver$lambda$12$lambda$11$lambda$6$lambda$5($this$collectFromLambdaImplicitParameterReceiver_u24lambda_u2412_u24lambda_u2411, receiverSymbol, arg_0), (int)6, null);
                }
                KaValueParameterSymbol kaValueParameterSymbol = (KaValueParameterSymbol)CollectionsKt.singleOrNull(anonymousFunctionSymbol.getValueParameters());
                if (kaValueParameterSymbol != null) {
                    KaValueParameterSymbol kaValueParameterSymbol2;
                    KaLifetimeOwner kaLifetimeOwner;
                    KaValueParameterSymbol singleParameterSymbol = kaValueParameterSymbol;
                    boolean bl4 = false;
                    KaValueParameterSymbol it = kaLifetimeOwner = singleParameterSymbol;
                    boolean bl5 = false;
                    KaValueParameterSymbol kaValueParameterSymbol3 = kaValueParameterSymbol2 = it.isImplicitLambdaParameter() ? kaLifetimeOwner : null;
                    if (kaValueParameterSymbol2 != null && (kaLifetimeOwner = kaValueParameterSymbol2.getReturnType()) != null) {
                        KaLifetimeOwner kaLifetimeOwner2;
                        KaLifetimeOwner kaLifetimeOwner3;
                        KaLifetimeOwner it2 = kaLifetimeOwner3 = kaLifetimeOwner;
                        boolean bl6 = false;
                        KaLifetimeOwner kaLifetimeOwner4 = kaLifetimeOwner2 = !$this$collectFromLambdaImplicitParameterReceiver_u24lambda_u2412_u24lambda_u2411.isUnitType((KaType)it2) ? kaLifetimeOwner3 : null;
                        if (kaLifetimeOwner2 != null) {
                            KaLifetimeOwner type2 = kaLifetimeOwner2;
                            InlayTreeSink.addPresentation$default((InlayTreeSink)$sink, (InlayPosition)((InlayPosition)new InlineInlayPosition($lbrace.getTextRange().getEndOffset(), true, 0, 4, null)), null, null, (HintFormat)HintFormat.Companion.getDefault(), arg_0 -> KtLambdasHintsProvider.collectFromLambdaImplicitParameterReceiver$lambda$12$lambda$11$lambda$10$lambda$9($this$collectFromLambdaImplicitParameterReceiver_u24lambda_u2412_u24lambda_u2411, (KaType)type2, arg_0), (int)6, null);
                        }
                    }
                }
                unit = Unit.INSTANCE;
            }
            Unit unit2 = unit;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)$functionLiteral);
        }
        return Unit.INSTANCE;
    }
}

