/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.loopToCallChain;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.ChainedCallGenerator;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.CommentSavingRangeHolder;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.CommonUtilsKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.ResultTransformation;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.VariableInitialization;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiChildRange;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/AssignToVariableResultTransformation;", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/ResultTransformation;", "loop", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "initialization", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/VariableInitialization;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtForExpression;Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/VariableInitialization;)V", "getLoop", "()Lorg/jetbrains/kotlin/psi/KtForExpression;", "getInitialization", "()Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/VariableInitialization;", "commentSavingRange", "Lorg/jetbrains/kotlin/psi/psiUtil/PsiChildRange;", "getCommentSavingRange", "()Lorg/jetbrains/kotlin/psi/psiUtil/PsiChildRange;", "generateExpressionToReplaceLoopAndCheckErrors", "Lorg/jetbrains/kotlin/psi/KtExpression;", "resultCallChain", "convertLoop", "commentSavingRangeHolder", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/CommentSavingRangeHolder;", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nbaseTransformations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 baseTransformations.kt\norg/jetbrains/kotlin/idea/intentions/loopToCallChain/AssignToVariableResultTransformation\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n*L\n1#1,136:1\n22#2:137\n*S KotlinDebug\n*F\n+ 1 baseTransformations.kt\norg/jetbrains/kotlin/idea/intentions/loopToCallChain/AssignToVariableResultTransformation\n*L\n61#1:137\n*E\n"})
public abstract class AssignToVariableResultTransformation
implements ResultTransformation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtForExpression loop;
    @NotNull
    private final VariableInitialization initialization;
    @NotNull
    private final PsiChildRange commentSavingRange;

    public AssignToVariableResultTransformation(@NotNull KtForExpression loop, @NotNull VariableInitialization initialization) {
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        Intrinsics.checkNotNullParameter((Object)initialization, (String)"initialization");
        this.loop = loop;
        this.initialization = initialization;
        this.commentSavingRange = new PsiChildRange((PsiElement)this.initialization.getInitializationStatement(), (PsiElement)KotlinPsiUtils.unwrapIfLabeled((KtExpression)this.loop));
    }

    @Override
    @NotNull
    public final KtForExpression getLoop() {
        return this.loop;
    }

    @NotNull
    protected final VariableInitialization getInitialization() {
        return this.initialization;
    }

    @Override
    @NotNull
    public PsiChildRange getCommentSavingRange() {
        return this.commentSavingRange;
    }

    @Override
    @NotNull
    public KtExpression generateExpressionToReplaceLoopAndCheckErrors(@NotNull KtExpression resultCallChain) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)resultCallChain, (String)"resultCallChain");
        Project project = resultCallChain.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        KtExpression initializationStatement = this.initialization.getInitializationStatement();
        if (initializationStatement instanceof KtVariableDeclaration) {
            LexicalScope resolutionScope = ScopeUtils.getResolutionScope((KtElement)this.loop);
            String uniqueName2 = KotlinNameSuggester.Companion.suggestNameByName("test", (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(resolutionScope){
                final /* synthetic */ LexicalScope $resolutionScope;
                {
                    this.$resolutionScope = $resolutionScope;
                    super(1, Intrinsics.Kotlin.class, "isUniqueName", "generateExpressionToReplaceLoopAndCheckErrors$isUniqueName(Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Ljava/lang/String;)Z", 0);
                }

                public final Boolean invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return AssignToVariableResultTransformation.access$generateExpressionToReplaceLoopAndCheckErrors$isUniqueName(this.$resolutionScope, p0);
                }
            }));
            PsiElement $this$copied$iv = (PsiElement)initializationStatement;
            boolean $i$f$copied = false;
            PsiElement psiElement = $this$copied$iv.copy();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtVariableDeclaration");
            }
            KtVariableDeclaration copy = (KtVariableDeclaration)((PsiElement)((KtVariableDeclaration)psiElement));
            KtExpression ktExpression2 = copy.getInitializer();
            Intrinsics.checkNotNull((Object)ktExpression2);
            ktExpression2.replace((PsiElement)resultCallChain);
            copy.setName(uniqueName2);
            ktExpression = (KtExpression)copy;
        } else {
            Object[] objectArray = new Object[]{this.initialization.getVariable().getNameAsSafeName(), resultCallChain};
            ktExpression = CreateByPatternKt.createExpressionByPattern((KtPsiFactory)psiFactory, (String)"$0 = $1", (Object[])objectArray, (boolean)false);
        }
        return ktExpression;
    }

    @Override
    @NotNull
    public KtExpression convertLoop(@NotNull KtExpression resultCallChain, @NotNull CommentSavingRangeHolder commentSavingRangeHolder) {
        Intrinsics.checkNotNullParameter((Object)resultCallChain, (String)"resultCallChain");
        Intrinsics.checkNotNullParameter((Object)commentSavingRangeHolder, (String)"commentSavingRangeHolder");
        this.initialization.getInitializer().replace((PsiElement)resultCallChain);
        Project project = this.loop.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        KtProperty variable = this.initialization.getVariable();
        if (variable.isVar() && CommonUtilsKt.countWriteUsages((KtVariableDeclaration)variable) == CommonUtilsKt.countWriteUsages((KtVariableDeclaration)variable, (KtElement)this.loop)) {
            variable.getValOrVarKeyword().replace(psiFactory.createValKeyword());
        }
        KtExpression loopUnwrapped = KotlinPsiUtils.unwrapIfLabeled((KtExpression)this.loop);
        KtExpression initializationStatement = this.initialization.getInitializationStatement();
        if (!Intrinsics.areEqual((Object)CommonUtilsKt.nextStatement(initializationStatement), (Object)loopUnwrapped)) {
            PsiElement block = loopUnwrapped.getParent();
            boolean bl = block instanceof KtBlockExpression;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            PsiElement psiElement = block.addBefore((PsiElement)initializationStatement, (PsiElement)loopUnwrapped);
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            KtExpression movedInitializationStatement = (KtExpression)psiElement;
            block.addBefore(psiFactory.createNewLine(), (PsiElement)loopUnwrapped);
            commentSavingRangeHolder.remove((PsiElement)initializationStatement);
            initializationStatement.delete();
            initializationStatement = movedInitializationStatement;
        }
        loopUnwrapped.delete();
        return initializationStatement;
    }

    private static final boolean generateExpressionToReplaceLoopAndCheckErrors$isUniqueName(LexicalScope resolutionScope, String name2) {
        Name name3 = Name.identifier((String)name2);
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        Name identifier = name3;
        return ScopeUtilsKt.findVariable$default((HierarchicalScope)((HierarchicalScope)resolutionScope), (Name)identifier, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE), null, (int)4, null) == null && ScopeUtilsKt.findFunction$default((HierarchicalScope)((HierarchicalScope)resolutionScope), (Name)identifier, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE), null, (int)4, null) == null && ScopeUtilsKt.findClassifier((HierarchicalScope)((HierarchicalScope)resolutionScope), (Name)identifier, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE)) == null && ScopeUtilsKt.findPackage((HierarchicalScope)((HierarchicalScope)resolutionScope), (Name)identifier) == null;
    }

    public static final /* synthetic */ boolean access$generateExpressionToReplaceLoopAndCheckErrors$isUniqueName(LexicalScope resolutionScope, String name2) {
        return AssignToVariableResultTransformation.generateExpressionToReplaceLoopAndCheckErrors$isUniqueName(resolutionScope, name2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/AssignToVariableResultTransformation$Companion;", "", "<init>", "()V", "createDelegated", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/AssignToVariableResultTransformation;", "delegate", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/ResultTransformation;", "initialization", "Lorg/jetbrains/kotlin/idea/intentions/loopToCallChain/VariableInitialization;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AssignToVariableResultTransformation createDelegated(@NotNull ResultTransformation delegate, @NotNull VariableInitialization initialization) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            Intrinsics.checkNotNullParameter((Object)initialization, (String)"initialization");
            KtForExpression ktForExpression = delegate.getLoop();
            return new AssignToVariableResultTransformation(initialization, delegate, ktForExpression){
                final /* synthetic */ ResultTransformation $delegate;
                {
                    this.$delegate = $delegate;
                    super($super_call_param$1, $initialization);
                }

                public String getPresentation() {
                    return this.$delegate.getPresentation();
                }

                public KtExpression generateCode(ChainedCallGenerator chainedCallGenerator2) {
                    Intrinsics.checkNotNullParameter((Object)chainedCallGenerator2, (String)"chainedCallGenerator");
                    return this.$delegate.generateCode(chainedCallGenerator2);
                }

                public boolean getLazyMakesSense() {
                    return this.$delegate.getLazyMakesSense();
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

