/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.idea.base.fe10.highlighting.KotlinBaseFe10HighlightingBundle;
import org.jetbrains.kotlin.idea.base.highlighting.KotlinBaseHighlightingBundle;
import org.jetbrains.kotlin.idea.base.highlighting.KotlinHighlighterAttributeUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.DescriptorUtilsKt;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightInfoTypeSemanticNames;
import org.jetbrains.kotlin.idea.highlighter.PropertiesHighlightingVisitorKt;
import org.jetbrains.kotlin.idea.highlighter.visitor.AbstractHighlightingVisitor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ExplicitSmartCasts;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ImplicitSmartCasts;
import org.jetbrains.kotlin.resolve.calls.smartcasts.MultipleSmartCasts;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.CaptureKind;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/VariablesHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/highlighter/AfterAnalysisHighlightingVisitor;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "<init>", "(Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "visitSimpleNameExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitDestructuringDeclarationEntry", "multiDeclarationEntry", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "getSmartCastTarget", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitExpression", "visitVariableDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "highlightVariable", "elementToHighlight", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "kotlin.highlighting.k1"})
@SourceDebugExtension(value={"SMAP\nVariablesHighlightingVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariablesHighlightingVisitor.kt\norg/jetbrains/kotlin/idea/highlighter/VariablesHighlightingVisitor\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,206:1\n119#2:207\n*S KotlinDebug\n*F\n+ 1 VariablesHighlightingVisitor.kt\norg/jetbrains/kotlin/idea/highlighter/VariablesHighlightingVisitor\n*L\n153#1:207\n*E\n"})
public final class VariablesHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    public VariablesHighlightingVisitor(@NotNull HighlightInfoHolder holder, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        super(holder, bindingContext);
    }

    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)expression);
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor target = declarationDescriptor;
        if (target instanceof ValueParameterDescriptor && Intrinsics.areEqual((Object)this.getBindingContext().get((ReadOnlySlice)BindingContext.AUTO_CREATED_IT, (Object)target), (Object)true)) {
            this.highlightName((PsiElement)expression, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getFUNCTION_LITERAL_DEFAULT_PARAMETER(), KotlinBaseHighlightingBundle.message("automatically.declared.based.on.the.expected.type", new Object[0]));
        } else if (!(expression.getParent() instanceof KtValueArgumentName)) {
            this.highlightVariable((PsiElement)expression, target);
        }
        super.visitSimpleNameExpression(expression);
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        this.visitVariableDeclaration((KtNamedDeclaration)property);
        super.visitProperty(property);
    }

    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, (Object)parameter);
        if (propertyDescriptor == null) {
            this.visitVariableDeclaration((KtNamedDeclaration)parameter);
        }
        super.visitParameter(parameter);
    }

    public void visitDestructuringDeclarationEntry(@NotNull KtDestructuringDeclarationEntry multiDeclarationEntry) {
        Intrinsics.checkNotNullParameter((Object)multiDeclarationEntry, (String)"multiDeclarationEntry");
        this.visitVariableDeclaration((KtNamedDeclaration)multiDeclarationEntry);
        super.visitDestructuringDeclarationEntry(multiDeclarationEntry);
    }

    private final PsiElement getSmartCastTarget(KtExpression expression) {
        PsiElement psiElement;
        PsiElement psiElement2;
        PsiElement target = (PsiElement)expression;
        if (target instanceof KtParenthesizedExpression) {
            KtExpression ktExpression = KtPsiUtil.deparenthesize((KtExpression)((KtExpression)target));
            PsiElement psiElement3 = target = ktExpression != null ? (PsiElement)ktExpression : (PsiElement)expression;
        }
        if ((psiElement2 = target) instanceof KtIfExpression) {
            PsiElement psiElement4 = ((KtIfExpression)target).getIfKeyword();
            psiElement = psiElement4;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"getIfKeyword(...)");
        } else if (psiElement2 instanceof KtWhenExpression) {
            PsiElement psiElement5 = ((KtWhenExpression)target).getWhenKeyword();
            psiElement = psiElement5;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"getWhenKeyword(...)");
        } else if (psiElement2 instanceof KtBinaryExpression) {
            KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)target).getOperationReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"getOperationReference(...)");
            psiElement = (PsiElement)ktOperationReferenceExpression;
        } else {
            psiElement = target;
        }
        return psiElement;
    }

    public void visitExpression(@NotNull KtExpression expression) {
        ExplicitSmartCasts smartCast;
        boolean nullSmartCast;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        ImplicitSmartCasts implicitSmartCast = (ImplicitSmartCasts)this.getBindingContext().get((ReadOnlySlice)BindingContext.IMPLICIT_RECEIVER_SMARTCAST, (Object)expression);
        if (implicitSmartCast != null) {
            for (Map.Entry entry : implicitSmartCast.getReceiverTypes().entrySet()) {
                Object[] receiver2 = (Object[])entry.getKey();
                KotlinType type2 = (KotlinType)entry.getValue();
                Object[] objectArray = receiver2;
                String entry2 = objectArray instanceof ExtensionReceiver ? KotlinBaseHighlightingBundle.message("extension.implicit.receiver", new Object[0]) : (objectArray instanceof ImplicitClassReceiver ? KotlinBaseHighlightingBundle.message("implicit.receiver", new Object[0]) : KotlinBaseFe10HighlightingBundle.message("unknown.receiver", new Object[0]));
                objectArray = new Object[]{entry2, DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(type2)};
                this.highlightName((PsiElement)expression, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getSMART_CAST_RECEIVER(), KotlinBaseHighlightingBundle.message("0.smart.cast.to.1", objectArray));
            }
        }
        if (nullSmartCast = Intrinsics.areEqual((Object)this.getBindingContext().get((ReadOnlySlice)BindingContext.SMARTCAST_NULL, (Object)expression), (Object)true)) {
            this.highlightName((PsiElement)expression, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getSMART_CONSTANT(), KotlinBaseFe10HighlightingBundle.message("always.null", new Object[0]));
        }
        if ((smartCast = (ExplicitSmartCasts)this.getBindingContext().get((ReadOnlySlice)BindingContext.SMARTCAST, (Object)expression)) != null) {
            KotlinType defaultType = smartCast.getDefaultType();
            if (defaultType != null) {
                Object[] objectArray = new Object[]{DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(defaultType)};
                this.highlightName(this.getSmartCastTarget(expression), KotlinHighlightInfoTypeSemanticNames.INSTANCE.getSMART_CAST_VALUE(), KotlinBaseHighlightingBundle.message("smart.cast.to.0", objectArray));
            } else if (smartCast instanceof MultipleSmartCasts) {
                for (Map.Entry entry : ((MultipleSmartCasts)smartCast).getMap().entrySet()) {
                    Call call2 = (Call)entry.getKey();
                    KotlinType type3 = (KotlinType)entry.getValue();
                    PsiElement psiElement = this.getSmartCastTarget(expression);
                    HighlightInfoType highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getSMART_CAST_VALUE();
                    Object[] objectArray = new Object[2];
                    objectArray[0] = DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(type3);
                    Call call3 = call2;
                    Object object = call3 != null ? call3.getCallElement() : null;
                    Object object2 = object instanceof PsiNamedElement ? (PsiNamedElement)object : null;
                    if (object2 == null || (object2 = object2.getName()) == null) {
                        object2 = "null";
                    }
                    objectArray[1] = object2;
                    this.highlightName(psiElement, highlightInfoType, KotlinBaseFe10HighlightingBundle.message("smart.cast.to.0.for.1.call", objectArray));
                }
            }
        }
        super.visitExpression(expression);
    }

    private final void visitVariableDeclaration(KtNamedDeclaration declaration) {
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)declaration);
        PsiElement nameIdentifier = declaration.getNameIdentifier();
        if (nameIdentifier != null && declarationDescriptor != null) {
            this.highlightVariable(nameIdentifier, declarationDescriptor);
        }
    }

    private final void highlightVariable(PsiElement elementToHighlight, DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof VariableDescriptor) {
            if (DynamicCallsKt.isDynamic((DeclarationDescriptor)descriptor2)) {
                AbstractHighlightingVisitor.highlightName$default((AbstractHighlightingVisitor)this, (PsiElement)elementToHighlight, (HighlightInfoType)KotlinHighlightInfoTypeSemanticNames.INSTANCE.getDYNAMIC_PROPERTY_CALL(), null, (int)4, null);
                return;
            }
            if (((VariableDescriptor)descriptor2).isVar()) {
                boolean shouldHighlight;
                if (elementToHighlight instanceof KtNameReferenceExpression) {
                    PropertySetterDescriptor setter;
                    DeclarationDescriptor $this$safeAs$iv = descriptor2;
                    boolean $i$f$safeAs = false;
                    DeclarationDescriptor declarationDescriptor = $this$safeAs$iv;
                    if (!(declarationDescriptor instanceof PropertyDescriptor)) {
                        declarationDescriptor = null;
                    }
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)declarationDescriptor;
                    Object object = setter = propertyDescriptor != null ? propertyDescriptor.getSetter() : null;
                    v3 = setter == null || DescriptorUtilsKt.isVisible((DeclarationDescriptorWithVisibility)setter, elementToHighlight, KtPsiUtilKt.getReceiverExpression((KtSimpleNameExpression)((KtSimpleNameExpression)elementToHighlight)), this.getBindingContext(), ResolutionUtils.getResolutionFacade((KtElement)elementToHighlight));
                } else {
                    v3 = shouldHighlight = true;
                }
                if (shouldHighlight) {
                    PsiElement psiElement = elementToHighlight.getParent();
                    KtProperty ktProperty = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
                    if (!Intrinsics.areEqual((Object)(ktProperty != null ? ktProperty.getNameIdentifier() : null), (Object)elementToHighlight)) {
                        psiElement = elementToHighlight.getParent();
                        KtParameter ktParameter = psiElement instanceof KtParameter ? (KtParameter)psiElement : null;
                        if (!Intrinsics.areEqual((Object)(ktParameter != null ? ktParameter.getNameIdentifier() : null), (Object)elementToHighlight)) {
                            psiElement = elementToHighlight.getParent();
                            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = psiElement instanceof KtDestructuringDeclarationEntry ? (KtDestructuringDeclarationEntry)psiElement : null;
                            if (!Intrinsics.areEqual((Object)(ktDestructuringDeclarationEntry != null ? ktDestructuringDeclarationEntry.getNameIdentifier() : null), (Object)elementToHighlight)) {
                                AbstractHighlightingVisitor.highlightName$default((AbstractHighlightingVisitor)this, (PsiElement)elementToHighlight, (HighlightInfoType)KotlinHighlightInfoTypeSemanticNames.INSTANCE.getMUTABLE_VARIABLE(), null, (int)4, null);
                            }
                        }
                    }
                }
            }
            if (this.getBindingContext().get((ReadOnlySlice)BindingContext.CAPTURED_IN_CLOSURE, (Object)descriptor2) == CaptureKind.NOT_INLINE) {
                String msg = ((VariableDescriptor)descriptor2).isVar() ? KotlinBaseFe10HighlightingBundle.message("wrapped.into.a.reference.object.to.be.modified.when.captured.in.a.closure", new Object[0]) : KotlinBaseFe10HighlightingBundle.message("value.captured.in.a.closure", new Object[0]);
                PsiElement parent = elementToHighlight.getParent();
                if (!(parent instanceof PsiNameIdentifierOwner) || !Intrinsics.areEqual((Object)((PsiNameIdentifierOwner)parent).getNameIdentifier(), (Object)elementToHighlight)) {
                    this.highlightName(elementToHighlight, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getWRAPPED_INTO_REF(), msg);
                    return;
                }
            }
            PsiElement declaration = elementToHighlight.getParent();
            if (!(!(descriptor2 instanceof LocalVariableDescriptor) || descriptor2 instanceof SyntheticFieldDescriptor || declaration instanceof KtProperty && Intrinsics.areEqual((Object)((KtProperty)declaration).getNameIdentifier(), (Object)elementToHighlight) && Intrinsics.areEqual((Object)KotlinHighlighterAttributeUtils.textAttributesForKtPropertyDeclaration((KtProperty)declaration), (Object)KotlinHighlightInfoTypeSemanticNames.INSTANCE.getLOCAL_VARIABLE()) || declaration instanceof KtDestructuringDeclarationEntry && Intrinsics.areEqual((Object)((KtDestructuringDeclarationEntry)declaration).getNameIdentifier(), (Object)elementToHighlight))) {
                AbstractHighlightingVisitor.highlightName$default((AbstractHighlightingVisitor)this, (PsiElement)elementToHighlight, (HighlightInfoType)KotlinHighlightInfoTypeSemanticNames.INSTANCE.getLOCAL_VARIABLE(), null, (int)4, null);
            }
            if (descriptor2 instanceof ValueParameterDescriptor && !(elementToHighlight.getParent() instanceof KtParameter)) {
                AbstractHighlightingVisitor.highlightName$default((AbstractHighlightingVisitor)this, (PsiElement)elementToHighlight, (HighlightInfoType)KotlinHighlightInfoTypeSemanticNames.INSTANCE.getPARAMETER(), null, (int)4, null);
            }
            if (descriptor2 instanceof PropertyDescriptor && PropertiesHighlightingVisitorKt.hasCustomPropertyDeclaration((PropertyDescriptor)descriptor2)) {
                KtProperty ktProperty = declaration instanceof KtProperty ? (KtProperty)declaration : null;
                if (!Intrinsics.areEqual((Object)(ktProperty != null ? ktProperty.getNameIdentifier() : null), (Object)elementToHighlight) && !(elementToHighlight instanceof KtSimpleNameExpression)) {
                    boolean isStaticDeclaration = DescriptorUtils.isStaticDeclaration((CallableDescriptor)((CallableDescriptor)descriptor2));
                    AbstractHighlightingVisitor.highlightName$default((AbstractHighlightingVisitor)this, (PsiElement)elementToHighlight, (HighlightInfoType)(isStaticDeclaration ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getPACKAGE_PROPERTY_CUSTOM_PROPERTY_DECLARATION() : KotlinHighlightInfoTypeSemanticNames.INSTANCE.getINSTANCE_PROPERTY_CUSTOM_PROPERTY_DECLARATION()), null, (int)4, null);
                }
            }
        }
    }
}

