/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.ReceiverInfo;
import org.jetbrains.kotlin.idea.highlighter.ReceiverInfoSearcher$checkIfInReceiverTypeReference$;
import org.jetbrains.kotlin.idea.util.ExtensionUtils;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J*\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010H\u0002J\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0005*\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfoSearcher;", "", "<init>", "()V", "findReceiverInfoForUsageHighlighting", "Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo;", "target", "Lcom/intellij/psi/PsiElement;", "checkIfInReceiverTypeReference", "isReceiverReference", "", "element", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "checkIfInThisReference", "findReceiverByThisCall", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "refExpr", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "findReceiverByThisRef", "toInfo", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "kotlin.highlighting.k1"})
@SourceDebugExtension(value={"SMAP\nKotlinHighlightReceiverUsagesHandlerFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinHighlightReceiverUsagesHandlerFactory.kt\norg/jetbrains/kotlin/idea/highlighter/ReceiverInfoSearcher\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,288:1\n477#2:289\n183#2,2:290\n1#3:292\n*S KotlinDebug\n*F\n+ 1 KotlinHighlightReceiverUsagesHandlerFactory.kt\norg/jetbrains/kotlin/idea/highlighter/ReceiverInfoSearcher\n*L\n52#1:289\n53#1:290,2\n*E\n"})
public final class ReceiverInfoSearcher {
    @NotNull
    public static final ReceiverInfoSearcher INSTANCE = new ReceiverInfoSearcher();

    private ReceiverInfoSearcher() {
    }

    @Nullable
    public final ReceiverInfo findReceiverInfoForUsageHighlighting(@NotNull PsiElement target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ReceiverInfo receiverInfo = this.checkIfInThisReference(target);
        if (receiverInfo == null) {
            receiverInfo = this.checkIfInReceiverTypeReference(target);
        }
        return receiverInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ReceiverInfo checkIfInReceiverTypeReference(PsiElement target) {
        ReceiverInfo receiverInfo;
        Object v1;
        block3: {
            Sequence $this$filterIsInstance$iv = SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.parents((PsiElement)target, (boolean)true), ReceiverInfoSearcher::checkIfInReceiverTypeReference$lambda$0);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)checkIfInReceiverTypeReference$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence $this$firstOrNull$iv = sequence;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtTypeReference e = (KtTypeReference)element$iv;
                boolean bl = false;
                if (!INSTANCE.isReceiverReference(e)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        KtTypeReference ktTypeReference = v1;
        if (ktTypeReference == null) return null;
        KtTypeReference receiverRef = ktTypeReference;
        boolean bl = false;
        PsiElement psiElement = receiverRef.getParent();
        if (!(psiElement instanceof KtCallableDeclaration)) return null;
        KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)psiElement;
        KtCallableDeclaration ktCallableDeclaration2 = ktCallableDeclaration;
        if (ktCallableDeclaration2 == null) return null;
        KtCallableDeclaration callable = ktCallableDeclaration2;
        boolean bl2 = false;
        psiElement = callable;
        if (psiElement instanceof KtNamedFunction) {
            ReceiverInfo.Function function;
            ReceiverInfo.Function it = function = new ReceiverInfo.Function((KtFunction)callable);
            boolean bl3 = false;
            receiverInfo = ((KtNamedFunction)callable).hasBody() ? function : null;
            return receiverInfo;
        } else {
            ReceiverInfo.Property property;
            if (!(psiElement instanceof KtProperty)) return null;
            ReceiverInfo.Property it = property = new ReceiverInfo.Property((KtProperty)callable);
            boolean bl4 = false;
            List list2 = ((KtProperty)callable).getAccessors();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAccessors(...)");
            receiverInfo = !((Collection)list2).isEmpty() ? property : null;
        }
        return receiverInfo;
    }

    private final boolean isReceiverReference(KtTypeReference element) {
        KtCallableDeclaration ktCallableDeclaration;
        PsiElement psiElement = element.getParent();
        KtNamedFunction ktNamedFunction = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
        if (ktNamedFunction != null) {
            ktCallableDeclaration = (KtCallableDeclaration)ktNamedFunction;
        } else {
            PsiElement psiElement2 = element.getParent();
            KtProperty ktProperty = psiElement2 instanceof KtProperty ? (KtProperty)psiElement2 : null;
            if (ktProperty != null) {
                ktCallableDeclaration = (KtCallableDeclaration)ktProperty;
            } else {
                return false;
            }
        }
        KtCallableDeclaration callable = ktCallableDeclaration;
        return Intrinsics.areEqual((Object)callable.getReceiverTypeReference(), (Object)element);
    }

    private final ReceiverInfo checkIfInThisReference(PsiElement target) {
        if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)target), (Object)KtTokens.THIS_KEYWORD)) {
            return null;
        }
        PsiElement psiElement = target.getParent();
        KtReferenceExpression ktReferenceExpression = psiElement instanceof KtReferenceExpression ? (KtReferenceExpression)psiElement : null;
        if (ktReferenceExpression == null) {
            return null;
        }
        KtReferenceExpression refExpr = ktReferenceExpression;
        BindingContext bindingContext = ResolutionUtils.analyze((KtElement)refExpr, BodyResolveMode.PARTIAL);
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)refExpr), (BindingContext)bindingContext);
        if (resolvedCall == null) {
            return null;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        ReceiverInfo receiverInfo = this.findReceiverByThisRef((ResolvedCall<? extends CallableDescriptor>)resolvedCall2);
        if (receiverInfo != null) {
            ReceiverInfo receiverTypeReference = receiverInfo;
            boolean bl = false;
            return receiverTypeReference;
        }
        receiverInfo = this.findReceiverByThisCall((ResolvedCall<? extends CallableDescriptor>)resolvedCall2, refExpr, bindingContext);
        if (receiverInfo != null) {
            ReceiverInfo receiverTypeReference = receiverInfo;
            boolean bl = false;
            return receiverTypeReference;
        }
        return null;
    }

    private final ReceiverInfo findReceiverByThisCall(ResolvedCall<? extends CallableDescriptor> resolvedCall, KtReferenceExpression refExpr, BindingContext bindingContext) {
        ReceiverValue receiverValue;
        PsiElement psiElement = refExpr.getParent();
        KtThisExpression ktThisExpression = psiElement instanceof KtThisExpression ? (KtThisExpression)psiElement : null;
        if (!((ktThisExpression != null ? ktThisExpression.getParent() : null) instanceof KtCallExpression)) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> call2 = ResolutionUtils.variableCallOrThis(resolvedCall);
        ReceiverValue extensionReceiver = call2.getExtensionReceiver();
        ReceiverValue dispatchReceiver = call2.getDispatchReceiver();
        if (extensionReceiver == null && dispatchReceiver == null) {
            return null;
        }
        ReceiverValue receiverValue2 = extensionReceiver;
        if (receiverValue2 == null) {
            receiverValue2 = dispatchReceiver;
        }
        if ((receiverValue = receiverValue2) instanceof ImplicitReceiver) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = ExtensionUtils.getReceiverTargetDescriptor(receiverValue, bindingContext);
        if (declarationDescriptor == null) {
            return null;
        }
        DeclarationDescriptor functionDescriptor = declarationDescriptor;
        return this.toInfo(functionDescriptor);
    }

    private final ReceiverInfo findReceiverByThisRef(ResolvedCall<? extends CallableDescriptor> resolvedCall) {
        CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
        ReceiverParameterDescriptor receiverParameterDescriptor = callableDescriptor instanceof ReceiverParameterDescriptor ? (ReceiverParameterDescriptor)callableDescriptor : null;
        if (receiverParameterDescriptor == null) {
            return null;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
        DeclarationDescriptor declarationDescriptor = receiverParameterDescriptor2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        DeclarationDescriptor descriptor2 = declarationDescriptor;
        return this.toInfo(descriptor2);
    }

    private final ReceiverInfo toInfo(DeclarationDescriptor $this$toInfo) {
        PsiElement psi = SourceLocationUtilsKt.findPsi((DeclarationDescriptor)$this$toInfo);
        return psi instanceof KtFunctionLiteral ? (ReceiverInfo)new ReceiverInfo.Lambda((KtFunctionLiteral)psi) : (psi instanceof KtNamedFunction ? (ReceiverInfo)new ReceiverInfo.Function((KtFunction)psi) : (psi instanceof KtProperty ? (ReceiverInfo)new ReceiverInfo.Property((KtProperty)psi) : null));
    }

    private static final boolean checkIfInReceiverTypeReference$lambda$0(PsiElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return !(e instanceof KtFunction);
    }
}

