/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.scripting;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.settings.KotlinScriptingSettings;
import org.jetbrains.kotlin.idea.gradle.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.gradleJava.scripting.importing.KotlinDslScriptModelResolver;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRoot;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsLocator;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsManager;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleScriptInfo;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.project.GradlePartialResolverPolicy;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u001a\b\u0010\u000b\u001a\u00020\fH\u0007\u001a\b\u0010\r\u001a\u00020\fH\u0007\u001a\b\u0010\u000e\u001a\u00020\fH\u0007\u001a\b\u0010\u000f\u001a\u00020\fH\u0007\u001a\u0016\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0016\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0018"}, d2={"scriptConfigurationsNeedToBeUpdatedBalloon", "", "getScriptConfigurationsNeedToBeUpdatedBalloon", "()Z", "runPartialGradleImportForAllRoots", "", "project", "Lcom/intellij/openapi/project/Project;", "runPartialGradleImport", "root", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRoot;", "configurationsAreMissingRequestNeeded", "", "getConfigurationsActionText", "configurationsAreMissingRequestNeededHelp", "configurationsAreMissingAfterRequest", "autoReloadScriptConfigurations", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "scriptConfigurationsNeedToBeUpdated", "scriptConfigurationsAreUpToDate", "getGradleVersion", "settings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\nGradleImportHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleImportHelper.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/GradleImportHelperKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,140:1\n1863#2,2:141\n40#3,3:143\n*S KotlinDebug\n*F\n+ 1 GradleImportHelper.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/GradleImportHelperKt\n*L\n39#1:141,2\n137#1:143,3\n*E\n"})
public final class GradleImportHelperKt {
    public static final boolean getScriptConfigurationsNeedToBeUpdatedBalloon() {
        return Registry.Companion.is("kotlin.gradle.scripts.scriptConfigurationsNeedToBeUpdatedFloatingNotification", true);
    }

    public static final void runPartialGradleImportForAllRoots(@NotNull Project project) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = GradleBuildRootsManager.Companion.getInstance(project);
            if (object == null || (object = ((GradleBuildRootsLocator)object).getAllRoots()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GradleBuildRoot root = (GradleBuildRoot)element$iv;
                boolean bl = false;
                GradleImportHelperKt.runPartialGradleImport(project, root);
            }
        }
    }

    public static final void runPartialGradleImport(@NotNull Project project, @NotNull GradleBuildRoot root) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (root.isImportingInProgress()) {
            return;
        }
        ExternalSystemUtil.refreshProject((String)root.getPathPrefix(), (ImportSpecBuilder)new ImportSpecBuilder(project, GradleConstants.SYSTEM_ID).withVmOptions("-Dorg.gradle.kotlin.dsl.provider.mode=classpath").projectResolverPolicy((ProjectResolverPolicy)new GradlePartialResolverPolicy(GradleImportHelperKt::runPartialGradleImport$lambda$1)));
    }

    @Nls
    @NotNull
    public static final String configurationsAreMissingRequestNeeded() {
        return KotlinIdeaGradleBundle.message("notification.wasNotImportedAfterCreation.text", new Object[0]);
    }

    @Nls
    @NotNull
    public static final String getConfigurationsActionText() {
        return KotlinIdeaGradleBundle.message("action.LoadKtGradleConfiguration.text", new Object[0]);
    }

    @Nls
    @NotNull
    public static final String configurationsAreMissingRequestNeededHelp() {
        return KotlinIdeaGradleBundle.message("notification.wasNotImportedAfterCreation.help", new Object[0]);
    }

    @Nls
    @NotNull
    public static final String configurationsAreMissingAfterRequest() {
        return KotlinIdeaGradleBundle.message("notification.notEvaluatedInLastImport.text", new Object[0]);
    }

    public static final boolean autoReloadScriptConfigurations(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ScriptDefinition scriptDefinition = DefinitionsKt.findScriptDefinition(file, project);
        if (scriptDefinition == null) {
            return false;
        }
        ScriptDefinition definition = scriptDefinition;
        return KotlinScriptingSettings.Companion.getInstance(project).autoReloadConfigurations(definition);
    }

    public static final void scriptConfigurationsNeedToBeUpdated(@NotNull Project project, @NotNull VirtualFile file) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (!GradleImportHelperKt.autoReloadScriptConfigurations(project, file)) break block1;
            Object object = GradleBuildRootsManager.Companion.getInstance(project);
            if (object != null && (object = ((GradleBuildRootsLocator)object).getScriptInfo(file)) != null && (object = ((GradleScriptInfo)object).getBuildRoot()) != null) {
                Object it = object;
                boolean bl = false;
                GradleImportHelperKt.runPartialGradleImport(project, (GradleBuildRoot)it);
            }
        }
    }

    public static final boolean scriptConfigurationsAreUpToDate(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return true;
    }

    @NotNull
    public static final String getGradleVersion(@NotNull Project project, @NotNull GradleProjectSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        boolean $i$f$service = false;
        Class<GradleInstallationManager> serviceClass$iv = GradleInstallationManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        File file = ((GradleInstallationManager)object).getGradleHome(project, settings2.getExternalProjectPath());
        String gradleHome = file != null ? file.getPath() : null;
        String string = GradleInstallationManager.getGradleVersion((String)gradleHome);
        if (string == null) {
            String string2 = GradleVersion.current().getVersion();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getVersion(...)");
        }
        return string;
    }

    private static final boolean runPartialGradleImport$lambda$1(GradleProjectResolverExtension it) {
        return it instanceof KotlinDslScriptModelResolver;
    }
}

