/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.impl.k2;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiModificationUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/completion/impl/k2/WrapSingleStringTemplateEntryWithBracesInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "<init>", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "insertBraces", "document", "Lcom/intellij/openapi/editor/Document;", "removeUnneededBraces", "needInsertBraces", "", "getContainingTemplateEntry", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntryWithExpression;", "kotlin.completion.impl.k2"})
final class WrapSingleStringTemplateEntryWithBracesInsertHandler
implements InsertHandler<LookupElement> {
    @NotNull
    public static final WrapSingleStringTemplateEntryWithBracesInsertHandler INSTANCE = new WrapSingleStringTemplateEntryWithBracesInsertHandler();

    private WrapSingleStringTemplateEntryWithBracesInsertHandler() {
    }

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Document document = context2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        context2.commitDocument();
        if (this.needInsertBraces(context2)) {
            this.insertBraces(context2, document2);
            context2.commitDocument();
            item.handleInsert(context2);
            this.removeUnneededBraces(context2);
            context2.commitDocument();
        } else {
            item.handleInsert(context2);
        }
    }

    private final void insertBraces(InsertionContext context2, Document document) {
        int startOffset = context2.getStartOffset();
        document.insertString(context2.getStartOffset(), (CharSequence)"{");
        context2.getOffsetMap().addOffset(CompletionInitializationContext.START_OFFSET, startOffset + 1);
        int tailOffset = context2.getTailOffset();
        document.insertString(tailOffset, (CharSequence)"}");
        context2.setTailOffset(tailOffset);
    }

    private final void removeUnneededBraces(InsertionContext context2) {
        KtStringTemplateEntryWithExpression ktStringTemplateEntryWithExpression = this.getContainingTemplateEntry(context2);
        KtBlockStringTemplateEntry ktBlockStringTemplateEntry = ktStringTemplateEntryWithExpression instanceof KtBlockStringTemplateEntry ? (KtBlockStringTemplateEntry)ktStringTemplateEntryWithExpression : null;
        if (ktBlockStringTemplateEntry == null) {
            return;
        }
        KtBlockStringTemplateEntry templateEntry = ktBlockStringTemplateEntry;
        KotlinPsiModificationUtils.dropCurlyBracketsIfPossible(templateEntry);
    }

    private final boolean needInsertBraces(InsertionContext context2) {
        return this.getContainingTemplateEntry(context2) instanceof KtSimpleNameStringTemplateEntry;
    }

    private final KtStringTemplateEntryWithExpression getContainingTemplateEntry(InsertionContext context2) {
        PsiFile psiFile = context2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        PsiElement psiElement = file.findElementAt(context2.getStartOffset());
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element), (Object)KtTokens.IDENTIFIER)) {
            return null;
        }
        PsiElement psiElement2 = element.getParent();
        KtNameReferenceExpression ktNameReferenceExpression = psiElement2 instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)psiElement2 : null;
        if (ktNameReferenceExpression == null) {
            return null;
        }
        KtNameReferenceExpression identifier = ktNameReferenceExpression;
        PsiElement psiElement3 = identifier.getParent();
        return psiElement3 instanceof KtStringTemplateEntryWithExpression ? (KtStringTemplateEntryWithExpression)psiElement3 : null;
    }
}

