/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.fir.analysisApiPlatform;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ConcurrentList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.KotlinMessageBusProviderKt;
import org.jetbrains.kotlin.analysis.api.platform.modification.KaElementModificationType;
import org.jetbrains.kotlin.analysis.api.platform.modification.KaSourceModificationService;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModificationTopics;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModuleOutOfBlockModificationListener;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinProjectStructureProvider;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.idea.base.fir.analysisApiPlatform.FirIdeOutOfBlockPsiTreeChangePreprocessorKt;
import org.jetbrains.kotlin.idea.util.ModificationEventUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachementBuilderUtilsKt;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\u00020\u000e*\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/analysisApiPlatform/FirIdeOutOfBlockPsiTreeChangePreprocessor;", "Lcom/intellij/psi/impl/PsiTreeChangePreprocessor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "treeChanged", "", "event", "Lcom/intellij/psi/impl/PsiTreeChangeEventImpl;", "invalidateCachesInInjectedDocuments", "rootElement", "Lcom/intellij/psi/PsiElement;", "containsInjection", "", "injectedDocument", "Lcom/intellij/injected/editor/DocumentWindow;", "invalidateCachesForInjectedKotlinCode", "kotlin.base.fir.analysis-api-platform"})
@SourceDebugExtension(value={"SMAP\nFirIdeOutOfBlockPsiTreeChangePreprocessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirIdeOutOfBlockPsiTreeChangePreprocessor.kt\norg/jetbrains/kotlin/idea/base/fir/analysisApiPlatform/FirIdeOutOfBlockPsiTreeChangePreprocessor\n+ 2 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,119:1\n81#2,7:120\n76#2,2:127\n57#2:129\n78#2:130\n66#3,2:131\n12574#4,2:133\n*S KotlinDebug\n*F\n+ 1 FirIdeOutOfBlockPsiTreeChangePreprocessor.kt\norg/jetbrains/kotlin/idea/base/fir/analysisApiPlatform/FirIdeOutOfBlockPsiTreeChangePreprocessor\n*L\n66#1:120,7\n66#1:127,2\n66#1:129\n66#1:130\n80#1:131,2\n94#1:133,2\n*E\n"})
public final class FirIdeOutOfBlockPsiTreeChangePreprocessor
implements PsiTreeChangePreprocessor {
    @NotNull
    private final Project project;

    public FirIdeOutOfBlockPsiTreeChangePreprocessor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        PsiElement child;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.project.isDefault()) {
            return;
        }
        if (!PsiModificationTrackerImpl.canAffectPsi((PsiTreeChangeEventImpl)event) || event.isGenericChange() || event.getCode() == PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_ADDITION) {
            return;
        }
        if (FirIdeOutOfBlockPsiTreeChangePreprocessorKt.access$isGlobalChange(event)) {
            ModificationEventUtilsKt.publishGlobalSourceOutOfBlockModification(this.project);
            return;
        }
        PsiElement rootElement = event.getParent();
        if (rootElement != null) {
            this.invalidateCachesInInjectedDocuments(rootElement);
        }
        PsiTreeChangeEventImpl.PsiEventType psiEventType = event.getCode();
        switch (psiEventType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[psiEventType.ordinal()]) {
            case 1: {
                PsiElement psiElement = rootElement;
                break;
            }
            case 2: {
                PsiElement psiElement = event.getOldChild();
                break;
            }
            default: {
                PsiElement psiElement = child = event.getChild();
            }
        }
        if (rootElement == null || !rootElement.isPhysical()) {
            return;
        }
        PsiTreeChangeEventImpl.PsiEventType psiEventType2 = event.getCode();
        KaElementModificationType modificationType = switch (psiEventType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[psiEventType2.ordinal()]) {
            case 3 -> KaElementModificationType.ElementAdded.INSTANCE;
            case 1 -> {
                PsiElement v4 = event.getChild();
                if (v4 == null) {
                    void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                    ExceptionAttachmentBuilder var14_12;
                    String message$iv = "A " + PsiTreeChangeEventImpl.PsiEventType.CHILD_REMOVED + " PSI tree change event should have a child element";
                    Throwable cause$iv = null;
                    String attachmentName$iv = "info.txt";
                    boolean $i$f$errorWithAttachment = false;
                    boolean $i$f$buildErrorWithAttachment = false;
                    KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
                    KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = (KotlinExceptionWithAttachments)exception$iv$iv;
                    boolean $i$f$buildAttachment = false;
                    ExceptionAttachmentBuilder var15_13 = var14_12 = new ExceptionAttachmentBuilder();
                    String var16_14 = attachmentName$iv;
                    KotlinExceptionWithAttachments var17_15 = $this$buildAttachment$iv$iv$iv;
                    boolean $i$a$-buildAttachment-ExceptionAttachmentBuilderKt$buildErrorWithAttachment$2$iv$iv = false;
                    void $this$treeChanged_u24lambda_u240 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                    boolean $i$a$-errorWithAttachment$default-FirIdeOutOfBlockPsiTreeChangePreprocessor$treeChanged$modificationType$removedElement$1 = false;
                    $this$treeChanged_u24lambda_u240.withEntry("psiTreeChangeEvent", event.toString());
                    ExceptionAttachementBuilderUtilsKt.withPsiEntry((ExceptionAttachmentBuilder)$this$treeChanged_u24lambda_u240, (String)"rootElement", (PsiElement)rootElement);
                    var17_15.withAttachment(var16_14, (Object)var14_12.buildString());
                    throw (Throwable)exception$iv$iv;
                }
                PsiElement removedElement = v4;
                yield new KaElementModificationType.ElementRemoved(removedElement);
            }
            default -> KaElementModificationType.Unknown.INSTANCE;
        };
        KaSourceModificationService kaSourceModificationService = KaSourceModificationService.Companion.getInstance(this.project);
        PsiElement psiElement = child;
        if (psiElement == null) {
            psiElement = rootElement;
        }
        kaSourceModificationService.handleElementModification(psiElement, modificationType);
    }

    private final void invalidateCachesInInjectedDocuments(PsiElement rootElement) {
        PsiElement $this$parentOfType_u24default$iv = rootElement;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        PsiLanguageInjectionHost psiLanguageInjectionHost = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PsiLanguageInjectionHost.class, (boolean)true);
        if (psiLanguageInjectionHost == null) {
            return;
        }
        PsiLanguageInjectionHost injectionHost = psiLanguageInjectionHost;
        ConcurrentList concurrentList = InjectedLanguageUtilBase.getCachedInjectedDocuments((PsiFile)rootElement.getContainingFile());
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"getCachedInjectedDocuments(...)");
        ConcurrentList injectedDocuments = concurrentList;
        if (injectedDocuments.isEmpty()) {
            return;
        }
        for (DocumentWindow injectedDocument : injectedDocuments) {
            Intrinsics.checkNotNull((Object)injectedDocument);
            if (!this.containsInjection(rootElement, injectedDocument)) continue;
            this.invalidateCachesForInjectedKotlinCode(injectedDocument);
        }
    }

    private final boolean containsInjection(PsiElement $this$containsInjection, DocumentWindow injectedDocument) {
        boolean bl;
        block1: {
            Segment[] segmentArray = injectedDocument.getHostRanges();
            Intrinsics.checkNotNullExpressionValue((Object)segmentArray, (String)"getHostRanges(...)");
            Object[] $this$any$iv = segmentArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Segment it = (Segment)element$iv;
                boolean bl2 = false;
                if (!$this$containsInjection.getTextRange().intersects(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final void invalidateCachesForInjectedKotlinCode(DocumentWindow injectedDocument) {
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.project).getPsiFile((Document)injectedDocument);
        KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile2 == null) {
            return;
        }
        KtFile ktFile3 = ktFile2;
        KaModule module = KotlinProjectStructureProvider.Companion.getModule(this.project, (PsiElement)ktFile3, null);
        ((KotlinModuleOutOfBlockModificationListener)KotlinMessageBusProviderKt.getAnalysisMessageBus(this.project).syncPublisher(KotlinModificationTopics.INSTANCE.getMODULE_OUT_OF_BLOCK_MODIFICATION())).onModification(module);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PsiTreeChangeEventImpl.PsiEventType.values().length];
            try {
                nArray[PsiTreeChangeEventImpl.PsiEventType.CHILD_REMOVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REPLACEMENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsiTreeChangeEventImpl.PsiEventType.CHILD_ADDED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

