/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.compilerPreferences.configuration;

import com.intellij.DynamicBundle;
import com.intellij.compiler.server.BuildManager;
import com.intellij.icons.AllIcons;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import kotlin.KotlinVersion;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.Freezable;
import org.jetbrains.kotlin.cli.common.arguments.FreezableKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.IKotlinFacetSettings;
import org.jetbrains.kotlin.config.JpsPluginSettings;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.KotlinFacetSettingsKt;
import org.jetbrains.kotlin.config.LanguageOrApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettingsKt;
import org.jetbrains.kotlin.config.VersionView;
import org.jetbrains.kotlin.idea.PluginStartupApplicationService;
import org.jetbrains.kotlin.idea.base.compilerPreferences.KotlinBaseCompilerConfigurationUiBundle;
import org.jetbrains.kotlin.idea.base.compilerPreferences.configuration.JpsVersionItem;
import org.jetbrains.kotlin.idea.base.compilerPreferences.facet.DescriptionListCellRenderer;
import org.jetbrains.kotlin.idea.base.util.KotlinPlatformUtils;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.BaseKotlinCompilerSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JsCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JvmCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCommonCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerWorkspaceSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettingsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.PlatformUtilKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.impl.JsIdePlatformUtil;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformUtil;
import org.jetbrains.kotlin.platform.jvm.JdkPlatform;

public class KotlinCompilerConfigurableTab
implements SearchableConfigurable {
    private static final Logger LOG = Logger.getInstance(KotlinCompilerConfigurableTab.class);
    private static final Map<String, @NlsSafe String> moduleKindDescriptions = new LinkedHashMap<String, String>();
    private static final Map<String, @NlsSafe String> sourceMapSourceEmbeddingDescriptions = new LinkedHashMap<String, String>();
    private static final int MAX_WARNING_SIZE = 75;
    @Nullable
    private final KotlinCompilerWorkspaceSettings compilerWorkspaceSettings;
    private final Project project;
    private final boolean isProjectSettings;
    private CommonCompilerArguments commonCompilerArguments;
    private K2JSCompilerArguments k2jsCompilerArguments;
    private K2JVMCompilerArguments k2jvmCompilerArguments;
    private CompilerSettings compilerSettings;
    @Nullable
    private final JpsPluginSettings jpsPluginSettings;
    private JPanel contentPane;
    private ThreeStateCheckBox reportWarningsCheckBox;
    private RawCommandLineEditor additionalArgsOptionsField;
    private JLabel additionalArgsLabel;
    private ThreeStateCheckBox generateSourceMapsCheckBox;
    private JLabel labelForOutputDirectory;
    private TextFieldWithBrowseButton outputDirectory;
    private ThreeStateCheckBox copyRuntimeFilesCheckBox;
    private ThreeStateCheckBox keepAliveCheckBox;
    private JCheckBox enableIncrementalCompilationForJvmCheckBox;
    private JCheckBox enableIncrementalCompilationForJsCheckBox;
    private JComboBox<String> moduleKindComboBox;
    private JTextField scriptTemplatesField;
    private JTextField scriptTemplatesClasspathField;
    private JPanel k2jvmPanel;
    private JPanel k2jsPanel;
    private JComboBox<String> jvmVersionComboBox;
    private JPanel kotlinJpsPluginVersionPanel;
    private JComboBox<JpsVersionItem> kotlinJpsPluginVersionComboBox;
    private ComboBoxModelWithPossiblyDisabledItems jpsPluginComboBoxModel;
    private JpsVersionItem defaultJpsVersionItem;
    private JComboBox<VersionView> languageVersionComboBox;
    private JComboBox<VersionView> apiVersionComboBox;
    private JPanel scriptPanel;
    private JLabel warningLabel;
    private JTextField sourceMapPrefix;
    private JComboBox<String> sourceMapEmbedSources;
    private boolean isEnabled;
    @Nullable
    private Disposable validatorsDisposable;
    private static VersionView latestStableVersion;

    public KotlinCompilerConfigurableTab(Project project, @NotNull CommonCompilerArguments commonCompilerArguments, @NotNull K2JSCompilerArguments k2jsCompilerArguments, @NotNull K2JVMCompilerArguments k2jvmCompilerArguments, @NotNull CompilerSettings compilerSettings, @Nullable KotlinCompilerWorkspaceSettings compilerWorkspaceSettings, boolean isProjectSettings, boolean isMultiEditor) {
        if (commonCompilerArguments == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(0);
        }
        if (k2jsCompilerArguments == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(1);
        }
        if (k2jvmCompilerArguments == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(2);
        }
        if (compilerSettings == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(3);
        }
        this.isEnabled = true;
        this.validatorsDisposable = null;
        this.project = project;
        this.commonCompilerArguments = commonCompilerArguments;
        this.k2jsCompilerArguments = k2jsCompilerArguments;
        this.compilerSettings = compilerSettings;
        this.$$$setupUI$$$();
        this.jpsPluginSettings = Optional.ofNullable(isProjectSettings ? KotlinJpsPluginSettings.getInstance(project) : null).map(BaseKotlinCompilerSettings::getSettings).map(FreezableKt::unfrozen).orElse(null);
        this.compilerWorkspaceSettings = compilerWorkspaceSettings;
        this.k2jvmCompilerArguments = k2jvmCompilerArguments;
        this.isProjectSettings = isProjectSettings;
        this.warningLabel.setIcon(AllIcons.General.WarningDialog);
        this.additionalArgsOptionsField.attachLabel(this.additionalArgsLabel);
        if (this.isJpsCompilerVisible()) {
            this.kotlinJpsPluginVersionComboBox.addActionListener(e -> this.onLanguageLevelChanged(this.getSelectedKotlinJpsPluginVersionView()));
        }
        this.fillVersions();
        if (KotlinPlatformUtils.isCidr()) {
            this.keepAliveCheckBox.setVisible(false);
            this.k2jvmPanel.setVisible(false);
            this.k2jsPanel.setVisible(false);
        } else {
            this.initializeNonCidrSettings(isMultiEditor);
        }
        this.reportWarningsCheckBox.setThirdStateEnabled(isMultiEditor);
        if (isProjectSettings) {
            List modulesOverridingProjectSettings = ArraysKt.mapNotNull((Object[])ModuleManager.getInstance((Project)project).getModules(), module -> {
                KotlinFacet facet = KotlinFacet.Companion.get((Module)module);
                if (facet == null) {
                    return null;
                }
                IKotlinFacetSettings facetSettings = ((KotlinFacetConfiguration)facet.getConfiguration()).getSettings();
                if (facetSettings.getUseProjectSettings()) {
                    return null;
                }
                return module.getName();
            });
            CollectionsKt.sort((List)modulesOverridingProjectSettings);
            if (!modulesOverridingProjectSettings.isEmpty()) {
                this.warningLabel.setVisible(true);
                this.warningLabel.setText(KotlinCompilerConfigurableTab.buildOverridingModulesWarning(modulesOverridingProjectSettings));
            }
        }
    }

    public KotlinCompilerConfigurableTab(Project project) {
        this(project, (CommonCompilerArguments)FreezableKt.unfrozen((Freezable)((CommonCompilerArguments)KotlinCommonCompilerArgumentsHolder.getInstance(project).getSettings())), (K2JSCompilerArguments)FreezableKt.unfrozen((Freezable)((K2JSCompilerArguments)Kotlin2JsCompilerArgumentsHolder.getInstance(project).getSettings())), (K2JVMCompilerArguments)FreezableKt.unfrozen((Freezable)((K2JVMCompilerArguments)Kotlin2JvmCompilerArgumentsHolder.getInstance(project).getSettings())), (CompilerSettings)FreezableKt.unfrozen((Freezable)((CompilerSettings)KotlinCompilerSettings.getInstance(project).getSettings())), KotlinCompilerWorkspaceSettings.getInstance(project), true, false);
    }

    private void initializeNonCidrSettings(boolean isMultiEditor) {
        KotlinCompilerConfigurableTab.setupFileChooser(this.labelForOutputDirectory, this.outputDirectory, KotlinBaseCompilerConfigurationUiBundle.message("configuration.title.choose.output.directory", new Object[0]), false);
        this.fillModuleKindList();
        this.fillSourceMapSourceEmbeddingList();
        this.fillJvmVersionList();
        this.generateSourceMapsCheckBox.setThirdStateEnabled(isMultiEditor);
        this.generateSourceMapsCheckBox.addActionListener(event -> this.sourceMapPrefix.setEnabled(this.generateSourceMapsCheckBox.isSelected()));
        this.copyRuntimeFilesCheckBox.setThirdStateEnabled(isMultiEditor);
        this.keepAliveCheckBox.setThirdStateEnabled(isMultiEditor);
        if (this.compilerWorkspaceSettings == null) {
            this.keepAliveCheckBox.setVisible(false);
            this.k2jvmPanel.setVisible(false);
            this.enableIncrementalCompilationForJsCheckBox.setVisible(false);
        }
        this.updateOutputDirEnabled();
    }

    private static int calculateNameCountToShowInWarning(List<String> allNames) {
        int lengthSoFar = 0;
        int size = allNames.size();
        for (int i2 = 0; i2 < size; ++i2) {
            lengthSoFar = (i2 > 0 ? lengthSoFar + 2 : 0) + allNames.get(i2).length();
            if (lengthSoFar <= 75) continue;
            return i2;
        }
        return size;
    }

    @NotNull
    @NlsSafe
    private static String buildOverridingModulesWarning(List<String> modulesOverridingProjectSettings) {
        int nameCountToShow = KotlinCompilerConfigurableTab.calculateNameCountToShowInWarning(modulesOverridingProjectSettings);
        int allNamesCount = modulesOverridingProjectSettings.size();
        if (nameCountToShow == 0) {
            String string = KotlinBaseCompilerConfigurationUiBundle.message("configuration.warning.text.modules.override.project.settings", String.valueOf(allNamesCount));
            if (string == null) {
                KotlinCompilerConfigurableTab.$$$reportNull$$$0(4);
            }
            return string;
        }
        StringBuilder builder2 = new StringBuilder();
        builder2.append("<html>");
        builder2.append(KotlinBaseCompilerConfigurationUiBundle.message("configuration.warning.text.following.modules.override.project.settings", new Object[0])).append(" ");
        CollectionsKt.joinTo(modulesOverridingProjectSettings.subList(0, nameCountToShow), (Appendable)builder2, (CharSequence)", ", (CharSequence)"", (CharSequence)"", (int)-1, (CharSequence)"", (Function1)new Function1<String, CharSequence>(){

            public CharSequence invoke(String s) {
                return "<strong>" + s + "</strong>";
            }
        });
        if (nameCountToShow < allNamesCount) {
            builder2.append(" ").append(KotlinBaseCompilerConfigurationUiBundle.message("configuration.text.and", new Object[0])).append(" ").append(allNamesCount - nameCountToShow).append(" ").append(KotlinBaseCompilerConfigurationUiBundle.message("configuration.text.other.s", new Object[0]));
        }
        String string = builder2.toString();
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String getModuleKindDescription(@Nullable String moduleKind) {
        if (moduleKind == null) {
            return "";
        }
        String result2 = moduleKindDescriptions.get(moduleKind);
        assert (result2 != null) : "Module kind " + moduleKind + " was not added to combobox, therefore it should not be here";
        String string = result2;
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String getSourceMapSourceEmbeddingDescription(@Nullable String sourceMapSourceEmbeddingId) {
        if (sourceMapSourceEmbeddingId == null) {
            return "";
        }
        String result2 = sourceMapSourceEmbeddingDescriptions.get(sourceMapSourceEmbeddingId);
        assert (result2 != null) : "Source map source embedding mode " + sourceMapSourceEmbeddingId + " was not added to combobox, therefore it should not be here";
        String string = result2;
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    private static String getModuleKindOrDefault(@Nullable String moduleKindId) {
        if (moduleKindId == null) {
            moduleKindId = "plain";
        }
        String string = moduleKindId;
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    private static String getSourceMapSourceEmbeddingOrDefault(@Nullable String sourceMapSourceEmbeddingId) {
        if (sourceMapSourceEmbeddingId == null) {
            sourceMapSourceEmbeddingId = "inlining";
        }
        String string = sourceMapSourceEmbeddingId;
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NlsSafe
    private static String getJvmVersionOrDefault(@Nullable String jvmVersion) {
        return jvmVersion != null ? jvmVersion : JvmTarget.DEFAULT.getDescription();
    }

    private static void setupFileChooser(@NotNull JLabel label2, @NotNull TextFieldWithBrowseButton fileChooser2, @NotNull @NlsContexts.DialogTitle String title, boolean forFiles) {
        if (label2 == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(10);
        }
        if (fileChooser2 == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(11);
        }
        if (title == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(12);
        }
        label2.setLabelFor((Component)fileChooser2);
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(forFiles, !forFiles, false, false, false, false).withTitle(title);
        fileChooser2.addBrowseFolderListener(null, descriptor2, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
    }

    private static boolean isBrowseFieldModified(@NotNull TextFieldWithBrowseButton chooser2, @NotNull String currentValue) {
        if (chooser2 == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(13);
        }
        if (currentValue == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(14);
        }
        return !StringUtil.equals((CharSequence)chooser2.getText(), (CharSequence)currentValue);
    }

    private void updateOutputDirEnabled() {
        if (this.isEnabled && this.copyRuntimeFilesCheckBox != null) {
            this.outputDirectory.setEnabled(this.copyRuntimeFilesCheckBox.isSelected());
            this.labelForOutputDirectory.setEnabled(this.copyRuntimeFilesCheckBox.isSelected());
        }
    }

    private static boolean isLessOrEqual(LanguageOrApiVersion version, LanguageOrApiVersion upperBound) {
        return VersionComparatorUtil.compare((String)version.getVersionString(), (String)upperBound.getVersionString()) <= 0;
    }

    public void onLanguageLevelChanged(@Nullable VersionView languageLevel) {
        if (languageLevel == null) {
            return;
        }
        this.restrictAPIVersions(languageLevel);
    }

    private void restrictAPIVersions(VersionView upperBoundView) {
        VersionView selectedAPIView = this.getSelectedAPIVersionView();
        LanguageOrApiVersion selectedAPIVersion = selectedAPIView.getVersion();
        LanguageOrApiVersion upperBound = upperBoundView.getVersion();
        EnumEntries languageVersions = LanguageVersion.getEntries();
        ArrayList<Object> permittedAPIVersions = new ArrayList<Object>(languageVersions.size());
        VersionView latestStable = KotlinCompilerConfigurableTab.getLatestStableVersion();
        int index2 = 0;
        int latestStableIndex = languageVersions.size();
        for (LanguageVersion version : languageVersions) {
            if (index2 > latestStableIndex) break;
            ApiVersion apiVersion = ApiVersion.createByLanguageVersion((LanguageVersion)version);
            if (!KotlinCompilerConfigurableTab.isLessOrEqual((LanguageOrApiVersion)apiVersion, upperBound) && index2 < latestStableIndex) {
                latestStableIndex = index2;
            }
            if (!apiVersion.isUnsupported()) {
                permittedAPIVersions.add(new VersionView.Specific((LanguageOrApiVersion)version));
            }
            ++index2;
        }
        if (KotlinCompilerConfigurableTab.isLessOrEqual(latestStable.getVersion(), upperBound) && !permittedAPIVersions.contains(latestStable)) {
            permittedAPIVersions.add(latestStable);
        }
        this.apiVersionComboBox.setModel((ComboBoxModel<VersionView>)new MutableCollectionComboBoxModel(permittedAPIVersions));
        if (this.isJpsCompilerVisible()) {
            this.languageVersionComboBox.setModel((ComboBoxModel<VersionView>)new MutableCollectionComboBoxModel(permittedAPIVersions));
        }
        VersionView selectedItem = VersionComparatorUtil.compare((String)selectedAPIVersion.getVersionString(), (String)upperBound.getVersionString()) <= 0 ? selectedAPIView : upperBoundView;
        this.apiVersionComboBox.setSelectedItem(selectedItem);
        if (this.isJpsCompilerVisible()) {
            this.languageVersionComboBox.setSelectedItem(selectedItem);
        }
    }

    private void fillJvmVersionList() {
        for (TargetPlatform jvm : JvmIdePlatformKind.INSTANCE.getPlatforms()) {
            JvmTarget jvmTarget = ((JdkPlatform)PlatformUtilKt.subplatformsOfType((TargetPlatform)jvm, JdkPlatform.class).get(0)).getTargetVersion();
            @NlsSafe Object description = jvmTarget.getDescription();
            if (jvmTarget == JvmTarget.JVM_1_6) {
                description = (String)description + " " + KotlinBaseCompilerConfigurationUiBundle.message("deprecated.jvm.version", new Object[0]);
            }
            this.jvmVersionComboBox.addItem((String)description);
        }
    }

    private void fetchAvailableJpsCompilersAsync(Consumer<? super @NlsSafe @Nullable Collection<IdeKotlinVersion>> onFinish) {
        JarRepositoryManager.getAvailableVersions((Project)this.project, (RepositoryLibraryDescription)RepositoryLibraryDescription.findDescription((String)"org.jetbrains.kotlin", (String)"kotlin-dist-for-jps-meta")).onProcessed(distVersions -> {
            if (distVersions == null) {
                onFinish.accept(null);
                return;
            }
            JarRepositoryManager.getAvailableVersions((Project)this.project, (RepositoryLibraryDescription)RepositoryLibraryDescription.findDescription((String)"org.jetbrains.kotlin", (String)"kotlin-jps-plugin")).onProcessed(jpsClassPathVersions -> {
                if (jpsClassPathVersions == null) {
                    onFinish.accept(null);
                    return;
                }
                KotlinVersion min = KotlinJpsPluginSettings.getJpsMinimumSupportedVersion();
                KotlinVersion max = KotlinJpsPluginSettings.getJpsMaximumSupportedVersion();
                HashSet<IdeKotlinVersion> ideKotlinVersions = new HashSet<IdeKotlinVersion>();
                for (String version : distVersions) {
                    KotlinVersion parsedKotlinVersion;
                    IdeKotlinVersion parsedVersion;
                    if (!jpsClassPathVersions.contains(version) || (parsedVersion = IdeKotlinVersion.opt(version)) == null || (parsedKotlinVersion = parsedVersion.getKotlinVersion()).compareTo(min) < 0 || parsedKotlinVersion.compareTo(max) > 0) continue;
                    ideKotlinVersions.add(parsedVersion);
                }
                onFinish.accept(ideKotlinVersions);
            });
        });
    }

    private boolean isJpsCompilerVisible() {
        return this.isProjectSettings && this.jpsPluginSettings != null;
    }

    private void fillVersions() {
        if (this.isJpsCompilerVisible()) {
            Integer compare;
            this.defaultJpsVersionItem = JpsVersionItem.createFromRawVersion(KotlinJpsPluginSettingsKt.getVersionWithFallback(this.jpsPluginSettings));
            this.kotlinJpsPluginVersionComboBox.addItem(this.defaultJpsVersionItem);
            IdeKotlinVersion bundledVersion = KotlinJpsPluginSettings.getBundledVersion();
            IdeKotlinVersion defaultVersion = this.defaultJpsVersionItem.getVersion();
            Integer n = compare = defaultVersion != null ? Integer.valueOf(defaultVersion.compareTo(bundledVersion)) : null;
            if (compare == null || compare > 0) {
                this.jpsPluginComboBoxModel.add(new JpsVersionItem(bundledVersion));
            } else if (compare < 0) {
                this.jpsPluginComboBoxModel.add(0, new JpsVersionItem(bundledVersion));
            }
            final JpsVersionItem loadingItem = JpsVersionItem.createLabel(KotlinBaseCompilerConfigurationUiBundle.message("loading.available.versions.from.maven", new Object[0]));
            this.kotlinJpsPluginVersionComboBox.addItem(loadingItem);
            PopupMenuListenerAdapter popupListener = new PopupMenuListenerAdapter(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    KotlinCompilerConfigurableTab.this.kotlinJpsPluginVersionComboBox.removePopupMenuListener((PopupMenuListener)((Object)this));
                    KotlinCompilerConfigurableTab.this.fetchAvailableJpsCompilersAsync(availableVersions -> {
                        KotlinCompilerConfigurableTab.this.kotlinJpsPluginVersionComboBox.removeItem(loadingItem);
                        if (availableVersions == null) {
                            KotlinCompilerConfigurableTab.this.kotlinJpsPluginVersionComboBox.addItem(JpsVersionItem.createLabel(KotlinBaseCompilerConfigurationUiBundle.message("failed.fetching.all.available.versions.from.maven", new Object[0])));
                        } else {
                            TreeSet<IdeKotlinVersion> newItems = new TreeSet<IdeKotlinVersion>((Collection<IdeKotlinVersion>)availableVersions);
                            for (JpsVersionItem item : KotlinCompilerConfigurableTab.this.jpsPluginComboBoxModel.getItems()) {
                                IdeKotlinVersion ideKotlinVersion = item.getVersion();
                                if (ideKotlinVersion == null) continue;
                                newItems.add(ideKotlinVersion);
                            }
                            Object selectedItem = KotlinCompilerConfigurableTab.this.jpsPluginComboBoxModel.getSelectedItem();
                            KotlinCompilerConfigurableTab.this.jpsPluginComboBoxModel.update(ContainerUtil.reverse((List)ContainerUtil.map(newItems, it -> new JpsVersionItem((IdeKotlinVersion)it))));
                            KotlinCompilerConfigurableTab.this.kotlinJpsPluginVersionComboBox.setSelectedItem(selectedItem);
                        }
                        if (KotlinCompilerConfigurableTab.this.kotlinJpsPluginVersionComboBox.isPopupVisible()) {
                            KotlinCompilerConfigurableTab.this.kotlinJpsPluginVersionComboBox.hidePopup();
                            KotlinCompilerConfigurableTab.this.kotlinJpsPluginVersionComboBox.showPopup();
                        }
                    });
                }
            };
            this.kotlinJpsPluginVersionComboBox.addPopupMenuListener((PopupMenuListener)popupListener);
        } else {
            this.kotlinJpsPluginVersionPanel.setVisible(false);
        }
        VersionView latestStable = KotlinCompilerConfigurableTab.getLatestStableVersion();
        int index2 = 0;
        EnumEntries languageVersions = LanguageVersion.getEntries();
        int latestStableIndex = languageVersions.size();
        for (LanguageVersion languageVersion : languageVersions) {
            if (index2 > latestStableIndex) break;
            if (!KotlinCompilerConfigurableTab.isLessOrEqual((LanguageOrApiVersion)languageVersion, latestStable.getVersion()) && index2 < latestStableIndex) {
                latestStableIndex = index2;
            }
            if (!LanguageVersionSettingsKt.isStableOrReadyForPreview((LanguageVersion)languageVersion)) continue;
            ApiVersion apiVersion = ApiVersion.createByLanguageVersion((LanguageVersion)languageVersion);
            if (!apiVersion.isUnsupported()) {
                this.apiVersionComboBox.addItem((VersionView)new VersionView.Specific((LanguageOrApiVersion)languageVersion));
            }
            if (!languageVersion.isUnsupported()) {
                this.languageVersionComboBox.addItem((VersionView)new VersionView.Specific((LanguageOrApiVersion)languageVersion));
            }
            ++index2;
        }
        this.languageVersionComboBox.setRenderer(new DescriptionListCellRenderer());
        this.kotlinJpsPluginVersionComboBox.setRenderer(new DescriptionListCellRenderer());
        this.apiVersionComboBox.setRenderer(new DescriptionListCellRenderer());
    }

    private static VersionView getLatestStableVersion() {
        LanguageVersion languageVersion;
        VersionView latestStable = latestStableVersion;
        if (latestStable != null) {
            return latestStable;
        }
        LanguageVersion bundledLanguageVersion = KotlinJpsPluginSettings.getBundledVersion().getLanguageVersion();
        latestStable = VersionView.LatestStable.INSTANCE;
        Iterator iterator2 = LanguageVersion.getEntries().iterator();
        while (iterator2.hasNext() && (languageVersion = (LanguageVersion)iterator2.next()).compareTo((Enum)bundledLanguageVersion) <= 0) {
            latestStable = VersionView.Companion.deserialize(languageVersion.getVersionString(), false);
        }
        latestStableVersion = latestStable;
        return latestStable;
    }

    public void setTargetPlatform(@Nullable IdePlatformKind targetPlatform) {
        this.k2jsPanel.setVisible(JsIdePlatformUtil.isJavaScript((IdePlatformKind)targetPlatform));
        this.scriptPanel.setVisible(JvmIdePlatformUtil.isJvm((IdePlatformKind)targetPlatform));
    }

    private void fillModuleKindList() {
        for (String moduleKind : moduleKindDescriptions.keySet()) {
            this.moduleKindComboBox.addItem(moduleKind);
        }
        this.moduleKindComboBox.setRenderer((ListCellRenderer<String>)SimpleListCellRenderer.create((String)"", o -> KotlinCompilerConfigurableTab.getModuleKindDescription(o)));
    }

    private void fillSourceMapSourceEmbeddingList() {
        for (String moduleKind : sourceMapSourceEmbeddingDescriptions.keySet()) {
            this.sourceMapEmbedSources.addItem(moduleKind);
        }
        this.sourceMapEmbedSources.setRenderer((ListCellRenderer<String>)SimpleListCellRenderer.create((String)"", o -> KotlinCompilerConfigurableTab.getSourceMapSourceEmbeddingDescription(o)));
    }

    @NotNull
    public String getId() {
        return "project.kotlinCompiler";
    }

    @Nullable
    public JComponent createComponent() {
        if (this.validatorsDisposable != null) {
            LOG.error((Throwable)new IllegalStateException("validatorsDisposable is not null. Disposing and rewriting it."));
            Disposer.dispose((Disposable)this.validatorsDisposable);
        }
        this.validatorsDisposable = Disposer.newDisposable();
        KotlinCompilerConfigurableTab.createVersionValidator(this.languageVersionComboBox, "configuration.warning.text.language.version.unsupported", this.validatorsDisposable);
        KotlinCompilerConfigurableTab.createVersionValidator(this.apiVersionComboBox, "configuration.warning.text.api.version.unsupported", this.validatorsDisposable);
        return this.contentPane;
    }

    public boolean isModified() {
        return Configurable.isCheckboxModified((JCheckBox)this.reportWarningsCheckBox, (!this.commonCompilerArguments.getSuppressWarnings() ? 1 : 0) != 0) || !this.getSelectedLanguageVersionView().equals(KotlinFacetSettingsKt.getLanguageVersionView((CommonCompilerArguments)this.commonCompilerArguments)) || !this.getSelectedAPIVersionView().equals(KotlinFacetSettingsKt.getApiVersionView((CommonCompilerArguments)this.commonCompilerArguments)) || this.jpsPluginSettings != null && !this.getSelectedKotlinJpsPluginVersion().equals(KotlinJpsPluginSettingsKt.getVersionWithFallback(this.jpsPluginSettings)) || !this.additionalArgsOptionsField.getText().equals(this.compilerSettings.getAdditionalArguments()) || Configurable.isFieldModified((JTextField)this.scriptTemplatesField, (String)this.compilerSettings.getScriptTemplates()) || Configurable.isFieldModified((JTextField)this.scriptTemplatesClasspathField, (String)this.compilerSettings.getScriptTemplatesClasspath()) || Configurable.isCheckboxModified((JCheckBox)this.copyRuntimeFilesCheckBox, (boolean)this.compilerSettings.getCopyJsLibraryFiles()) || KotlinCompilerConfigurableTab.isBrowseFieldModified(this.outputDirectory, this.compilerSettings.getOutputDirectoryForJsLibraryFiles()) || this.compilerWorkspaceSettings != null && (Configurable.isCheckboxModified((JCheckBox)this.enableIncrementalCompilationForJvmCheckBox, (boolean)this.compilerWorkspaceSettings.getPreciseIncrementalEnabled()) || Configurable.isCheckboxModified((JCheckBox)this.enableIncrementalCompilationForJsCheckBox, (boolean)this.compilerWorkspaceSettings.getIncrementalCompilationForJsEnabled()) || Configurable.isCheckboxModified((JCheckBox)this.keepAliveCheckBox, (boolean)this.compilerWorkspaceSettings.getEnableDaemon())) || Configurable.isCheckboxModified((JCheckBox)this.generateSourceMapsCheckBox, (boolean)this.k2jsCompilerArguments.getSourceMap()) || !this.getSelectedModuleKind().equals(KotlinCompilerConfigurableTab.getModuleKindOrDefault(this.k2jsCompilerArguments.getModuleKind())) || Configurable.isFieldModified((JTextField)this.sourceMapPrefix, (String)StringUtil.notNullize((String)this.k2jsCompilerArguments.getSourceMapPrefix())) || !this.getSelectedSourceMapSourceEmbedding().equals(KotlinCompilerConfigurableTab.getSourceMapSourceEmbeddingOrDefault(this.k2jsCompilerArguments.getSourceMapEmbedSources())) || !this.getSelectedJvmVersion().equals(KotlinCompilerConfigurableTab.getJvmVersionOrDefault(this.k2jvmCompilerArguments.getJvmTarget()));
    }

    @NotNull
    private String getSelectedModuleKind() {
        return KotlinCompilerConfigurableTab.getModuleKindOrDefault((String)this.moduleKindComboBox.getSelectedItem());
    }

    private String getSelectedSourceMapSourceEmbedding() {
        return KotlinCompilerConfigurableTab.getSourceMapSourceEmbeddingOrDefault((String)this.sourceMapEmbedSources.getSelectedItem());
    }

    @NotNull
    public String getSelectedJvmVersion() {
        String string = KotlinCompilerConfigurableTab.getJvmVersionOrDefault((String)this.jvmVersionComboBox.getSelectedItem());
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public VersionView getSelectedLanguageVersionView() {
        Object item = this.languageVersionComboBox.getSelectedItem();
        VersionView versionView = item != null ? (VersionView)item : KotlinCompilerConfigurableTab.getLatestStableVersion();
        if (versionView == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(16);
        }
        return versionView;
    }

    @NotNull
    private VersionView getSelectedAPIVersionView() {
        Object item = this.apiVersionComboBox.getSelectedItem();
        VersionView versionView = item != null ? (VersionView)item : KotlinCompilerConfigurableTab.getLatestStableVersion();
        if (versionView == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(17);
        }
        return versionView;
    }

    public VersionView getSelectedKotlinJpsPluginVersionView() {
        JpsVersionItem selectedItem = (JpsVersionItem)this.kotlinJpsPluginVersionComboBox.getSelectedItem();
        IdeKotlinVersion version = selectedItem != null ? selectedItem.getVersion() : null;
        LanguageVersion languageVersion = version != null ? LanguageVersion.fromFullVersionString((String)version.toString()) : null;
        return languageVersion != null ? new VersionView.Specific((LanguageOrApiVersion)languageVersion) : KotlinCompilerConfigurableTab.getLatestStableVersion();
    }

    @NotNull
    private String getSelectedKotlinJpsPluginVersion() {
        JpsVersionItem item = (JpsVersionItem)this.kotlinJpsPluginVersionComboBox.getSelectedItem();
        return KotlinCompilerConfigurableTab.normalizeKotlinJpsPluginVersion(item != null ? item.getRawVersion() : null);
    }

    @NlsSafe
    @NotNull
    private static String normalizeKotlinJpsPluginVersion(@Nullable String version) {
        if (version != null && !version.isEmpty()) {
            String string = version;
            if (string == null) {
                KotlinCompilerConfigurableTab.$$$reportNull$$$0(18);
            }
            return string;
        }
        String string = KotlinJpsPluginSettings.getRawBundledVersion();
        if (string == null) {
            KotlinCompilerConfigurableTab.$$$reportNull$$$0(19);
        }
        return string;
    }

    public void applyTo(CommonCompilerArguments commonCompilerArguments, K2JVMCompilerArguments k2jvmCompilerArguments, K2JSCompilerArguments k2jsCompilerArguments, CompilerSettings compilerSettings) throws ConfigurationException {
        if (this.isProjectSettings) {
            boolean shouldInvalidateCaches;
            boolean bl = shouldInvalidateCaches = !this.getSelectedLanguageVersionView().equals(KotlinFacetSettingsKt.getLanguageVersionView((CommonCompilerArguments)commonCompilerArguments)) || !this.getSelectedAPIVersionView().equals(KotlinFacetSettingsKt.getApiVersionView((CommonCompilerArguments)commonCompilerArguments)) || this.jpsPluginSettings != null && !this.getSelectedKotlinJpsPluginVersion().equals(KotlinJpsPluginSettingsKt.getVersionWithFallback(this.jpsPluginSettings)) || !this.additionalArgsOptionsField.getText().equals(compilerSettings.getAdditionalArguments());
            if (!this.project.isDefault() && shouldInvalidateCaches) {
                ApplicationUtilsKt.runWriteAction(new Function0<Object>(){

                    public Object invoke() {
                        ProjectStructureUtils.invalidateProjectRoots(KotlinCompilerConfigurableTab.this.project, RootsChangeRescanningInfo.NO_RESCAN_NEEDED);
                        return null;
                    }
                });
            }
        }
        commonCompilerArguments.setSuppressWarnings(!this.reportWarningsCheckBox.isSelected());
        KotlinFacetSettingsKt.setLanguageVersionView((CommonCompilerArguments)commonCompilerArguments, (VersionView)this.getSelectedLanguageVersionView());
        KotlinFacetSettingsKt.setApiVersionView((CommonCompilerArguments)commonCompilerArguments, (VersionView)this.getSelectedAPIVersionView());
        compilerSettings.setAdditionalArguments(this.additionalArgsOptionsField.getText());
        compilerSettings.setScriptTemplates(this.scriptTemplatesField.getText());
        compilerSettings.setScriptTemplatesClasspath(this.scriptTemplatesClasspathField.getText());
        compilerSettings.setCopyJsLibraryFiles(this.copyRuntimeFilesCheckBox.isSelected());
        compilerSettings.setOutputDirectoryForJsLibraryFiles(this.outputDirectory.getText());
        if (this.compilerWorkspaceSettings != null) {
            this.compilerWorkspaceSettings.setPreciseIncrementalEnabled(this.enableIncrementalCompilationForJvmCheckBox.isSelected());
            this.compilerWorkspaceSettings.setIncrementalCompilationForJsEnabled(this.enableIncrementalCompilationForJsCheckBox.isSelected());
            this.compilerWorkspaceSettings.setDaemonVmOptions(this.extractDaemonVmOptions());
            boolean oldEnableDaemon = this.compilerWorkspaceSettings.getEnableDaemon();
            this.compilerWorkspaceSettings.setEnableDaemon(this.keepAliveCheckBox.isSelected());
            if (this.keepAliveCheckBox.isSelected() != oldEnableDaemon) {
                PluginStartupApplicationService.getInstance().resetAliveFlag();
            }
        }
        k2jsCompilerArguments.setSourceMap(this.generateSourceMapsCheckBox.isSelected());
        k2jsCompilerArguments.setModuleKind(this.getSelectedModuleKind());
        k2jsCompilerArguments.setSourceMapPrefix(this.sourceMapPrefix.getText());
        k2jsCompilerArguments.setSourceMapEmbedSources(this.generateSourceMapsCheckBox.isSelected() ? this.getSelectedSourceMapSourceEmbedding() : null);
        k2jvmCompilerArguments.setJvmTarget(this.getSelectedJvmVersion());
        if (this.isProjectSettings) {
            if (this.jpsPluginSettings != null) {
                String jpsPluginVersion = this.getSelectedKotlinJpsPluginVersion();
                if (!this.jpsPluginSettings.getVersion().isEmpty() || !jpsPluginVersion.equals(KotlinJpsPluginSettingsKt.getVersionWithFallback(this.jpsPluginSettings))) {
                    this.defaultJpsVersionItem = (JpsVersionItem)this.kotlinJpsPluginVersionComboBox.getSelectedItem();
                    this.jpsPluginSettings.setVersion(jpsPluginVersion);
                    KotlinJpsPluginSettings.getInstance(this.project).setSettings(this.jpsPluginSettings);
                }
            }
            KotlinCommonCompilerArgumentsHolder.getInstance(this.project).setSettings(commonCompilerArguments);
            Kotlin2JvmCompilerArgumentsHolder.getInstance(this.project).setSettings(k2jvmCompilerArguments);
            Kotlin2JsCompilerArgumentsHolder.getInstance(this.project).setSettings(k2jsCompilerArguments);
            KotlinCompilerSettings.getInstance(this.project).setSettings(compilerSettings);
        }
        if (!this.project.isDefault()) {
            BuildManager.getInstance().clearState(this.project);
        }
    }

    public void apply() throws ConfigurationException {
        this.applyTo(this.commonCompilerArguments, this.k2jvmCompilerArguments, this.k2jsCompilerArguments, this.compilerSettings);
    }

    public void reset() {
        this.reportWarningsCheckBox.setSelected(!this.commonCompilerArguments.getSuppressWarnings());
        if (this.jpsPluginSettings != null) {
            KotlinCompilerConfigurableTab.setSelectedItem(this.kotlinJpsPluginVersionComboBox, this.defaultJpsVersionItem);
        }
        this.onLanguageLevelChanged(this.getSelectedKotlinJpsPluginVersionView());
        if (!this.commonCompilerArguments.getAutoAdvanceLanguageVersion()) {
            KotlinCompilerConfigurableTab.setSelectedItem(this.languageVersionComboBox, KotlinFacetSettingsKt.getLanguageVersionView((CommonCompilerArguments)this.commonCompilerArguments));
        } else {
            KotlinCompilerConfigurableTab.setSelectedItem(this.languageVersionComboBox, KotlinCompilerConfigurableTab.getLatestStableVersion());
        }
        if (!this.commonCompilerArguments.getAutoAdvanceApiVersion()) {
            KotlinCompilerConfigurableTab.setSelectedItem(this.apiVersionComboBox, KotlinFacetSettingsKt.getApiVersionView((CommonCompilerArguments)this.commonCompilerArguments));
        } else {
            KotlinCompilerConfigurableTab.setSelectedItem(this.apiVersionComboBox, KotlinCompilerConfigurableTab.getLatestStableVersion());
        }
        this.additionalArgsOptionsField.setText(this.compilerSettings.getAdditionalArguments());
        this.scriptTemplatesField.setText(this.compilerSettings.getScriptTemplates());
        this.scriptTemplatesClasspathField.setText(this.compilerSettings.getScriptTemplatesClasspath());
        this.copyRuntimeFilesCheckBox.setSelected(this.compilerSettings.getCopyJsLibraryFiles());
        this.outputDirectory.setText(this.compilerSettings.getOutputDirectoryForJsLibraryFiles());
        if (this.compilerWorkspaceSettings != null) {
            this.enableIncrementalCompilationForJvmCheckBox.setSelected(this.compilerWorkspaceSettings.getPreciseIncrementalEnabled());
            this.enableIncrementalCompilationForJsCheckBox.setSelected(this.compilerWorkspaceSettings.getIncrementalCompilationForJsEnabled());
            this.keepAliveCheckBox.setSelected(this.compilerWorkspaceSettings.getEnableDaemon());
        }
        this.generateSourceMapsCheckBox.setSelected(this.k2jsCompilerArguments.getSourceMap());
        this.moduleKindComboBox.setSelectedItem(KotlinCompilerConfigurableTab.getModuleKindOrDefault(this.k2jsCompilerArguments.getModuleKind()));
        this.sourceMapPrefix.setText(this.k2jsCompilerArguments.getSourceMapPrefix());
        this.sourceMapPrefix.setEnabled(this.k2jsCompilerArguments.getSourceMap());
        this.sourceMapEmbedSources.setSelectedItem(KotlinCompilerConfigurableTab.getSourceMapSourceEmbeddingOrDefault(this.k2jsCompilerArguments.getSourceMapEmbedSources()));
        this.jvmVersionComboBox.setSelectedItem(KotlinCompilerConfigurableTab.getJvmVersionOrDefault(this.k2jvmCompilerArguments.getJvmTarget()));
    }

    private static <T> void setSelectedItem(JComboBox<T> comboBox, T versionView) {
        int index2 = ((MutableCollectionComboBoxModel)comboBox.getModel()).getElementIndex(versionView);
        if (index2 == -1) {
            comboBox.addItem(versionView);
        }
        comboBox.setSelectedItem(versionView);
    }

    public void disposeUIResources() {
        if (this.validatorsDisposable == null) {
            LOG.error((Throwable)new IllegalStateException("validatorsDisposable is null"));
            return;
        }
        Disposer.dispose((Disposable)this.validatorsDisposable);
        this.validatorsDisposable = null;
    }

    @Nls
    public String getDisplayName() {
        return KotlinBaseCompilerConfigurationUiBundle.message("configuration.name.kotlin.compiler", new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.compiler.kotlin";
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    public ThreeStateCheckBox getReportWarningsCheckBox() {
        return this.reportWarningsCheckBox;
    }

    public RawCommandLineEditor getAdditionalArgsOptionsField() {
        return this.additionalArgsOptionsField;
    }

    public ThreeStateCheckBox getGenerateSourceMapsCheckBox() {
        return this.generateSourceMapsCheckBox;
    }

    public TextFieldWithBrowseButton getOutputDirectory() {
        return this.outputDirectory;
    }

    public ThreeStateCheckBox getCopyRuntimeFilesCheckBox() {
        return this.copyRuntimeFilesCheckBox;
    }

    public ThreeStateCheckBox getKeepAliveCheckBox() {
        return this.keepAliveCheckBox;
    }

    public JComboBox<String> getModuleKindComboBox() {
        return this.moduleKindComboBox;
    }

    public JTextField getScriptTemplatesField() {
        return this.scriptTemplatesField;
    }

    public JTextField getScriptTemplatesClasspathField() {
        return this.scriptTemplatesClasspathField;
    }

    public JComboBox<VersionView> getLanguageVersionComboBox() {
        return this.languageVersionComboBox;
    }

    public JComboBox<VersionView> getApiVersionComboBox() {
        return this.apiVersionComboBox;
    }

    public void setEnabled(boolean value) {
        this.isEnabled = value;
        UIUtil.setEnabled((Component)this.getContentPane(), (boolean)value, (boolean)true);
    }

    public CommonCompilerArguments getCommonCompilerArguments() {
        return this.commonCompilerArguments;
    }

    public void setCommonCompilerArguments(CommonCompilerArguments commonCompilerArguments) {
        this.commonCompilerArguments = commonCompilerArguments;
    }

    public K2JSCompilerArguments getK2jsCompilerArguments() {
        return this.k2jsCompilerArguments;
    }

    public void setK2jsCompilerArguments(K2JSCompilerArguments k2jsCompilerArguments) {
        this.k2jsCompilerArguments = k2jsCompilerArguments;
    }

    public K2JVMCompilerArguments getK2jvmCompilerArguments() {
        return this.k2jvmCompilerArguments;
    }

    public void setK2jvmCompilerArguments(K2JVMCompilerArguments k2jvmCompilerArguments) {
        this.k2jvmCompilerArguments = k2jvmCompilerArguments;
    }

    public CompilerSettings getCompilerSettings() {
        return this.compilerSettings;
    }

    public void setCompilerSettings(CompilerSettings compilerSettings) {
        this.compilerSettings = compilerSettings;
    }

    private void createUIComponents() {
        this.languageVersionComboBox = new ComboBox((ComboBoxModel)new MutableCollectionComboBoxModel());
        this.jpsPluginComboBoxModel = new ComboBoxModelWithPossiblyDisabledItems();
        this.kotlinJpsPluginVersionComboBox = new ComboBox((ComboBoxModel)((Object)this.jpsPluginComboBoxModel));
        this.apiVersionComboBox = new ComboBox((ComboBoxModel)new MutableCollectionComboBoxModel());
        this.copyRuntimeFilesCheckBox = new ThreeStateCheckBox(){

            public void setState(ThreeStateCheckBox.State state) {
                super.setState(state);
                KotlinCompilerConfigurableTab.this.updateOutputDirEnabled();
            }
        };
    }

    private static void createVersionValidator(JComboBox<VersionView> component, String messageKey, Disposable parentDisposable) {
        new ComponentValidator(parentDisposable).withValidator(() -> {
            VersionView selectedItem = (VersionView)component.getSelectedItem();
            if (selectedItem == null) {
                return null;
            }
            LanguageOrApiVersion version = selectedItem.getVersion();
            if (version.isUnsupported()) {
                return new ValidationInfo(KotlinBaseCompilerConfigurationUiBundle.message(messageKey, version.getVersionString()), (JComponent)component);
            }
            return null;
        }).installOn(component);
        component.addActionListener(e -> ComponentValidator.getInstance((JComponent)component).ifPresent(ComponentValidator::revalidate));
    }

    @NotNull
    private String extractDaemonVmOptions() {
        Pattern pattern2;
        Matcher matcher;
        String additionalOptions = this.getAdditionalArgsOptionsField().getText();
        if (additionalOptions.contains("-XdaemonVmOptions") && (matcher = (pattern2 = Pattern.compile("-XdaemonVmOptions=(?:\"([^\"]*)\"|([^\\s]*))")).matcher(additionalOptions)).find()) {
            String daemonArguments;
            String string = daemonArguments = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            if (daemonArguments != null) {
                String string2 = daemonArguments;
                if (string2 == null) {
                    KotlinCompilerConfigurableTab.$$$reportNull$$$0(20);
                }
                return string2;
            }
        }
        return "";
    }

    static {
        moduleKindDescriptions.put("plain", KotlinBaseCompilerConfigurationUiBundle.message("configuration.description.plain.put.to.global.scope", new Object[0]));
        moduleKindDescriptions.put("amd", KotlinBaseCompilerConfigurationUiBundle.message("configuration.description.amd", new Object[0]));
        moduleKindDescriptions.put("commonjs", KotlinBaseCompilerConfigurationUiBundle.message("configuration.description.commonjs", new Object[0]));
        moduleKindDescriptions.put("umd", KotlinBaseCompilerConfigurationUiBundle.message("configuration.description.umd.detect.amd.or.commonjs.if.available.fallback.to.plain", new Object[0]));
        sourceMapSourceEmbeddingDescriptions.put("never", KotlinBaseCompilerConfigurationUiBundle.message("configuration.description.never", new Object[0]));
        sourceMapSourceEmbeddingDescriptions.put("always", KotlinBaseCompilerConfigurationUiBundle.message("configuration.description.always", new Object[0]));
        sourceMapSourceEmbeddingDescriptions.put("inlining", KotlinBaseCompilerConfigurationUiBundle.message("configuration.description.when.inlining.a.function.from.other.module.with.embedded.sources", new Object[0]));
        latestStableVersion = null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ThreeStateCheckBox threeStateCheckBox;
        RawCommandLineEditor rawCommandLineEditor;
        JLabel jLabel;
        JPanel jPanel;
        ThreeStateCheckBox threeStateCheckBox2;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JLabel jLabel2;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel3;
        JCheckBox jCheckBox2;
        JTextField jTextField3;
        ThreeStateCheckBox threeStateCheckBox3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.createUIComponents();
        this.contentPane = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(13, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), null, 0, 0, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(12, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.k2jsPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel4).setVisible(true);
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel5.add((Component)jPanel4, new GridConstraints(9, 0, 1, 2, 1, 1, 3, 3, null, null, null, 0, true));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/KotlinBaseCompilerConfigurationUiBundle", KotlinCompilerConfigurableTab.class).getString("kotlin.compiler.js.option.panel.title"), (int)0, (int)0, null, null));
        this.labelForOutputDirectory = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/KotlinBaseCompilerConfigurationUiBundle", KotlinCompilerConfigurableTab.class).getString("destination.directory"));
        jPanel4.add((Component)jLabel3, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.outputDirectory = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText(DynamicBundle.getBundle((String)"messages/KotlinBaseCompilerConfigurationUiBundle", KotlinCompilerConfigurableTab.class).getString("kotlin.compiler.lib"));
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        ThreeStateCheckBox threeStateCheckBox4 = this.copyRuntimeFilesCheckBox;
        threeStateCheckBox4.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        this.$$$loadButtonText$$$((AbstractButton)threeStateCheckBox4, DynamicBundle.getBundle((String)"messages/KotlinBaseCompilerConfigurationUiBundle", KotlinCompilerConfigurableTab.class).getString("kotlin.compiler.js.option.output.copy.files"));
        jPanel4.add((Component)threeStateCheckBox4, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/KotlinBaseCompilerConfigurationUiBundle", KotlinCompilerConfigurableTab.class).getString("module.kind"));
        jPanel4.add((Component)jLabel4, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.moduleKindComboBox = jComboBox;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel4.add(jComboBox, new GridConstraints(6, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.generateSourceMapsCheckBox = threeStateCheckBox3 = new ThreeStateCheckBox();
        threeStateCheckBox3.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        this.$$$loadButtonText$$$((AbstractButton)threeStateCheckBox3, DynamicBundle.getBundle((String)"messages/KotlinBaseCompilerConfigurationUiBundle", KotlinCompilerConfigurableTab.class).getString("kotlin.compiler.js.option.generate.sourcemaps"));
        jPanel4.add((Component)threeStateCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.sourceMapPrefix = jTextField3 = new JTextField();
        jPanel4.add((Component)jTextField3, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/KotlinBaseCompilerConfigurationUiBundle", KotlinCompilerConfigurableTab.class).getString("embed.source.code.into.source.map"));
        jPanel4.add((Component)jLabel5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.sourceMapEmbedSources = jComboBox2;
        jPanel4.add(jComboBox2, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.enableIncrementalCompilationForJsCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/KotlinBaseCompilerConfigurationUiBundle", KotlinCompilerConfigurableTab.class).getString("enable.incremental.compilation"));
        jPanel4.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.scriptPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel3).setVisible(true);
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel5.add((Component)jPanel3, new GridConstraints(10, 0, 1, 2, 1, 1, 3, 3, null, null, null, 0, true));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/KotlinBaseCompilerConfigurationUiBundle", KotlinCompilerConfigurableTab.class).getString("kotlin.script.option.panel.title"), (int)0, (int)0, null, null));
        this.scriptTemplatesField = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.scriptTemplatesClasspathField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/KotlinBaseCompilerConfigurationUiBundle", KotlinCompilerConfigurableTab.class).getString("script.definition.template.classes.to.load.explicitly"));
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/KotlinBaseCompilerConfigurationUiBundle", KotlinCompilerConfigurableTab.class).getString("classpath.required.for.loading.script.definition.template.classes"));
        jPanel3.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.warningLabel = jLabel2 = new JLabel();
        jLabel2.setFocusable(false);
        jLabel2.setInheritsPopupMenu(false);
        jLabel2.setText("");
        ((Component)jLabel2).setVisible(false);
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.k2jvmPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setVisible(true);
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel5.add((Component)jPanel2, new GridConstraints(8, 0, 1, 2, 1, 1, 3, 3, null, null, null, 0, true));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/KotlinBaseCompilerConfigurationUiBundle", KotlinCompilerConfigurableTab.class).getString("kotlin.compiler.jvm.option.panel.title"), (int)0, (int)0, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, DynamicBundle.getBundle((String)"messages/KotlinBaseCompilerConfigurationUiBundle", KotlinCompilerConfigurableTab.class).getString("target.jvm.version"));
        jPanel2.add((Component)jLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.enableIncrementalCompilationForJvmCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/KotlinBaseCompilerConfigurationUiBundle", KotlinCompilerConfigurableTab.class).getString("enable.incremental.compilation"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JComboBox jComboBox3 = new JComboBox();
        this.jvmVersionComboBox = jComboBox3;
        jPanel2.add(jComboBox3, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.reportWarningsCheckBox = threeStateCheckBox2 = new ThreeStateCheckBox();
        threeStateCheckBox2.setSelected(false);
        threeStateCheckBox2.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        this.$$$loadButtonText$$$((AbstractButton)threeStateCheckBox2, DynamicBundle.getBundle((String)"messages/KotlinBaseCompilerConfigurationUiBundle", KotlinCompilerConfigurableTab.class).getString("kotlin.compiler.option.generate.no.warnings"));
        jPanel7.add((Component)threeStateCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        this.kotlinJpsPluginVersionPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, DynamicBundle.getBundle((String)"messages/KotlinBaseCompilerConfigurationUiBundle", KotlinCompilerConfigurableTab.class).getString("kotlin.compiler.version"));
        jPanel.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox<JpsVersionItem> jComboBox4 = this.kotlinJpsPluginVersionComboBox;
        jPanel.add(jComboBox4, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel8, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, DynamicBundle.getBundle((String)"messages/KotlinBaseCompilerConfigurationUiBundle", KotlinCompilerConfigurableTab.class).getString("language.version"));
        jPanel8.add((Component)jLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox<VersionView> jComboBox5 = this.languageVersionComboBox;
        jPanel8.add(jComboBox5, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel9, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, DynamicBundle.getBundle((String)"messages/KotlinBaseCompilerConfigurationUiBundle", KotlinCompilerConfigurableTab.class).getString("api.version"));
        jPanel9.add((Component)jLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox<VersionView> jComboBox6 = this.apiVersionComboBox;
        jPanel9.add(jComboBox6, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.additionalArgsLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/KotlinBaseCompilerConfigurationUiBundle", KotlinCompilerConfigurableTab.class).getString("kotlin.compiler.option.additional.command.line.parameters"));
        jPanel5.add((Component)jLabel, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.additionalArgsOptionsField = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption(DynamicBundle.getBundle((String)"messages/KotlinBaseCompilerConfigurationUiBundle", KotlinCompilerConfigurableTab.class).getString("additional.command.line.parameters"));
        jPanel5.add((Component)rawCommandLineEditor, new GridConstraints(6, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.keepAliveCheckBox = threeStateCheckBox = new ThreeStateCheckBox();
        threeStateCheckBox.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        this.$$$loadButtonText$$$((AbstractButton)threeStateCheckBox, DynamicBundle.getBundle((String)"messages/KotlinBaseCompilerConfigurationUiBundle", KotlinCompilerConfigurableTab.class).getString("keep.compiler.process.alive.between.invocations"));
        jPanel5.add((Component)threeStateCheckBox, new GridConstraints(7, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        jLabel4.setLabelFor(jComboBox);
        jBLabel.setLabelFor(jTextField2);
        jBLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 15, 16, 17, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonCompilerArguments";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k2jsCompilerArguments";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k2jvmCompilerArguments";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerSettings";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/base/compilerPreferences/configuration/KotlinCompilerConfigurableTab";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileChooser";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooser";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/base/compilerPreferences/configuration/KotlinCompilerConfigurableTab";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildOverridingModulesWarning";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleKindDescription";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceMapSourceEmbeddingDescription";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleKindOrDefault";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceMapSourceEmbeddingOrDefault";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedJvmVersion";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLanguageVersionView";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedAPIVersionView";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeKotlinJpsPluginVersion";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "extractDaemonVmOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setupFileChooser";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isBrowseFieldModified";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 15, 16, 17, 18, 19, 20 -> new IllegalStateException(string);
        };
    }

    private static class ComboBoxModelWithPossiblyDisabledItems
    extends MutableCollectionComboBoxModel<JpsVersionItem> {
        private ComboBoxModelWithPossiblyDisabledItems() {
        }

        public void setSelectedItem(@Nullable Object item) {
            if (item == null) {
                return;
            }
            if (!(item instanceof JpsVersionItem)) {
                throw new IllegalStateException(item + "is supposed to be JpsVersionItem");
            }
            if (!((JpsVersionItem)item).myEnabled) {
                return;
            }
            super.setSelectedItem(item);
        }
    }
}

