/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.m2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.descriptor.OverrideDependencyDescriptorMediator;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.m2.DefaultPomDependencyMgt;
import org.apache.ivy.plugins.parser.m2.PomDependencyMgt;
import org.apache.ivy.plugins.parser.m2.PomReader;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.util.Message;

public class PomModuleDescriptorBuilder {
    public static final Configuration[] MAVEN2_CONFIGURATIONS = new Configuration[]{new Configuration("default", Configuration.Visibility.PUBLIC, "runtime dependencies and master artifact can be used with this conf", new String[]{"runtime", "master"}, true, null), new Configuration("master", Configuration.Visibility.PUBLIC, "contains only the artifact published by this module itself, with no transitive dependencies", new String[0], true, null), new Configuration("compile", Configuration.Visibility.PUBLIC, "this is the default scope, used if none is specified. Compile dependencies are available in all classpaths.", new String[0], true, null), new Configuration("provided", Configuration.Visibility.PUBLIC, "this is much like compile, but indicates you expect the JDK or a container to provide it. It is only available on the compilation classpath, and is not transitive.", new String[0], true, null), new Configuration("runtime", Configuration.Visibility.PUBLIC, "this scope indicates that the dependency is not required for compilation, but is for execution. It is in the runtime and test classpaths, but not the compile classpath.", new String[]{"compile"}, true, null), new Configuration("test", Configuration.Visibility.PRIVATE, "this scope indicates that the dependency is not required for normal use of the application, and is only available for the test compilation and execution phases.", new String[]{"runtime"}, true, null), new Configuration("system", Configuration.Visibility.PUBLIC, "this scope is similar to provided except that you have to provide the JAR which contains it explicitly. The artifact is always available and is not looked up in a repository.", new String[0], true, null), new Configuration("sources", Configuration.Visibility.PUBLIC, "this configuration contains the source artifact of this module, if any.", new String[0], true, null), new Configuration("javadoc", Configuration.Visibility.PUBLIC, "this configuration contains the javadoc artifact of this module, if any.", new String[0], true, null), new Configuration("optional", Configuration.Visibility.PUBLIC, "contains all optional dependencies", new String[0], true, null)};
    static final Map MAVEN2_CONF_MAPPING = new HashMap();
    private static final Collection JAR_PACKAGINGS = Arrays.asList("ejb", "bundle", "maven-plugin", "eclipse-plugin", "jbi-component", "jbi-shared-library", "orbit", "hk2-jar");
    private final PomModuleDescriptor ivyModuleDescriptor;
    private ModuleRevisionId mrid;
    private DefaultArtifact mainArtifact;
    private ParserSettings parserSettings;

    public PomModuleDescriptorBuilder(ModuleDescriptorParser moduleDescriptorParser, Resource resource, ParserSettings parserSettings) {
        this.ivyModuleDescriptor = new PomModuleDescriptor(moduleDescriptorParser, resource);
        this.ivyModuleDescriptor.setResolvedPublicationDate(new Date(resource.getLastModified()));
        for (int i = 0; i < MAVEN2_CONFIGURATIONS.length; ++i) {
            this.ivyModuleDescriptor.addConfiguration(MAVEN2_CONFIGURATIONS[i]);
        }
        this.ivyModuleDescriptor.setMappingOverride(true);
        this.ivyModuleDescriptor.addExtraAttributeNamespace("m", Ivy.getIvyHomeURL() + "maven");
        this.parserSettings = parserSettings;
    }

    public ModuleDescriptor getModuleDescriptor() {
        return this.ivyModuleDescriptor;
    }

    public void setModuleRevId(String string, String string2, String string3) {
        this.mrid = ModuleRevisionId.newInstance(string, string2, string3);
        this.ivyModuleDescriptor.setModuleRevisionId(this.mrid);
        if (string3 == null || string3.endsWith("SNAPSHOT")) {
            this.ivyModuleDescriptor.setStatus("integration");
            return;
        }
        this.ivyModuleDescriptor.setStatus("release");
    }

    public void setHomePage(String string) {
        this.ivyModuleDescriptor.setHomePage(string);
    }

    public void setDescription(String string) {
        this.ivyModuleDescriptor.setDescription(string);
    }

    public void setLicenses(License[] licenseArray) {
        for (int i = 0; i < licenseArray.length; ++i) {
            this.ivyModuleDescriptor.addLicense(licenseArray[i]);
        }
    }

    public void addMainArtifact(String object, String object2) {
        if ("pom".equals(object2)) {
            object2 = this.parserSettings.getResolver(this.mrid);
            if (object2 != null && !ArtifactOrigin.isUnknown((ArtifactOrigin)(object2 = object2.locate((Artifact)(object = new DefaultArtifact(this.mrid, new Date(), (String)object, "jar", "jar")))))) {
                this.mainArtifact = object;
                this.ivyModuleDescriptor.addArtifact("master", this.mainArtifact);
            }
            return;
        }
        Object object3 = JAR_PACKAGINGS.contains(object2) ? "jar" : ("pear".equals(object2) ? "phar" : object2);
        this.mainArtifact = new DefaultArtifact(this.mrid, new Date(), (String)object, (String)object2, (String)object3);
        this.ivyModuleDescriptor.addArtifact("master", this.mainArtifact);
    }

    public void addDependency(Resource object, PomReader.PomDependencyData pomDependencyData) {
        Object object2;
        Object object3;
        Object object4;
        object = pomDependencyData.getScope();
        if (object != null && ((String)object).length() > 0 && !MAVEN2_CONF_MAPPING.containsKey(object)) {
            object = "compile";
        }
        object4 = (object4 = pomDependencyData.getVersion()) == null || ((String)object4).length() == 0 ? this.getDefaultVersion(pomDependencyData) : object4;
        object4 = ModuleRevisionId.newInstance(pomDependencyData.getGroupId(), pomDependencyData.getArtifactId(), (String)object4);
        Object object5 = this.ivyModuleDescriptor.getModuleRevisionId();
        if (object5 != null && ((ModuleRevisionId)object5).getModuleId().equals(((ModuleRevisionId)object4).getModuleId())) {
            return;
        }
        object5 = pomDependencyData.getExcludedModules();
        Boolean bl = !this.containsExcludeAllElement((List)object5);
        object4 = new PomDependencyDescriptor(pomDependencyData, this.ivyModuleDescriptor, (ModuleRevisionId)object4, bl);
        object = object == null || ((String)object).length() == 0 ? this.getDefaultScope(pomDependencyData) : object;
        Object object6 = (ConfMapper)MAVEN2_CONF_MAPPING.get(object);
        object6.addMappingConfs((DefaultDependencyDescriptor)object4, pomDependencyData.isOptional());
        object6 = new HashMap();
        if (pomDependencyData.getClassifier() != null || pomDependencyData.getType() != null && !"jar".equals(pomDependencyData.getType())) {
            object3 = "jar";
            if (pomDependencyData.getType() != null) {
                object3 = pomDependencyData.getType();
            }
            object2 = object3;
            if ("test-jar".equals(object3)) {
                object2 = "jar";
                object6.put("m:classifier", "tests");
            } else if (JAR_PACKAGINGS.contains(object3)) {
                object2 = "jar";
            }
            if (pomDependencyData.getClassifier() != null) {
                object6.put("m:classifier", pomDependencyData.getClassifier());
            }
            Object object7 = object4;
            object6 = new DefaultDependencyArtifactDescriptor((DependencyDescriptor)object7, ((DefaultDependencyDescriptor)object7).getDependencyId().getName(), (String)object3, (String)object2, null, (Map)object6);
            object = pomDependencyData.isOptional() ? "optional" : object;
            ((DefaultDependencyDescriptor)object4).addDependencyArtifact((String)object, (DependencyArtifactDescriptor)object6);
        }
        if (object5.isEmpty()) {
            object5 = PomModuleDescriptorBuilder.getDependencyMgtExclusions(this.ivyModuleDescriptor, pomDependencyData.getGroupId(), pomDependencyData.getArtifactId());
        }
        if (bl.booleanValue()) {
            object3 = object5.iterator();
            while (object3.hasNext()) {
                object2 = (ModuleId)object3.next();
                object6 = ((DefaultDependencyDescriptor)object4).getModuleConfigurations();
                for (int i = 0; i < ((String[])object6).length; ++i) {
                    ((DefaultDependencyDescriptor)object4).addExcludeRule(object6[i], new DefaultExcludeRule(new ArtifactId((ModuleId)object2, "*", "*", "*"), ExactPatternMatcher.INSTANCE, null));
                }
            }
        }
        this.ivyModuleDescriptor.addDependency((DependencyDescriptor)object4);
    }

    public void addDependency(DependencyDescriptor dependencyDescriptor) {
        ModuleId moduleId = dependencyDescriptor.getDependencyId();
        ModuleRevisionId moduleRevisionId = this.ivyModuleDescriptor.getModuleRevisionId();
        if (moduleRevisionId != null && moduleRevisionId.getModuleId().equals(moduleId)) {
            return;
        }
        this.ivyModuleDescriptor.addDependency(dependencyDescriptor);
    }

    public void addDependencyMgt(PomDependencyMgt pomDependencyMgt) {
        this.ivyModuleDescriptor.addDependencyManagement(pomDependencyMgt);
        String string = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoKeyForVersion(pomDependencyMgt.getGroupId(), pomDependencyMgt.getArtifactId());
        this.ivyModuleDescriptor.addExtraInfo(string, pomDependencyMgt.getVersion());
        if (pomDependencyMgt.getScope() != null) {
            string = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoKeyForScope(pomDependencyMgt.getGroupId(), pomDependencyMgt.getArtifactId());
            this.ivyModuleDescriptor.addExtraInfo(string, pomDependencyMgt.getScope());
        }
        if (!pomDependencyMgt.getExcludedModules().isEmpty()) {
            string = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoPrefixForExclusion(pomDependencyMgt.getGroupId(), pomDependencyMgt.getArtifactId());
            int n = 0;
            for (ModuleId moduleId : pomDependencyMgt.getExcludedModules()) {
                this.ivyModuleDescriptor.addExtraInfo(string + n, moduleId.getOrganisation() + "__" + moduleId.getName());
                ++n;
            }
        }
        this.ivyModuleDescriptor.addDependencyDescriptorMediator(ModuleId.newInstance(pomDependencyMgt.getGroupId(), pomDependencyMgt.getArtifactId()), ExactPatternMatcher.INSTANCE, new OverrideDependencyDescriptorMediator(null, pomDependencyMgt.getVersion()));
    }

    public void addPlugin(PomDependencyMgt object) {
        object = object.getGroupId() + "__" + object.getArtifactId() + "__" + object.getVersion();
        Object object2 = (String)this.ivyModuleDescriptor.getExtraInfo().get("m:maven.plugins");
        object2 = object2 == null ? object : (String)object2 + "|" + (String)object;
        this.ivyModuleDescriptor.getExtraInfo().put("m:maven.plugins", object2);
    }

    public static List getPlugins(ModuleDescriptor stringArray) {
        ArrayList<PomPluginElement> arrayList = new ArrayList<PomPluginElement>();
        if ((stringArray = (String)stringArray.getExtraInfo().get("m:maven.plugins")) == null) {
            return new ArrayList();
        }
        stringArray = stringArray.split("\\|");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("__");
            arrayList.add(new PomPluginElement(stringArray2[0], stringArray2[1], stringArray2[2]));
        }
        return arrayList;
    }

    private boolean containsExcludeAllElement(List object) {
        object = object.iterator();
        while (object.hasNext()) {
            ModuleId moduleId = (ModuleId)object.next();
            if (!moduleId.getOrganisation().equals("*") || !moduleId.getName().equals("*")) continue;
            return true;
        }
        return false;
    }

    private String getDefaultVersion(PomReader.PomDependencyData object) {
        ModuleId moduleId = ModuleId.newInstance(((PomReader.PomDependencyMgtElement)object).getGroupId(), ((PomReader.PomDependencyMgtElement)object).getArtifactId());
        if (this.ivyModuleDescriptor.getDependencyManagementMap().containsKey(moduleId)) {
            return ((PomDependencyMgt)this.ivyModuleDescriptor.getDependencyManagementMap().get(moduleId)).getVersion();
        }
        object = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoKeyForVersion(((PomReader.PomDependencyMgtElement)object).getGroupId(), ((PomReader.PomDependencyMgtElement)object).getArtifactId());
        return (String)this.ivyModuleDescriptor.getExtraInfo().get(object);
    }

    private String getDefaultScope(PomReader.PomDependencyData object) {
        ModuleId moduleId = ModuleId.newInstance(((PomReader.PomDependencyMgtElement)object).getGroupId(), ((PomReader.PomDependencyMgtElement)object).getArtifactId());
        if (this.ivyModuleDescriptor.getDependencyManagementMap().containsKey(moduleId)) {
            object = ((PomDependencyMgt)this.ivyModuleDescriptor.getDependencyManagementMap().get(moduleId)).getScope();
        } else {
            object = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoKeyForScope(((PomReader.PomDependencyMgtElement)object).getGroupId(), ((PomReader.PomDependencyMgtElement)object).getArtifactId());
            object = (String)this.ivyModuleDescriptor.getExtraInfo().get(object);
        }
        if (object == null || !MAVEN2_CONF_MAPPING.containsKey(object)) {
            object = "compile";
        }
        return object;
    }

    private static String getDependencyMgtExtraInfoKeyForVersion(String string, String string2) {
        return "m:dependency.management__" + string + "__" + string2 + "__version";
    }

    private static String getDependencyMgtExtraInfoKeyForScope(String string, String string2) {
        return "m:dependency.management__" + string + "__" + string2 + "__scope";
    }

    private static String getPropertyExtraInfoKey(String string) {
        return "m:properties__" + string;
    }

    private static String getDependencyMgtExtraInfoPrefixForExclusion(String string, String string2) {
        return "m:dependency.management__" + string + "__" + string2 + "__exclusion_";
    }

    private static List getDependencyMgtExclusions(ModuleDescriptor iterator, String object, String entry2) {
        Object object2;
        if (iterator instanceof PomModuleDescriptor && (object2 = (PomDependencyMgt)((PomModuleDescriptor)((Object)iterator)).getDependencyManagementMap().get(ModuleId.newInstance((String)object, (String)((Object)entry2)))) != null) {
            return object2.getExcludedModules();
        }
        object2 = PomModuleDescriptorBuilder.getDependencyMgtExtraInfoPrefixForExclusion((String)object, (String)((Object)entry2));
        object = new LinkedList();
        iterator = iterator.getExtraInfo();
        for (Map.Entry entry2 : iterator.entrySet()) {
            String[] stringArray = (String[])entry2.getKey();
            if (!stringArray.startsWith((String)object2)) continue;
            stringArray = ((String)((Object)(entry2 = (String)entry2.getValue()))).split("__");
            if (stringArray.length != 2) {
                Message.error("what seemed to be a dependency management extra info exclusion had the wrong number of parts (should have 2) " + stringArray.length + " : " + (String)((Object)entry2));
                continue;
            }
            object.add(ModuleId.newInstance(stringArray[0], stringArray[1]));
        }
        return object;
    }

    public static List getDependencyManagements(ModuleDescriptor moduleDescriptor) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (moduleDescriptor instanceof PomModuleDescriptor) {
            arrayList.addAll(((PomModuleDescriptor)moduleDescriptor).getDependencyManagementMap().values());
        } else {
            for (Map.Entry entry : moduleDescriptor.getExtraInfo().entrySet()) {
                String string = (String)entry.getKey();
                if (!string.startsWith("m:dependency.management")) continue;
                String[] stringArray = string.split("__");
                if (stringArray.length != 4) {
                    Message.warn("what seem to be a dependency management extra info doesn't match expected pattern: " + string);
                    continue;
                }
                String string2 = "m:dependency.management__" + stringArray[1] + "__" + stringArray[2] + "__version";
                String string3 = "m:dependency.management__" + stringArray[1] + "__" + stringArray[2] + "__scope";
                String string4 = (String)moduleDescriptor.getExtraInfo().get(string2);
                string3 = (String)moduleDescriptor.getExtraInfo().get(string3);
                List list = PomModuleDescriptorBuilder.getDependencyMgtExclusions(moduleDescriptor, stringArray[1], stringArray[2]);
                arrayList.add(new DefaultPomDependencyMgt(stringArray[1], stringArray[2], string4, string3, list));
            }
        }
        return arrayList;
    }

    public void addExtraInfos(Map object) {
        for (Map.Entry entry : object.entrySet()) {
            String string = (String)entry.getKey();
            String object2 = (String)entry.getValue();
            this.addExtraInfo(string, object2);
        }
    }

    private void addExtraInfo(String string, String string2) {
        if (!this.ivyModuleDescriptor.getExtraInfo().containsKey(string)) {
            this.ivyModuleDescriptor.addExtraInfo(string, string2);
        }
    }

    public static Map extractPomProperties(Map object) {
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : object.entrySet()) {
            if (!((String)entry.getKey()).startsWith("m:properties")) continue;
            String string = ((String)entry.getKey()).substring(12 + 2);
            hashMap.put(string, entry.getValue());
        }
        return hashMap;
    }

    public void addProperty(String string, String string2) {
        this.addExtraInfo(PomModuleDescriptorBuilder.getPropertyExtraInfoKey(string), string2);
    }

    public Artifact getMainArtifact() {
        return this.mainArtifact;
    }

    public Artifact getSourceArtifact() {
        return new MDArtifact(this.ivyModuleDescriptor, this.mrid.getName(), "source", "jar", null, Collections.singletonMap("m:classifier", "sources"));
    }

    public Artifact getSrcArtifact() {
        return new MDArtifact(this.ivyModuleDescriptor, this.mrid.getName(), "source", "jar", null, Collections.singletonMap("m:classifier", "src"));
    }

    public Artifact getJavadocArtifact() {
        return new MDArtifact(this.ivyModuleDescriptor, this.mrid.getName(), "javadoc", "jar", null, Collections.singletonMap("m:classifier", "javadoc"));
    }

    public void addSourceArtifact() {
        this.ivyModuleDescriptor.addArtifact("sources", this.getSourceArtifact());
    }

    public void addSrcArtifact() {
        this.ivyModuleDescriptor.addArtifact("sources", this.getSrcArtifact());
    }

    public void addJavadocArtifact() {
        this.ivyModuleDescriptor.addArtifact("javadoc", this.getJavadocArtifact());
    }

    static {
        MAVEN2_CONF_MAPPING.put("compile", new ConfMapper(){

            @Override
            public final void addMappingConfs(DefaultDependencyDescriptor defaultDependencyDescriptor, boolean bl) {
                if (bl) {
                    defaultDependencyDescriptor.addDependencyConfiguration("optional", "compile(*)");
                    defaultDependencyDescriptor.addDependencyConfiguration("optional", "master(*)");
                    return;
                }
                defaultDependencyDescriptor.addDependencyConfiguration("compile", "compile(*)");
                defaultDependencyDescriptor.addDependencyConfiguration("compile", "master(*)");
                defaultDependencyDescriptor.addDependencyConfiguration("runtime", "runtime(*)");
            }
        });
        MAVEN2_CONF_MAPPING.put("provided", new ConfMapper(){

            @Override
            public final void addMappingConfs(DefaultDependencyDescriptor defaultDependencyDescriptor, boolean bl) {
                if (bl) {
                    defaultDependencyDescriptor.addDependencyConfiguration("optional", "compile(*)");
                    defaultDependencyDescriptor.addDependencyConfiguration("optional", "provided(*)");
                    defaultDependencyDescriptor.addDependencyConfiguration("optional", "runtime(*)");
                    defaultDependencyDescriptor.addDependencyConfiguration("optional", "master(*)");
                    return;
                }
                defaultDependencyDescriptor.addDependencyConfiguration("provided", "compile(*)");
                defaultDependencyDescriptor.addDependencyConfiguration("provided", "provided(*)");
                defaultDependencyDescriptor.addDependencyConfiguration("provided", "runtime(*)");
                defaultDependencyDescriptor.addDependencyConfiguration("provided", "master(*)");
            }
        });
        MAVEN2_CONF_MAPPING.put("runtime", new ConfMapper(){

            @Override
            public final void addMappingConfs(DefaultDependencyDescriptor defaultDependencyDescriptor, boolean bl) {
                if (bl) {
                    defaultDependencyDescriptor.addDependencyConfiguration("optional", "compile(*)");
                    defaultDependencyDescriptor.addDependencyConfiguration("optional", "provided(*)");
                    defaultDependencyDescriptor.addDependencyConfiguration("optional", "master(*)");
                    return;
                }
                defaultDependencyDescriptor.addDependencyConfiguration("runtime", "compile(*)");
                defaultDependencyDescriptor.addDependencyConfiguration("runtime", "runtime(*)");
                defaultDependencyDescriptor.addDependencyConfiguration("runtime", "master(*)");
            }
        });
        MAVEN2_CONF_MAPPING.put("test", new ConfMapper(){

            @Override
            public final void addMappingConfs(DefaultDependencyDescriptor defaultDependencyDescriptor, boolean bl) {
                defaultDependencyDescriptor.addDependencyConfiguration("test", "runtime(*)");
                defaultDependencyDescriptor.addDependencyConfiguration("test", "master(*)");
            }
        });
        MAVEN2_CONF_MAPPING.put("system", new ConfMapper(){

            @Override
            public final void addMappingConfs(DefaultDependencyDescriptor defaultDependencyDescriptor, boolean bl) {
                defaultDependencyDescriptor.addDependencyConfiguration("system", "master(*)");
            }
        });
    }

    public static class PomModuleDescriptor
    extends DefaultModuleDescriptor {
        private final Map dependencyManagementMap = new HashMap();

        public PomModuleDescriptor(ModuleDescriptorParser moduleDescriptorParser, Resource resource) {
            super(moduleDescriptorParser, resource);
        }

        public void addDependencyManagement(PomDependencyMgt pomDependencyMgt) {
            this.dependencyManagementMap.put(ModuleId.newInstance(pomDependencyMgt.getGroupId(), pomDependencyMgt.getArtifactId()), pomDependencyMgt);
        }

        public Map getDependencyManagementMap() {
            return this.dependencyManagementMap;
        }
    }

    public static class PomDependencyDescriptor
    extends DefaultDependencyDescriptor {
        private final PomReader.PomDependencyData pomDependencyData;

        private PomDependencyDescriptor(PomReader.PomDependencyData pomDependencyData, ModuleDescriptor moduleDescriptor, ModuleRevisionId moduleRevisionId, Boolean bl) {
            super(moduleDescriptor, moduleRevisionId, true, false, bl);
            this.pomDependencyData = pomDependencyData;
        }

        public PomReader.PomDependencyData getPomDependencyData() {
            return this.pomDependencyData;
        }
    }

    private static class PomPluginElement
    implements PomDependencyMgt {
        private String groupId;
        private String artifactId;
        private String version;

        public PomPluginElement(String string, String string2, String string3) {
            this.groupId = string;
            this.artifactId = string2;
            this.version = string3;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public String getArtifactId() {
            return this.artifactId;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getScope() {
            return null;
        }

        @Override
        public List getExcludedModules() {
            return Collections.EMPTY_LIST;
        }
    }

    static interface ConfMapper {
        public void addMappingConfs(DefaultDependencyDescriptor var1, boolean var2);
    }
}

