/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class Font2DTest
extends JPanel
implements ActionListener,
ItemListener,
ChangeListener {
    private final JFrame parent;
    private final FontPanel fp;
    private final RangeMenu rm;
    private final ChoiceV2 fontMenu;
    private final JTextField sizeField;
    private final ChoiceV2 styleMenu;
    private final ChoiceV2 textMenu;
    private int currentTextChoice = 0;
    private final ChoiceV2 transformMenu;
    private final ChoiceV2 transformMenuG2;
    private final ChoiceV2 methodsMenu;
    private final JComboBox antiAliasMenu;
    private final JComboBox fracMetricsMenu;
    private final JSlider contrastSlider;
    private CheckboxMenuItemV2 displayGridCBMI;
    private CheckboxMenuItemV2 force16ColsCBMI;
    private CheckboxMenuItemV2 showFontInfoCBMI;
    private JDialog userTextDialog;
    private JTextArea userTextArea;
    private JDialog printDialog;
    private JDialog fontInfoDialog;
    private LabelV2[] fontInfos = new LabelV2[2];
    private JFileChooser filePromptDialog = null;
    private ButtonGroup printCBGroup;
    private JRadioButton[] printModeCBs = new JRadioButton[3];
    private final LabelV2 statusBar;
    private int[] fontStyles = new int[]{0, 1, 2, 3};
    private String tFileName;
    private static boolean canDisplayCheck = true;

    public Font2DTest(JFrame f, boolean isApplet) {
        this.parent = f;
        this.rm = new RangeMenu(this, this.parent);
        this.fp = new FontPanel(this, this.parent);
        this.statusBar = new LabelV2("");
        this.fontMenu = new ChoiceV2(this, canDisplayCheck);
        this.sizeField = new JTextField("12", 3);
        this.sizeField.addActionListener(this);
        this.styleMenu = new ChoiceV2(this);
        this.textMenu = new ChoiceV2();
        this.transformMenu = new ChoiceV2(this);
        this.transformMenuG2 = new ChoiceV2(this);
        this.methodsMenu = new ChoiceV2(this);
        this.antiAliasMenu = new JComboBox<Object>(EnumSet.allOf(FontPanel.AAValues.class).toArray());
        this.antiAliasMenu.addActionListener(this);
        this.fracMetricsMenu = new JComboBox<Object>(EnumSet.allOf(FontPanel.FMValues.class).toArray());
        this.fracMetricsMenu.addActionListener(this);
        this.contrastSlider = new JSlider(0, 100, 250, FontPanel.getDefaultLCDContrast());
        this.contrastSlider.setEnabled(false);
        this.contrastSlider.setMajorTickSpacing(20);
        this.contrastSlider.setMinorTickSpacing(10);
        this.contrastSlider.setPaintTicks(true);
        this.contrastSlider.setPaintLabels(true);
        this.contrastSlider.addChangeListener(this);
        this.setupPanel();
        this.setupMenu(isApplet);
        this.setupDialog(isApplet);
        if (canDisplayCheck) {
            this.fireRangeChanged();
        }
    }

    private void setupPanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 0, 2, 2);
        this.setLayout(gbl);
        this.addLabeledComponentToGBL("Font: ", this.fontMenu, gbl, gbc, this);
        this.addLabeledComponentToGBL("Size: ", this.sizeField, gbl, gbc, this);
        gbc.gridwidth = 0;
        this.addLabeledComponentToGBL("Font Transform:", this.transformMenu, gbl, gbc, this);
        gbc.gridwidth = 1;
        this.addLabeledComponentToGBL("Range: ", this.rm, gbl, gbc, this);
        this.addLabeledComponentToGBL("Style: ", this.styleMenu, gbl, gbc, this);
        gbc.gridwidth = 0;
        this.addLabeledComponentToGBL("Graphics Transform: ", this.transformMenuG2, gbl, gbc, this);
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        this.addLabeledComponentToGBL("Method: ", this.methodsMenu, gbl, gbc, this);
        this.addLabeledComponentToGBL("", null, gbl, gbc, this);
        gbc.anchor = 13;
        gbc.gridwidth = 0;
        this.addLabeledComponentToGBL("Text to use:", this.textMenu, gbl, gbc, this);
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.addLabeledComponentToGBL("LCD contrast: ", this.contrastSlider, gbl, gbc, this);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        this.addLabeledComponentToGBL("Antialiasing: ", this.antiAliasMenu, gbl, gbc, this);
        gbc.anchor = 13;
        gbc.gridwidth = 0;
        this.addLabeledComponentToGBL("Fractional metrics: ", this.fracMetricsMenu, gbl, gbc, this);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 0, 0, 2);
        gbc.fill = 1;
        gbl.setConstraints(this.fp, gbc);
        this.add(this.fp);
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 2, 0, 0);
        gbl.setConstraints(this.statusBar, gbc);
        this.add(this.statusBar);
    }

    private void addLabeledComponentToGBL(String name, JComponent c, GridBagLayout gbl, GridBagConstraints gbc, Container target) {
        LabelV2 l = new LabelV2(name);
        GridBagConstraints gbcLabel = (GridBagConstraints)gbc.clone();
        gbcLabel.insets = new Insets(2, 2, 2, 0);
        gbcLabel.gridwidth = 1;
        gbcLabel.weightx = 0.0;
        if (c == null) {
            c = new JLabel("");
        }
        gbl.setConstraints(l, gbcLabel);
        target.add(l);
        gbl.setConstraints(c, gbc);
        target.add(c);
    }

    private void setupMenu(boolean isApplet) {
        JMenu fileMenu = new JMenu("File");
        JMenu optionMenu = new JMenu("Option");
        fileMenu.add(new MenuItemV2("Save Selected Options...", this));
        fileMenu.add(new MenuItemV2("Load Options...", this));
        fileMenu.addSeparator();
        fileMenu.add(new MenuItemV2("Save as PNG...", this));
        fileMenu.add(new MenuItemV2("Load PNG File to Compare...", this));
        fileMenu.add(new MenuItemV2("Page Setup...", this));
        fileMenu.add(new MenuItemV2("Print...", this));
        fileMenu.addSeparator();
        if (!isApplet) {
            fileMenu.add(new MenuItemV2("Exit", this));
        } else {
            fileMenu.add(new MenuItemV2("Close", this));
        }
        this.displayGridCBMI = new CheckboxMenuItemV2("Display Grid", true, this);
        this.force16ColsCBMI = new CheckboxMenuItemV2("Force 16 Columns", false, this);
        this.showFontInfoCBMI = new CheckboxMenuItemV2("Display Font Info", false, this);
        optionMenu.add(this.displayGridCBMI);
        optionMenu.add(this.force16ColsCBMI);
        optionMenu.add(this.showFontInfoCBMI);
        JMenuBar mb = this.parent.getJMenuBar();
        if (mb == null) {
            mb = new JMenuBar();
        }
        mb.add(fileMenu);
        mb.add(optionMenu);
        this.parent.setJMenuBar(mb);
        String[] fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < fontList.length; ++i) {
            this.fontMenu.addItem(fontList[i]);
        }
        this.fontMenu.setSelectedItem("Dialog");
        this.styleMenu.addItem("Plain");
        this.styleMenu.addItem("Bold");
        this.styleMenu.addItem("Italic");
        this.styleMenu.addItem("Bold Italic");
        this.transformMenu.addItem("None");
        this.transformMenu.addItem("Scale");
        this.transformMenu.addItem("Shear");
        this.transformMenu.addItem("Rotate");
        this.transformMenuG2.addItem("None");
        this.transformMenuG2.addItem("Scale");
        this.transformMenuG2.addItem("Shear");
        this.transformMenuG2.addItem("Rotate");
        this.methodsMenu.addItem("drawString");
        this.methodsMenu.addItem("drawChars");
        this.methodsMenu.addItem("drawBytes");
        this.methodsMenu.addItem("drawGlyphVector");
        this.methodsMenu.addItem("TextLayout.draw");
        this.methodsMenu.addItem("GlyphVector.getOutline + draw");
        this.methodsMenu.addItem("TextLayout.getOutline + draw");
        this.textMenu.addItem("Unicode Range");
        this.textMenu.addItem("All Glyphs");
        this.textMenu.addItem("User Text");
        this.textMenu.addItem("Text File");
        this.textMenu.addActionListener(this);
    }

    private void setupDialog(boolean isApplet) {
        this.filePromptDialog = !isApplet ? new JFileChooser() : null;
        this.userTextDialog = new JDialog(this.parent, "User Text", false);
        JPanel dialogTopPanel = new JPanel();
        JPanel dialogBottomPanel = new JPanel();
        LabelV2 message1 = new LabelV2("Enter text below and then press update");
        LabelV2 message2 = new LabelV2("(Unicode char can be denoted by \\uXXXX)");
        LabelV2 message3 = new LabelV2("(Supplementary chars can be denoted by \\UXXXXXX)");
        this.userTextArea = new JTextArea("Font2DTest!");
        ButtonV2 bUpdate = new ButtonV2("Update", this);
        this.userTextArea.setFont(new Font("dialog", 0, 12));
        dialogTopPanel.setLayout(new GridLayout(3, 1));
        dialogTopPanel.add(message1);
        dialogTopPanel.add(message2);
        dialogTopPanel.add(message3);
        dialogBottomPanel.add(bUpdate);
        JScrollPane userTextAreaSP = new JScrollPane(this.userTextArea);
        userTextAreaSP.setPreferredSize(new Dimension(300, 100));
        this.userTextDialog.getContentPane().setLayout(new BorderLayout());
        this.userTextDialog.getContentPane().add("North", dialogTopPanel);
        this.userTextDialog.getContentPane().add("Center", userTextAreaSP);
        this.userTextDialog.getContentPane().add("South", dialogBottomPanel);
        this.userTextDialog.pack();
        this.userTextDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Font2DTest.this.userTextDialog.hide();
            }
        });
        this.printCBGroup = new ButtonGroup();
        Objects.requireNonNull(this.fp);
        this.printModeCBs[0] = new JRadioButton("Print one page from currently displayed character/line", true);
        Objects.requireNonNull(this.fp);
        this.printModeCBs[1] = new JRadioButton("Print all characters in currently selected range", false);
        Objects.requireNonNull(this.fp);
        this.printModeCBs[2] = new JRadioButton("Print all lines of text", false);
        LabelV2 l = new LabelV2("Note: Page range in native \"Print\" dialog will not affect the result");
        JPanel buttonPanel = new JPanel();
        Objects.requireNonNull(this.fp);
        this.printModeCBs[2].setEnabled(false);
        buttonPanel.add(new ButtonV2("Print", this));
        buttonPanel.add(new ButtonV2("Cancel", this));
        this.printDialog = new JDialog(this.parent, "Print...", true);
        this.printDialog.setResizable(false);
        this.printDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Font2DTest.this.printDialog.hide();
            }
        });
        this.printDialog.getContentPane().setLayout(new GridLayout(this.printModeCBs.length + 2, 1));
        this.printDialog.getContentPane().add(l);
        for (int i = 0; i < this.printModeCBs.length; ++i) {
            this.printCBGroup.add(this.printModeCBs[i]);
            this.printDialog.getContentPane().add(this.printModeCBs[i]);
        }
        this.printDialog.getContentPane().add(buttonPanel);
        this.printDialog.pack();
        this.fontInfoDialog = new JDialog(this.parent, "Font info", false);
        this.fontInfoDialog.setResizable(false);
        this.fontInfoDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Font2DTest.this.fontInfoDialog.hide();
                Font2DTest.this.showFontInfoCBMI.setState(false);
            }
        });
        JPanel fontInfoPanel = new JPanel();
        fontInfoPanel.setLayout(new GridLayout(this.fontInfos.length, 1));
        for (int i = 0; i < this.fontInfos.length; ++i) {
            this.fontInfos[i] = new LabelV2("");
            fontInfoPanel.add(this.fontInfos[i]);
        }
        this.fontInfoDialog.getContentPane().add(fontInfoPanel);
        this.userTextDialog.setLocation(200, 300);
        this.fontInfoDialog.setLocation(0, 400);
    }

    public void fireRangeChanged() {
        int[] range = this.rm.getSelectedRange();
        Objects.requireNonNull(this.fp);
        this.fp.setTextToDraw(0, range, null, null);
        if (canDisplayCheck) {
            this.setupFontList(range[0], range[1]);
        }
        if (this.showFontInfoCBMI.getState()) {
            this.fireUpdateFontInfo();
        }
    }

    public void fireChangeStatus(String message, boolean error) {
        this.statusBar.setText(message);
        this.fp.showingError = error;
    }

    public void fireUpdateFontInfo() {
        if (this.showFontInfoCBMI.getState()) {
            String[] infos = this.fp.getFontInfo();
            for (int i = 0; i < this.fontInfos.length; ++i) {
                this.fontInfos[i].setText(infos[i]);
            }
            this.fontInfoDialog.pack();
        }
    }

    private void setupFontList(int rangeStart, int rangeEnd) {
        int listCount = this.fontMenu.getItemCount();
        int size = 16;
        try {
            size = Float.valueOf(this.sizeField.getText()).intValue();
        }
        catch (Exception e) {
            System.out.println("Invalid font size in the size textField. Using default value of 16");
        }
        int style = this.fontStyles[this.styleMenu.getSelectedIndex()];
        for (int i = 0; i < listCount; ++i) {
            String fontName = (String)this.fontMenu.getItemAt(i);
            Font f = new Font(fontName, style, size);
            if (this.rm.getSelectedIndex() != 91 && this.canDisplayRange(f, rangeStart, rangeEnd)) {
                this.fontMenu.setBit(i, true);
                continue;
            }
            this.fontMenu.setBit(i, false);
        }
        this.fontMenu.repaint();
    }

    protected boolean canDisplayRange(Font font, int rangeStart, int rangeEnd) {
        for (int i = rangeStart; i < rangeEnd; ++i) {
            if (!font.canDisplay(i)) continue;
            return true;
        }
        return false;
    }

    private String promptFile(boolean isSave, String initFileName) {
        File file;
        String fileName;
        int retVal;
        String str;
        if (this.filePromptDialog == null) {
            return null;
        }
        if (isSave) {
            this.filePromptDialog.setDialogType(1);
            this.filePromptDialog.setDialogTitle("Save...");
            str = "Save";
        } else {
            this.filePromptDialog.setDialogType(0);
            this.filePromptDialog.setDialogTitle("Load...");
            str = "Load";
        }
        if (initFileName != null) {
            this.filePromptDialog.setSelectedFile(new File(initFileName));
        }
        if ((retVal = this.filePromptDialog.showDialog(this, str)) == 0 && (fileName = (file = this.filePromptDialog.getSelectedFile()).getAbsolutePath()) != null) {
            return fileName;
        }
        return null;
    }

    private String[] parseUserText(String orig) {
        int length = orig.length();
        StringTokenizer perLine = new StringTokenizer(orig, "\n");
        String[] textLines = new String[perLine.countTokens()];
        int lineNumber = 0;
        while (perLine.hasMoreElements()) {
            StringBuffer converted = new StringBuffer();
            String oneLine = perLine.nextToken();
            int lineLength = oneLine.length();
            int prevEscapeEnd = 0;
            int nextEscape = -1;
            do {
                int nextBMPEscape = oneLine.indexOf("\\u", prevEscapeEnd);
                int nextSupEscape = oneLine.indexOf("\\U", prevEscapeEnd);
                int n = nextBMPEscape < 0 ? (nextSupEscape < 0 ? -1 : nextSupEscape) : (nextEscape = nextSupEscape < 0 ? nextBMPEscape : Math.min(nextBMPEscape, nextSupEscape));
                if (nextEscape == -1) continue;
                if (prevEscapeEnd < nextEscape) {
                    converted.append(oneLine.substring(prevEscapeEnd, nextEscape));
                }
                prevEscapeEnd = nextEscape + (nextEscape == nextBMPEscape ? 6 : 8);
                try {
                    String hex = oneLine.substring(nextEscape + 2, prevEscapeEnd);
                    if (nextEscape == nextBMPEscape) {
                        converted.append((char)Integer.parseInt(hex, 16));
                        continue;
                    }
                    converted.append(new String(Character.toChars(Integer.parseInt(hex, 16))));
                }
                catch (Exception e) {
                    int copyLimit = Math.min(lineLength, prevEscapeEnd);
                    converted.append(oneLine.substring(nextEscape, copyLimit));
                }
            } while (nextEscape != -1);
            if (prevEscapeEnd < lineLength) {
                converted.append(oneLine.substring(prevEscapeEnd, lineLength));
            }
            textLines[lineNumber++] = converted.toString();
        }
        return textLines;
    }

    private void readTextFile(String fileName) {
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fileName));
            int numBytes = bis.available();
            if (numBytes == 0) {
                throw new Exception("Text file " + fileName + " is empty");
            }
            byte[] byteData = new byte[numBytes];
            bis.read(byteData, 0, numBytes);
            bis.close();
            String fileText = numBytes >= 2 && (byteData[0] == -1 && byteData[1] == -2 || byteData[0] == -2 && byteData[1] == -1) ? new String(byteData, "UTF-16") : new String(byteData);
            int length = fileText.length();
            StringTokenizer perLine = new StringTokenizer(fileText, "\n");
            for (int i = 0; i < length; ++i) {
                char iTh = fileText.charAt(i);
                if (iTh == '\r') {
                    if (i < length - 1 && fileText.charAt(i + 1) == '\n') {
                        perLine = new StringTokenizer(fileText, "\r\n");
                        break;
                    }
                    perLine = new StringTokenizer(fileText, "\r");
                    break;
                }
                if (iTh == '\n') break;
            }
            int lineNumber = 0;
            int numLines = perLine.countTokens();
            String[] textLines = new String[numLines];
            while (perLine.hasMoreElements()) {
                String oneLine = perLine.nextToken();
                if (oneLine == null) {
                    oneLine = " ";
                }
                textLines[lineNumber++] = oneLine;
            }
            this.fp.setTextToDraw(this.fp.FILE_TEXT, null, null, textLines);
            this.rm.setEnabled(false);
            this.methodsMenu.setEnabled(false);
        }
        catch (Exception ex) {
            this.fireChangeStatus("ERROR: Failed to Read Text File; See Stack Trace", true);
            ex.printStackTrace();
        }
    }

    private void writeCurrentOptions(String fileName) {
        try {
            String curOptions = this.fp.getCurrentOptions();
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(fileName));
            int[] range = this.rm.getSelectedRange();
            String completeOptions = "Font2DTest Option File\n" + this.displayGridCBMI.getState() + "\n" + this.force16ColsCBMI.getState() + "\n" + this.showFontInfoCBMI.getState() + "\n" + String.valueOf(this.rm.getSelectedItem()) + "\n" + range[0] + "\n" + range[1] + "\n" + curOptions + this.tFileName;
            byte[] toBeWritten = completeOptions.getBytes("UTF-16");
            bos.write(toBeWritten, 0, toBeWritten.length);
            bos.close();
        }
        catch (Exception ex) {
            this.fireChangeStatus("ERROR: Failed to Save Options File; See Stack Trace", true);
            ex.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateGUI() {
        selectedText = this.textMenu.getSelectedIndex();
        Objects.requireNonNull(this.fp);
        if (selectedText == 2) {
            this.userTextDialog.show();
        } else {
            this.userTextDialog.hide();
        }
        Objects.requireNonNull(this.fp);
        this.printModeCBs[0].setSelected(true);
        if (selectedText == this.fp.FILE_TEXT) ** GOTO lbl-1000
        Objects.requireNonNull(this.fp);
        if (selectedText == 2) lbl-1000:
        // 2 sources

        {
            if (selectedText == this.fp.FILE_TEXT) {
                this.methodsMenu.setSelectedItem("TextLayout.draw");
            }
            Objects.requireNonNull(this.fp);
            this.methodsMenu.setEnabled(selectedText == 2);
            Objects.requireNonNull(this.fp);
            this.printModeCBs[1].setEnabled(false);
            Objects.requireNonNull(this.fp);
            this.printModeCBs[2].setEnabled(true);
        } else {
            Objects.requireNonNull(this.fp);
            if (selectedText == 1) {
                this.methodsMenu.setSelectedItem("drawGlyphVector");
            }
            Objects.requireNonNull(this.fp);
            this.methodsMenu.setEnabled(selectedText == 0);
            Objects.requireNonNull(this.fp);
            this.printModeCBs[1].setEnabled(true);
            Objects.requireNonNull(this.fp);
            this.printModeCBs[2].setEnabled(false);
        }
        Objects.requireNonNull(this.fp);
        if (selectedText == 0) {
            this.fontInfos[1].setVisible(true);
            this.rm.setEnabled(true);
        } else {
            this.fontInfos[1].setVisible(false);
            this.rm.setEnabled(false);
        }
    }

    private void loadOptions(String fileName) {
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fileName));
            int numBytes = bis.available();
            byte[] byteData = new byte[numBytes];
            bis.read(byteData, 0, numBytes);
            bis.close();
            if (numBytes < 2 || byteData[0] != -2 || byteData[1] != -1) {
                throw new Exception("Not a Font2DTest options file");
            }
            String options = new String(byteData, "UTF-16");
            StringTokenizer perLine = new StringTokenizer(options, "\n");
            String title = perLine.nextToken();
            if (!title.equals("Font2DTest Option File")) {
                throw new Exception("Not a Font2DTest options file");
            }
            boolean displayGridOpt = Boolean.parseBoolean(perLine.nextToken());
            boolean force16ColsOpt = Boolean.parseBoolean(perLine.nextToken());
            boolean showFontInfoOpt = Boolean.parseBoolean(perLine.nextToken());
            String rangeNameOpt = perLine.nextToken();
            int rangeStartOpt = Integer.parseInt(perLine.nextToken());
            int rangeEndOpt = Integer.parseInt(perLine.nextToken());
            String fontNameOpt = perLine.nextToken();
            float fontSizeOpt = Float.parseFloat(perLine.nextToken());
            int fontStyleOpt = Integer.parseInt(perLine.nextToken());
            int fontTransformOpt = Integer.parseInt(perLine.nextToken());
            int g2TransformOpt = Integer.parseInt(perLine.nextToken());
            int textToUseOpt = Integer.parseInt(perLine.nextToken());
            int drawMethodOpt = Integer.parseInt(perLine.nextToken());
            int antialiasOpt = Integer.parseInt(perLine.nextToken());
            int fractionalOpt = Integer.parseInt(perLine.nextToken());
            int lcdContrast = Integer.parseInt(perLine.nextToken());
            String[] userTextOpt = new String[]{"Font2DTest!"};
            Object dialogEntry = "Font2DTest!";
            Objects.requireNonNull(this.fp);
            if (textToUseOpt == 2) {
                int numLines = perLine.countTokens();
                int lineNumber = 0;
                if (numLines != 0) {
                    userTextOpt = new String[numLines];
                    dialogEntry = "";
                    while (perLine.hasMoreElements()) {
                        userTextOpt[lineNumber] = perLine.nextToken();
                        dialogEntry = (String)dialogEntry + userTextOpt[lineNumber] + "\n";
                        ++lineNumber;
                    }
                }
            }
            this.displayGridCBMI.setState(displayGridOpt);
            this.force16ColsCBMI.setState(force16ColsOpt);
            this.showFontInfoCBMI.setState(showFontInfoOpt);
            this.rm.setSelectedRange(rangeNameOpt, rangeStartOpt, rangeEndOpt);
            this.fontMenu.setSelectedItem(fontNameOpt);
            this.sizeField.setText(String.valueOf(fontSizeOpt));
            this.styleMenu.setSelectedIndex(fontStyleOpt);
            this.transformMenu.setSelectedIndex(fontTransformOpt);
            this.transformMenuG2.setSelectedIndex(g2TransformOpt);
            this.textMenu.setSelectedIndex(textToUseOpt);
            this.methodsMenu.setSelectedIndex(drawMethodOpt);
            this.antiAliasMenu.setSelectedIndex(antialiasOpt);
            this.fracMetricsMenu.setSelectedIndex(fractionalOpt);
            this.contrastSlider.setValue(lcdContrast);
            this.userTextArea.setText((String)dialogEntry);
            this.updateGUI();
            if (textToUseOpt == this.fp.FILE_TEXT) {
                this.tFileName = perLine.nextToken();
                this.readTextFile(this.tFileName);
            }
            this.fp.loadOptions(displayGridOpt, force16ColsOpt, rangeStartOpt, rangeEndOpt, fontNameOpt, fontSizeOpt, fontStyleOpt, fontTransformOpt, g2TransformOpt, textToUseOpt, drawMethodOpt, antialiasOpt, fractionalOpt, lcdContrast, userTextOpt);
            if (showFontInfoOpt) {
                this.fireUpdateFontInfo();
                this.fontInfoDialog.show();
            } else {
                this.fontInfoDialog.hide();
            }
        }
        catch (Exception ex) {
            this.fireChangeStatus("ERROR: Failed to Load Options File; See Stack Trace", true);
            ex.printStackTrace();
        }
    }

    private void loadComparisonPNG(String fileName) {
        try {
            BufferedImage image = ImageIO.read(new File(fileName));
            JFrame f = new JFrame("Comparison PNG");
            ImagePanel ip = new ImagePanel(image);
            f.setResizable(false);
            f.getContentPane().add(ip);
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ((JFrame)e.getSource()).dispose();
                }
            });
            f.pack();
            f.show();
        }
        catch (Exception ex) {
            this.fireChangeStatus("ERROR: Failed to Load PNG File; See Stack Trace", true);
            ex.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JMenuItem) {
            JMenuItem mi = (JMenuItem)source;
            String itemName = mi.getText();
            if (itemName.equals("Save Selected Options...")) {
                String fileName = this.promptFile(true, "options.txt");
                if (fileName == null) return;
                this.writeCurrentOptions(fileName);
                return;
            }
            if (itemName.equals("Load Options...")) {
                String fileName = this.promptFile(false, "options.txt");
                if (fileName == null) return;
                this.loadOptions(fileName);
                return;
            }
            if (itemName.equals("Save as PNG...")) {
                String fileName = this.promptFile(true, String.valueOf(this.fontMenu.getSelectedItem()) + ".png");
                if (fileName == null) return;
                this.fp.doSavePNG(fileName);
                return;
            }
            if (itemName.equals("Load PNG File to Compare...")) {
                String fileName = this.promptFile(false, null);
                if (fileName == null) return;
                this.loadComparisonPNG(fileName);
                return;
            }
            if (itemName.equals("Page Setup...")) {
                this.fp.doPageSetup();
                return;
            }
            if (itemName.equals("Print...")) {
                this.printDialog.show();
                return;
            }
            if (itemName.equals("Close")) {
                this.parent.dispose();
                return;
            }
            if (!itemName.equals("Exit")) return;
            System.exit(0);
            return;
        }
        if (source instanceof JTextField) {
            JTextField tf = (JTextField)source;
            float sz = 12.0f;
            try {
                sz = Float.parseFloat(this.sizeField.getText());
                if (sz < 1.0f || sz > 120.0f) {
                    sz = 12.0f;
                    this.sizeField.setText("12");
                }
            }
            catch (Exception se) {
                this.sizeField.setText("12");
            }
            if (tf != this.sizeField) return;
            this.fp.setFontParams(this.fontMenu.getSelectedItem(), sz, this.styleMenu.getSelectedIndex(), this.transformMenu.getSelectedIndex());
            return;
        }
        if (source instanceof JButton) {
            String itemName = ((JButton)source).getText();
            if (itemName.equals("Print")) {
                int i = 0;
                while (i < this.printModeCBs.length) {
                    if (this.printModeCBs[i].isSelected()) {
                        this.printDialog.hide();
                        this.fp.doPrint(i);
                    }
                    ++i;
                }
                return;
            }
            if (itemName.equals("Cancel")) {
                this.printDialog.hide();
                return;
            }
            if (!itemName.equals("Update")) return;
            Objects.requireNonNull(this.fp);
            this.fp.setTextToDraw(2, null, this.parseUserText(this.userTextArea.getText()), null);
            return;
        }
        if (!(source instanceof JComboBox)) return;
        JComboBox c = (JComboBox)source;
        if (c == this.fontMenu || c == this.styleMenu || c == this.transformMenu) {
            float sz = 12.0f;
            try {
                sz = Float.parseFloat(this.sizeField.getText());
                if (sz < 1.0f || sz > 120.0f) {
                    sz = 12.0f;
                    this.sizeField.setText("12");
                }
            }
            catch (Exception se) {
                this.sizeField.setText("12");
            }
            this.fp.setFontParams(this.fontMenu.getSelectedItem(), sz, this.styleMenu.getSelectedIndex(), this.transformMenu.getSelectedIndex());
            return;
        }
        if (c == this.methodsMenu) {
            this.fp.setDrawMethod(this.methodsMenu.getSelectedIndex());
            return;
        }
        if (c == this.textMenu) {
            if (canDisplayCheck) {
                this.fireRangeChanged();
            }
            int selected = this.textMenu.getSelectedIndex();
            Objects.requireNonNull(this.fp);
            if (selected == 0) {
                Objects.requireNonNull(this.fp);
                this.fp.setTextToDraw(0, this.rm.getSelectedRange(), null, null);
            } else {
                Objects.requireNonNull(this.fp);
                if (selected == 2) {
                    Objects.requireNonNull(this.fp);
                    this.fp.setTextToDraw(2, null, this.parseUserText(this.userTextArea.getText()), null);
                } else if (selected == this.fp.FILE_TEXT) {
                    String fileName = this.promptFile(false, null);
                    if (fileName == null) {
                        c.setSelectedIndex(this.currentTextChoice);
                        return;
                    }
                    this.tFileName = fileName;
                    this.readTextFile(fileName);
                } else {
                    Objects.requireNonNull(this.fp);
                    if (selected == 1) {
                        Objects.requireNonNull(this.fp);
                        this.fp.setTextToDraw(1, null, null, null);
                    }
                }
            }
            this.updateGUI();
            this.currentTextChoice = selected;
            return;
        }
        if (c == this.transformMenuG2) {
            this.fp.setTransformG2(this.transformMenuG2.getSelectedIndex());
            return;
        }
        if (c != this.antiAliasMenu) {
            if (c != this.fracMetricsMenu) return;
        }
        if (c == this.antiAliasMenu) {
            boolean enabled = FontPanel.AAValues.isLCDMode(this.antiAliasMenu.getSelectedItem());
            this.contrastSlider.setEnabled(enabled);
        }
        this.fp.setRenderingHints(this.antiAliasMenu.getSelectedItem(), this.fracMetricsMenu.getSelectedItem(), this.contrastSlider.getValue());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source instanceof JSlider) {
            this.fp.setRenderingHints(this.antiAliasMenu.getSelectedItem(), this.fracMetricsMenu.getSelectedItem(), this.contrastSlider.getValue());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)source;
            if (cbmi == this.displayGridCBMI) {
                this.fp.setGridDisplay(this.displayGridCBMI.getState());
            } else if (cbmi == this.force16ColsCBMI) {
                this.fp.setForce16Columns(this.force16ColsCBMI.getState());
            } else if (cbmi == this.showFontInfoCBMI) {
                if (this.showFontInfoCBMI.getState()) {
                    this.fireUpdateFontInfo();
                    this.fontInfoDialog.show();
                } else {
                    this.fontInfoDialog.hide();
                }
            }
        }
    }

    private static void printUsage() {
        String usage = "Usage: java -jar Font2DTest.jar [options]\n\nwhere options include:\n    -dcdc | -disablecandisplaycheck disable canDisplay check for font\n    -?    | -help                   print this help message\n\nExample :\n     To disable canDisplay check on font for ranges\n     java -jar Font2DTest.jar -dcdc";
        System.out.println(usage);
        System.exit(0);
    }

    public static void main(String[] argv) {
        if (argv.length > 0) {
            if (argv[0].equalsIgnoreCase("-disablecandisplaycheck") || argv[0].equalsIgnoreCase("-dcdc")) {
                canDisplayCheck = false;
            } else {
                Font2DTest.printUsage();
            }
        }
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        JFrame f = new JFrame("Font2DTest");
        final Font2DTest f2dt = new Font2DTest(f, false);
        f.addWindowListener(new WindowAdapter(){

            public void windowOpening(WindowEvent e) {
                f2dt.repaint();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.getContentPane().add(f2dt);
        f.pack();
        f.show();
    }

    private final class CheckboxMenuItemV2
    extends JCheckBoxMenuItem {
        public CheckboxMenuItemV2(String name, boolean b, ItemListener il) {
            super(name, b);
            this.addItemListener(il);
        }
    }

    private final class MenuItemV2
    extends JMenuItem {
        public MenuItemV2(String name, ActionListener al) {
            super(name);
            this.addActionListener(al);
        }
    }

    private final class LabelV2
    extends JLabel {
        public LabelV2(String name) {
            super(name);
        }
    }

    private final class ChoiceV2Renderer
    extends DefaultListCellRenderer {
        private ImageIcon yesImage;
        private ImageIcon blankImage;
        private ChoiceV2 choice = null;

        public ChoiceV2Renderer(ChoiceV2 choice) {
            BufferedImage yes = new BufferedImage(10, 10, 2);
            Graphics2D g = yes.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Color.BLUE);
            g.drawLine(0, 5, 3, 10);
            g.drawLine(1, 5, 4, 10);
            g.drawLine(3, 10, 10, 0);
            g.drawLine(4, 9, 9, 0);
            g.dispose();
            BufferedImage blank = new BufferedImage(10, 10, 2);
            this.yesImage = new ImageIcon(yes);
            this.blankImage = new ImageIcon(blank);
            this.choice = choice;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int n = Font2DTest.this.textMenu.getSelectedIndex();
            Objects.requireNonNull(Font2DTest.this.fp);
            if (n == 0) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (index == -1) {
                    index = this.choice.getSelectedIndex();
                }
                if (this.choice.getBit(index)) {
                    this.setIcon(this.yesImage);
                } else {
                    this.setIcon(this.blankImage);
                }
            } else {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setIcon(this.blankImage);
            }
            return this;
        }
    }

    private final class ChoiceV2
    extends JComboBox {
        private BitSet bitSet = null;

        public ChoiceV2() {
        }

        public ChoiceV2(ActionListener al) {
            this.addActionListener(al);
        }

        public ChoiceV2(ActionListener al, boolean fontChoice) {
            this(al);
            if (fontChoice) {
                this.setToolTipText("");
                this.bitSet = new BitSet();
                this.setRenderer(font2DTest.new ChoiceV2Renderer(this));
            }
        }

        @Override
        public String getToolTipText() {
            int index = this.getSelectedIndex();
            String fontName = (String)this.getSelectedItem();
            if (fontName != null) {
                int n = Font2DTest.this.textMenu.getSelectedIndex();
                Objects.requireNonNull(Font2DTest.this.fp);
                if (n == 0) {
                    if (this.getBit(index)) {
                        return "Font \"" + fontName + "\" can display some characters in \"" + String.valueOf(Font2DTest.this.rm.getSelectedItem()) + "\" range";
                    }
                    return "Font \"" + fontName + "\" cannot display any characters in \"" + String.valueOf(Font2DTest.this.rm.getSelectedItem()) + "\" range";
                }
            }
            return super.getToolTipText();
        }

        public void setBit(int bitIndex, boolean value) {
            this.bitSet.set(bitIndex, value);
        }

        public boolean getBit(int bitIndex) {
            return this.bitSet.get(bitIndex);
        }
    }

    private final class ButtonV2
    extends JButton {
        public ButtonV2(String name, ActionListener al) {
            super(name);
            this.addActionListener(al);
        }
    }

    private final class ImagePanel
    extends JPanel {
        private final BufferedImage bi;

        public ImagePanel(BufferedImage image) {
            this.bi = image;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.bi.getWidth(), this.bi.getHeight());
        }

        @Override
        public void paintComponent(Graphics g) {
            g.drawImage(this.bi, 0, 0, this);
        }
    }
}

